/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.backend.LEPMCommand;
import COM.livingston.model.LEConfig;
import COM.livingston.model.LEPortMaster;
import COM.livingston.util.LEVector;

public class LEPort
extends LEConfig {
    public static final String DEVICE = "device";
    public static final String DIALIN = "dialin";
    public static final String DIALOUT = "dialout";
    public static final String HARDWIRED = "hardwired";
    public static final String LOGIN = "login";
    public static final String NONE = "none";
    public static final String TWOWAY = "twoway";
    String m_name;

    public LEPort(LEPortMaster pm, String name) {
        super(pm);
        this.m_name = name;
    }

    public Object clone() {
        LEPort config = new LEPort(this.m_pm, this.m_name);
        this.copyTo(config);
        return config;
    }

    public LEVector reset() {
        LEVector errors = null;
        StringBuffer buf = new StringBuffer("reset ");
        buf.append(this.m_name);
        LEPMCommand ret = this.m_pm.execute(buf.toString());
        if (!ret.getStatus()) {
            errors = new LEVector();
            errors.addElement(ret);
        }
        return errors;
    }

    public String getName() {
        return this.m_name;
    }

    boolean makeTypeCommand(LEVector cmds, String portType, String networkType, String device) {
        if (networkType == null) {
            return false;
        }
        StringBuffer buf = new StringBuffer("set ");
        buf.append(this.m_name);
        if (networkType.equals(HARDWIRED)) {
            buf.append(" network hardwired");
        } else {
            boolean isDevice = false;
            if (portType != null) {
                if (portType.equals(TWOWAY) && device.length() > 0) {
                    buf.append(" twoway ");
                    buf.append(device);
                } else if (portType.equals(DEVICE) && device.length() > 0) {
                    buf.append(" device ");
                    buf.append(device);
                } else {
                    buf.append(" login");
                }
            }
            if (networkType.equals(TWOWAY)) {
                buf.append(" network twoway");
            } else if (networkType.equals(DIALIN)) {
                buf.append(" network dialin");
            } else if (networkType.equals(DIALOUT)) {
                buf.append(" network dialout");
            }
        }
        cmds.addElement(new String(buf));
        return true;
    }
}

