/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.backend.LEPMCommand;
import COM.livingston.model.LEConfig;
import COM.livingston.model.LEPortMaster;
import COM.livingston.model.LERoute;
import COM.livingston.model.LETable;
import COM.livingston.util.LEVector;

public class LERoutes
extends LETable {
    public LERoutes(LEPortMaster pm) {
        super(pm);
    }

    public Object clone() {
        LERoutes config = new LERoutes(this.m_pm);
        this.copyTo(config);
        return config;
    }

    public LEVector add(String dest, String gateway, String metric) {
        LEVector errors = null;
        StringBuffer buf = new StringBuffer("add ");
        buf.append("route ");
        buf.append(dest);
        buf.append(" ");
        buf.append(gateway);
        buf.append(" ");
        buf.append(metric);
        LEPMCommand ret = this.m_pm.execute(new String(buf));
        if (ret.getStatus()) {
            ret = this.m_pm.execute("save all");
            this.refresh();
        }
        if (!ret.getStatus()) {
            errors = new LEVector();
            errors.addElement(ret);
        }
        return errors;
    }

    public LEVector delete(String dest) {
        LERoute route = (LERoute)this.get(dest);
        if (route == null) {
            return null;
        }
        String gateway = (String)route.get("75");
        if (gateway == null) {
            return null;
        }
        LEVector errors = null;
        StringBuffer buf = new StringBuffer("delete ");
        buf.append("route ");
        buf.append(dest);
        buf.append(" ");
        buf.append(gateway);
        LEPMCommand ret = this.m_pm.execute(new String(buf));
        if (ret.getStatus()) {
            this.m_fields.remove(dest);
            ret = this.m_pm.execute("save all");
            if (!ret.getStatus()) {
                this.refresh();
            }
        }
        if (!ret.getStatus()) {
            errors = new LEVector();
            errors.addElement(ret);
        }
        return errors;
    }

    LEConfig createConfig(String key) {
        return new LERoute(this.m_pm, key);
    }
}

