/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.util;

import COM.livingston.util.LEOctets;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class LEIPAddress {
    protected static final String ZEROES = new String("0.0.0.0");
    protected static final String ONES = new String("255.255.255.255");
    protected short[] m_address;
    protected String m_name = null;
    protected InetAddress m_inet;

    public LEIPAddress(String string) throws UnknownHostException {
        if (string.equals(ZEROES)) {
            this.m_inet = null;
            this.m_address = new short[4];
            this.m_address[3] = 0;
            this.m_address[2] = 0;
            this.m_address[1] = 0;
            this.m_address[0] = 0;
            return;
        }
        if (string.equals(ONES)) {
            this.m_inet = null;
            this.m_address = new short[4];
            this.m_address[3] = 255;
            this.m_address[2] = 255;
            this.m_address[1] = 255;
            this.m_address[0] = 255;
            return;
        }
        this.m_inet = InetAddress.getByName(string);
        byte[] byArray = this.m_inet.getAddress();
        this.m_address = new short[byArray.length];
        int n = 0;
        while (n < byArray.length) {
            this.m_address[n] = (short)((byArray[n] & 0x7F) + (byArray[n] & 0x80));
            ++n;
        }
    }

    public short[] getAddress() {
        return this.m_address;
    }

    public String getHostName() {
        if (this.m_name == null && this.m_inet != null) {
            String string = this.toString();
            this.m_name = this.m_inet.getHostName();
            if (this.m_name.equals(string)) {
                this.m_name = null;
            }
        }
        return this.m_name;
    }

    public String toString() {
        String string = String.valueOf(Integer.toString(this.m_address[0])) + "." + Integer.toString(this.m_address[1]) + "." + Integer.toString(this.m_address[2]) + "." + Integer.toString(this.m_address[3]);
        return string;
    }

    public static String determineBroadcastAddress(String string, String string2) {
        LEOctets lEOctets = new LEOctets(string);
        LEOctets lEOctets2 = new LEOctets(string2);
        return LEIPAddress.determineBroadcastAddress(lEOctets, lEOctets2);
    }

    public static String determineBroadcastAddress(LEOctets lEOctets, LEOctets lEOctets2) {
        String string = new String("255.255.255.255");
        int n = lEOctets.length();
        if (n == 4) {
            short[] sArray = new short[n];
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            while (n4 < n - 1) {
                short s;
                sArray[n4] = s = lEOctets.getOctets()[n4];
                ++n4;
            }
            n2 = 256 - lEOctets2.getOctets()[n - 1];
            n3 = lEOctets.getOctets()[n - 1] / n2;
            sArray[n - 1] = (short)(n2 + (n3 * n2 - 1));
            LEOctets lEOctets3 = new LEOctets(sArray);
            string = new String(lEOctets3.toString());
        }
        return string;
    }
}

