/*
 * Decompiled with CFR 0.152.
 */
import COM.livingston.amf.LEAMFactory;
import COM.livingston.backend.LEDSSException;
import COM.livingston.backend.LEDSSPortMaster;
import COM.livingston.backend.LEDeltaFactory;
import COM.livingston.backend.LEDeltaIfacesMessage;
import COM.livingston.backend.LEMonIfacesMessage;
import COM.livingston.backend.LEMonitorFactory;
import COM.livingston.backend.LEStatusFactory;
import COM.livingston.backend.LEStatusMessage;
import COM.livingston.model.LEPortMaster;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LEVector;

public class LEMonIfacesView
extends LEMonitorPanel {
    public LEMonIfacesView() {
        this.initialize(1, 2, 7);
        int n = this.getNumColumns();
        int n2 = 2;
        while (n2 < n) {
            this.setCellJustification(n2, 2);
            ++n2;
        }
        this.m_resetCols = new int[7];
        int n3 = 0;
        while (n3 < 7) {
            this.m_resetCols[n3] = n3 + 2;
            ++n3;
        }
    }

    public synchronized void update(LEAMFactory lEAMFactory, String string, Object object) {
        if (object instanceof LEDeltaIfacesMessage) {
            LEDeltaIfacesMessage lEDeltaIfacesMessage = (LEDeltaIfacesMessage)object;
            String string2 = lEDeltaIfacesMessage.getName();
            Integer n = this.getRow(string, string2);
            if (n != null) {
                this.updateRow((int)n, lEDeltaIfacesMessage);
                return;
            }
        } else {
            if (object instanceof LEMonIfacesMessage) {
                LEMonIfacesMessage lEMonIfacesMessage = (LEMonIfacesMessage)object;
                String string3 = lEMonIfacesMessage.getName();
                Integer n = this.getRow(string, string3);
                if (n == null) {
                    this.createRow(string, string3, lEMonIfacesMessage);
                    return;
                }
                this.updateRow((int)n, lEMonIfacesMessage);
                return;
            }
            if (object instanceof LEStatusMessage) {
                this.updateStatus(string, (LEStatusMessage)object);
            }
        }
    }

    void createColumnTitles(int n, int n2, Object[] objectArray) {
        objectArray[n2++] = new String("Interface");
        objectArray[n2++] = new String("In Packets");
        objectArray[n2++] = new String("Out Packets");
        objectArray[n2++] = new String("In Errors");
        objectArray[n2++] = new String("Out Errors");
        objectArray[n2++] = new String("Collisions");
        objectArray[n2++] = new String("Resets");
        objectArray[n2++] = new String("Queue");
    }

    void createRow(String string, String string2, LEMonIfacesMessage lEMonIfacesMessage) {
        Object[] objectArray = new Object[this.getNumColumns()];
        int n = 0;
        objectArray[n++] = string;
        objectArray[n++] = lEMonIfacesMessage.getInterfaceName();
        objectArray[n++] = new Long(lEMonIfacesMessage.getInPackets());
        objectArray[n++] = new Long(lEMonIfacesMessage.getOutPackets());
        objectArray[n++] = new Long(lEMonIfacesMessage.getInErrors());
        objectArray[n++] = new Long(lEMonIfacesMessage.getOutErrors());
        objectArray[n++] = new Long(lEMonIfacesMessage.getCollisions());
        objectArray[n++] = new Long(lEMonIfacesMessage.getResets());
        objectArray[n++] = new Long(lEMonIfacesMessage.getQueue());
        this.addRow(string, string2, objectArray);
    }

    void updateRow(int n, LEMonIfacesMessage lEMonIfacesMessage) {
        LEMonitorData lEMonitorData = (LEMonitorData)this.getRowObject(n);
        if (lEMonitorData == null) {
            return;
        }
        int n2 = 0;
        ++n2;
        this.setCellItem(n, ++n2, lEMonitorData.getCounter(n2, lEMonIfacesMessage.getInPackets()));
        this.setCellItem(n, ++n2, lEMonitorData.getCounter(n2, lEMonIfacesMessage.getOutPackets()));
        this.setCellItem(n, ++n2, lEMonitorData.getCounter(n2, lEMonIfacesMessage.getInErrors()));
        this.setCellItem(n, ++n2, lEMonitorData.getCounter(n2, lEMonIfacesMessage.getOutErrors()));
        this.setCellItem(n, ++n2, lEMonitorData.getCounter(n2, lEMonIfacesMessage.getCollisions()));
        this.setCellItem(n, ++n2, lEMonitorData.getCounter(n2, lEMonIfacesMessage.getResets()));
        this.setCellItem(n, ++n2, lEMonitorData.getCounter(n2, lEMonIfacesMessage.getQueue()));
    }

    void updateRow(int n, LEDeltaIfacesMessage lEDeltaIfacesMessage) {
        LEMonitorData lEMonitorData = (LEMonitorData)this.getRowObject(n);
        if (lEMonitorData == null) {
            return;
        }
        int n2 = 0;
        ++n2;
        ++n2;
        if (lEDeltaIfacesMessage.getInPacketsChanged()) {
            this.setCellItem(n, n2, lEMonitorData.getCounter(n2, lEDeltaIfacesMessage.getInPackets()));
        }
        ++n2;
        if (lEDeltaIfacesMessage.getOutPacketsChanged()) {
            this.setCellItem(n, n2, lEMonitorData.getCounter(n2, lEDeltaIfacesMessage.getOutPackets()));
        }
    }

    void startMonitoring(LEPortMaster lEPortMaster) {
        String string = lEPortMaster.getHostname();
        LEStatusFactory.GetFactory().addObserver(string, this);
        LEMonitorFactory.GetFactory().addObserver(string, this);
        LEDeltaFactory.GetFactory().addObserver(string, this);
        LEDSSPortMaster lEDSSPortMaster = lEPortMaster.getDSS();
        try {
            long l = lEDSSPortMaster.monitor(0x120000, 30000);
            LEVector lEVector = new LEVector();
            lEVector.addElement(new Long(l));
            this.m_monitors.put(string, lEVector);
            l = lEDSSPortMaster.delta(0x120000, 1000);
            lEVector = new LEVector();
            lEVector.addElement(new Long(l));
            this.m_deltas.put(string, lEVector);
            return;
        }
        catch (LEDSSException lEDSSException) {
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return;
        }
    }
}

