/*
 * Decompiled with CFR 0.152.
 */
package oracle.help;

import java.applet.AppletContext;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.net.URL;
import java.util.Enumeration;
import oracle.ewt.help.HelpProvider;
import oracle.help.Book;
import oracle.help.HelpBook;
import oracle.help.TopicNotFoundException;
import oracle.help.context.GlobalContext;
import oracle.help.util.Canonicalizer;

public final class Help
implements HelpProvider {
    private Book _defaultBook;
    private String _defaultTopic;
    private GlobalContext _context = new GlobalContext();

    public Help() {
        try {
            this._context.setHTMLBrowser(Class.forName("oracle.help.htmlBrowser.HotJavaBrowser"));
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            System.out.println("Oracle Help : Failed to load HotJavaBrowser");
            return;
        }
    }

    public Help(AppletContext appletContext) {
        this._context.setAppletContext(appletContext);
    }

    public Help(Class clazz) {
        this._context.setHTMLBrowser(clazz);
    }

    public static Book createBook(String string, String string2, String string3) {
        if (!string.startsWith("systemresource")) {
            string = Canonicalizer.fixPathname(string);
            string = Canonicalizer.fixSeparators(string);
        }
        return HelpBook.getBook(string, string2, string3);
    }

    public static Book createBook(Class clazz, String string, String string2, String string3) {
        String string4 = Help.constructDirectoryURL(clazz, string, string2.concat(".hhc"));
        if (string4 != null) {
            return Help.createBook(string4, string2, string3);
        }
        string4 = Help.constructDirectoryURL(clazz, string, string2.concat(".oht"));
        if (string4 != null) {
            return Help.createBook(string4, string2, string3);
        }
        string4 = Help.constructDirectoryURL(clazz, string, string2.concat(".hhk"));
        if (string4 != null) {
            return Help.createBook(string4, string2, string3);
        }
        string4 = Help.constructDirectoryURL(clazz, string, string2.concat(".idx"));
        if (string4 != null) {
            return Help.createBook(string4, string2, string3);
        }
        string4 = Help.constructDirectoryURL(clazz, string, string2.concat(".toc"));
        if (string4 != null) {
            return Help.createBook(string4, string2, string3);
        }
        string4 = Help.constructDirectoryURL(clazz, string, string2.concat(".tok"));
        if (string4 != null) {
            return Help.createBook(string4, string2, string3);
        }
        return null;
    }

    private static String constructDirectoryURL(Class clazz, String string, String string2) {
        try {
            URL uRL = null;
            uRL = string.equals(".") || string.equals("./") || string.equals(".\\") ? clazz.getResource(string2) : clazz.getResource(String.valueOf(string) + "/" + string2);
            if (uRL != null) {
                int n = uRL.toString().lastIndexOf(string2);
                return uRL.toString().substring(0, n);
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public void setVisible(boolean bl) {
        this._context.setVisible(bl);
    }

    public void addBook(Book book) {
        this._context.addBook((HelpBook)book, -1, true);
    }

    public void addBook(Book book, int n, boolean bl) {
        this._context.addBook((HelpBook)book, n, bl);
    }

    public void removeBook(Book book) {
        this._context.removeBook((HelpBook)book);
    }

    public void removeAllBooks() {
        while (this._context.getBookCount() > 0) {
            HelpBook helpBook = this._context.getBookAt(0);
            this._context.removeBook(helpBook);
        }
    }

    public void replaceBook(int n, Book book) throws ArrayIndexOutOfBoundsException {
        this._context.replaceBook(n, (HelpBook)book);
    }

    public Enumeration getBooks() {
        return this._context.getBooks();
    }

    public int getBookCount() {
        return this._context.getBookCount();
    }

    public Book getBookAt(int n) throws ArrayIndexOutOfBoundsException {
        return this._context.getBookAt(n);
    }

    public void setBookVisible(Book book, boolean bl) {
        this._context.setBookVisible((HelpBook)book, bl);
    }

    public void setAllBooksVisible(boolean bl) {
        int n = 0;
        while (n < this._context.getBookCount()) {
            HelpBook helpBook = this._context.getBookAt(n);
            this._context.setBookVisible(helpBook, bl);
            ++n;
        }
    }

    public void showContents() {
        this._context.showContents();
    }

    public void showIndex() {
        this._context.showIndex();
    }

    public void showSearch() {
        this._context.showSearchDialog();
    }

    public void showTopic(Book book, String string) throws TopicNotFoundException {
        this._context.showTopic((HelpBook)book, string);
    }

    public void showTopic(Book book, String string, boolean bl) throws TopicNotFoundException {
        this._context.showTopic((HelpBook)book, string, bl, null, null);
    }

    public void showTopic(Book book, String string, boolean bl, Point point) throws TopicNotFoundException {
        this._context.showTopic((HelpBook)book, string, bl, point, null);
    }

    public void showTopic(Book book, String string, boolean bl, Dimension dimension) throws TopicNotFoundException {
        this._context.showTopic((HelpBook)book, string, bl, null, dimension);
    }

    public void showTopic(Book book, String string, boolean bl, Point point, Dimension dimension) throws TopicNotFoundException {
        this._context.showTopic((HelpBook)book, string, bl, point, dimension);
    }

    public void showHelp(Object object, String string) {
        this.showHelp(object, string, null);
    }

    public void showHelp(Object object, String string, Component component) {
        if (object == null) {
            object = this._defaultBook;
        }
        if (string == null) {
            string = this._defaultTopic;
        }
        if (object == null || string == null) {
            this._context.showContents();
            return;
        }
        Book book = (Book)object;
        this._context.showTopic((HelpBook)book, string);
    }

    public void setDefaultBook(Book book) {
        this._defaultBook = book;
    }

    public void setDefaultTopic(String string) {
        this._defaultTopic = string;
    }

    public Book getDefaultBook() {
        return this._defaultBook;
    }

    public String getDefaultTopic() {
        return this._defaultTopic;
    }

    public void dispose() {
        this._context.dispose();
        this._context = null;
    }

    protected void finalize() throws Throwable {
        this._context.dispose();
        this._context = null;
        super.finalize();
    }
}

