/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.util;

import oracle.help.HelpBook;
import oracle.help.util.TreeNode;

public class TreeRoot
extends TreeNode {
    private static final int HASHTABLE_SIZE = 511;
    private TreeNode[] _hashTable;
    private String _baseURL;
    private HelpBook _book;

    public TreeRoot() {
        this(false);
    }

    public TreeRoot(boolean bl) {
        if (bl) {
            this._hashTable = new TreeNode[511];
            int n = 0;
            while (n < 511) {
                this._hashTable[n] = null;
                ++n;
            }
            return;
        }
        this._hashTable = null;
    }

    public String getBaseURL() {
        return this._baseURL;
    }

    public void setBaseURL(String string) {
        this._baseURL = string;
    }

    public HelpBook getBook() {
        return this._book;
    }

    public void setBook(HelpBook helpBook) {
        this._book = helpBook;
    }

    public TreeNode get(String string) {
        int n = string.hashCode() % 511;
        if (n < 0) {
            n = -n;
        }
        TreeNode treeNode = this._hashTable[n];
        while (treeNode != null) {
            if (string.equals(treeNode.getUrl())) {
                return treeNode;
            }
            treeNode = treeNode.getNext();
        }
        return null;
    }

    public void addChild(TreeNode treeNode) {
        this.setRoot(this);
        super.addChild(treeNode);
    }

    protected void hash(TreeNode treeNode) {
        if (this._hashTable != null) {
            int n = treeNode.hashCode() % 511;
            if (n < 0) {
                n = -n;
            }
            treeNode.setNext(this._hashTable[n]);
            this._hashTable[n] = treeNode;
        }
    }
}

