
#  This program is written in sh code, abd uses awk and sed.  It
#  should work provided you have all these programs on your machine.
#  To run this script you will need to have Java installed (however, it
#  will handle a lack of Java nicely).  It also requires a 
#  Java-style properties file and a Java program in the file "lax.jar".

#  This file requires a property file name, with the following 
#  properties
#	REQUIRED:
#	1)  LAX.class.path  classpath (do not include the environment variable $CLASSPATH)
#	2)  LAX.NL.java.launcher.main.class  (main class of LaunchAnywhere Executable)
#	3)  LAX.currentVM  (VM to launch with)
#	OPTIONAL
#	4)  LAX.user.dir (user directory to set when launching)
#	5)  LAX.stdout.redirect (values are: null, console, <filename>)
#	6)  LAX.stderr.redirect (values are: null, console, <filename>)


if [ ! -r $propfname ];
then 	
		echo "*********************************************";
		echo "*  Couldn't find properties file $propfname *";
		echo "*  Please be sure it is in the same         *";
		echo "*  directory as this shell script.          *";
		echo "*********************************************";
		exit;
fi;

#  Get the necessary properties
#  from the .lax file

#  AWK program
getparam='BEGIN { FS="=" } { if(index($1,"#")!=1) if($1==value) print $2}'

clp=`awk 	"$getparam" value="LAX.class.path" $propfname`
mainc=`awk 	"$getparam" value="LAX.NL.java.launcher.main.class" $propfname`
vm=`awk 	"$getparam" value="LAX.NL.current.VM" $propfname`
ud=`awk 	"$getparam" value="LAX.set.user.dir" $propfname`
out=`awk 	"$getparam" value="LAX.stdout.redirect" $propfname`
err=`awk 	"$getparam" value="LAX.stderr.redirect" $propfname`
insdir=`awk 	"$getparam" value="LAX.NL.install.dir" $propfname`
ask=`awk 	"$getparam" value="LAX.always.ask" $propfname`

if [ ${out:-""} = "" ]
then
	out="notconsole"
elif [ $out = "null" ]
then
	out="notconsole"
elif [ $out = "NULL" ]
then
	out="notconsole"
fi

if [ ${err:-""} = "" ]
then
	err="notconsole"
elif [ $err = "null" ]
then
	err="notconsole"
elif [ $err = "NULL" ]
then
	err="notconsole"
fi

if [ ${clp:-""} = "" ]
then
	echo  "******************************"
	echo  "*  Classpath in Properties   *"
	echo  "*  is invalid.  Try          *"
	echo  "*  reinstalling.             *"
	echo  "*****************************"
fi
if [ ${mainc:-""} = "" ]
then
	echo  "******************************"
	echo  "*  Main Class is not defined *"
	echo  "*  in the properties file    *"
	echo  "*  Try reinstalling.         *"
	echo  "******************************"
fi

# Change to working directory
oldir=`pwd`
if [ ! ${ud:-""} = "" ]
then
	if [ $ud = "." ];
	then
		cd $insdir
	else
		cd $ud;
	fi
fi

#  Look for java from props file on path 
if [ ${ask:-"false"} = "true" ]
then
	vm="";
fi
if [ ! -x "$vm" ];
then
	#  Look for javas on path
	echo "***************************";
	echo "*  Please choose a VM...  *";
	echo "***************************";
	echo "*  This program requires  *";
	echo "*  a Java Virtual Machine *";
	echo "*  to run.                *";
	echo "***************************";
	getpaths='BEGIN {FS=":"}{ for(i=1;i<=NF;i++) print $i; }'

	#  some found in path
	#  print list of javas and jres
	pathc=1
	for file in `echo $PATH|awk "$getpaths"`
	do
		if [ -x $file/java ]
		then
			echo $pathc: $file/java
			eval part$pathc="$file/java"
			pathc=`expr $pathc + 1`
		fi
		if [ -x $file/jre ]
		then
			echo $pathc: $file/jre
			eval part$pathc="$file/jre"
			pathc=`expr $pathc + 1`
		fi
	done

	echo "q:  Quit."
	
	#  none found in path
	if [ $pathc -eq 1 ]
	then
		echo "***************************************"
		echo "*  Could not find Java on your path   *"
		echo "*  You must install Java to your path *"
		echo "*  before running this application.   *"
		echo "***************************************"
		exit
	fi
	#  take selection
	echo "Please choose an available Java Virtual Machine from the list above (number):  "
	read sel

  	#  Check that it is valid
  	if [ $sel -eq "q" ] || [ $sel -eq "Q" ] 
  	then 
  		exit 
  	fi
  	
	if [ $sel -lt 1 ] || [ $sel -ge $pathc ]
	then
		echo "**  Invalid Selection:  This program will terminate"
	else
#		eval echo "Running with \$part$sel"
		eval newvm="\$part$sel"
		
#		echo "new vm:  $newvm"
#		echo "old vm:  \"$vm\""

		vmparentpath='BEGIN { FS="" }{ len=length($1); \
								if(substr($1,len-3,4)=="java") print substr($1,0,len-4); \
								else if(substr($1,len-2,3)=="jre") print substr($1,0,len-3)}'

		sysclassesroot=`echo $newvm|awk 	"$vmparentpath"`
		#echo $sysclassesroot
		sysclasses="$sysclassesroot../classes:$sysclassesroot../lib/classes.jar:$sysclassesroot../lib/rt.jar:$sysclassesroot../lib/i18n.jar:$sysclassesroot../lib/classes.zip"
		#echo $sysclasses


		#  update the props file
		sedscript="s;LAX.NL.current.VM.*;LAX.NL.current.VM=$newvm;"
		sed $sedscript $propfname>file.lax 
		mv $propfname $propfname.bak &> /dev/null > /dev/null
		mv file.lax $propfname &> /dev/null > /dev/null

		#  launch with classpath,  
		if [ $out = "console" ] && [ $err = "console" ];
		then
			echo out: $out    err: $err
			$newvm -classpath $clp:$sysclasses:$CLASSPATH $mainc $propfname ${1:+"$1"} ${2:+"$2"} ${3:+"$3"} ${4:+"$4"} ${5:+"$5"} ${6:+"$6"} ${7:+"$7"} ${8:+"$8"} ${9:+"$9"}
		elif [ $out = "console" ]
		then
			#echo Starting with standard error supressed
			$newvm -classpath $clp:$sysclasses:$CLASSPATH $mainc $propfname ${1:+"$1"} ${2:+"$2"} ${3:+"$3"} ${4:+"$4"} ${5:+"$5"} ${6:+"$6"} ${7:+"$7"} ${8:+"$8"} ${9:+"$9"} 2> /dev/null
		elif [ $err = "console" ]
		then
			#echo Starting with standard output supressed
			$newvm -classpath $clp:$sysclasses:$CLASSPATH $mainc $propfname ${1:+"$1"} ${2:+"$2"} ${3:+"$3"} ${4:+"$4"} ${5:+"$5"} ${6:+"$6"} ${7:+"$7"} ${8:+"$8"} ${9:+"$9"} 1> /dev/null
		else
			#echo Starting with ALL output supressed
			$newvm -classpath $clp:$sysclasses:$CLASSPATH $mainc $propfname ${1:+"$1"} ${2:+"$2"} ${3:+"$3"} ${4:+"$4"} ${5:+"$5"} ${6:+"$6"} ${7:+"$7"} ${8:+"$8"} ${9:+"$9"} 1> /dev/null 2> /dev/null
		fi
	fi


else #echo "Using vm from properties file:  "$vm;
	#  found prop file vm on path

	#  Find support classes for VM
	#echo $vm

	vmparentpath='BEGIN { FS="" }{ len=length($1); \
							if(substr($1,len-3,4)=="java") print substr($1,0,len-4); \
							else if(substr($1,len-2,3)=="jre") print substr($1,0,len-3)}'

	sysclassesroot=`echo $vm|awk 	"$vmparentpath"`
	sysclasses="$sysclassesroot../classes:$sysclassesroot../lib/classes.jar:$sysclassesroot../lib/rt.jar:$sysclassesroot../lib/i18n.jar:$sysclassesroot../lib/classes.zip"
	#echo $sysclasses

	#  launch with classpath
	if [ $out = "console" ] && [ $err = "console" ];
	then
		echo out: $out    err: $err
		$vm -classpath $clp:$sysclasses:$CLASSPATH $mainc $propfname ${1:+"$1"} ${2:+"$2"} ${3:+"$3"} ${4:+"$4"} ${5:+"$5"} ${6:+"$6"} ${7:+"$7"} ${8:+"$8"} ${9:+"$9"}
	elif [ $out = "console" ]
	then
		#echo Starting with standard error supressed
		$vm -classpath $clp:$sysclasses:$CLASSPATH $mainc $propfname ${1:+"$1"} ${2:+"$2"} ${3:+"$3"} ${4:+"$4"} ${5:+"$5"} ${6:+"$6"} ${7:+"$7"} ${8:+"$8"} ${9:+"$9"} 2> /dev/null
	elif [ $err = "console" ]
	then
		#echo Starting with standard output supressed
		$vm -classpath $clp:$sysclasses:$CLASSPATH $mainc $propfname ${1:+"$1"} ${2:+"$2"} ${3:+"$3"} ${4:+"$4"} ${5:+"$5"} ${6:+"$6"} ${7:+"$7"} ${8:+"$8"} ${9:+"$9"} 1> /dev/null
	else
		#echo Starting with ALL output supressed
		$vm -classpath $clp:$sysclasses:$CLASSPATH $mainc $propfname ${1:+"$1"} ${2:+"$2"} ${3:+"$3"} ${4:+"$4"} ${5:+"$5"} ${6:+"$6"} ${7:+"$7"} ${8:+"$8"} ${9:+"$9"} 1> /dev/null 2> /dev/null
	fi
#	$vm -classpath $clp:$CLASSPATH $mainc $propfname	 > /dev/null
fi

#  Change back to directory used priory to this script running.
cd $olddir
