/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt;

import java.awt.Adjustable;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import oracle.ewt.border.Border;
import oracle.ewt.border.BorderManager;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.painter.Fill;
import oracle.ewt.scrolling.Scrollable;
import oracle.ewt.scrolling.ScrollableException;
import oracle.ewt.thread.Task;
import oracle.ewt.thread.TaskEvent;
import oracle.ewt.thread.TaskScheduler;

public class EwtComponent
extends LWComponent
implements BorderManager,
Scrollable {
    private static String _sDefaultName = null;
    private static int _sInstanceCounter;
    private boolean _damaged;
    private Border _border;
    private Rectangle _canvasRect;
    private Fill _canvasFill;
    private transient Validater _validater;

    public EwtComponent() {
        if (this.isHScrollable() || this.isVScrollable()) {
            this._canvasRect = new Rectangle();
        }
    }

    public void setBorder(Border border) {
        if (this._border != border) {
            if (this._border != null) {
                this._border.unmanageNotify();
            }
            this._border = border;
            if (border != null) {
                border.manageNotify(this);
            }
            this.borderResizeNotify();
        }
    }

    public Border getBorder() {
        return this._border;
    }

    public void setCanvasFill(Fill fill) {
        this._canvasFill = fill;
        this.repaint();
    }

    public Fill getCanvasFill() {
        return this._canvasFill;
    }

    public final void invalidateCanvas() {
        if (this.isShowing()) {
            this.invalidate();
            if (this._validater == null) {
                this._validater = new Validater();
            }
            TaskScheduler.getDefaultTaskScheduler().schedule(this._validater, 0);
        }
    }

    public final void repaintCanvas() {
        Insets insets = this.getInsets();
        Dimension dimension = this.getInnerSize();
        this.repaint(insets.left, insets.top, dimension.width, dimension.height);
    }

    public final void repaintCanvas(int n, int n2, int n3, int n4) {
        Insets insets = this.getInsets();
        Point point = this.getCanvasOrigin();
        this.repaint(n + insets.left + point.x, n2 + insets.top + point.y, n3, n4);
    }

    public final void paintImmediateCanvas() {
        Insets insets = this.getInsets();
        Dimension dimension = this.getInnerSize();
        this.paintImmediate(insets.left, insets.top, dimension.width, dimension.height);
    }

    public final void paintImmediateCanvas(int n, int n2, int n3, int n4) {
        Insets insets = this.getInsets();
        Point point = this.getCanvasOrigin();
        this.paintImmediate(n + insets.left + point.x, n2 + insets.top + point.y, n3, n4);
    }

    public final Point convertOuterToCanvas(int n, int n2) {
        Point point = this.getCanvasOrigin();
        Insets insets = this.getInsets();
        point.x = n - point.x - insets.left;
        point.y = n2 - point.y - insets.top;
        return point;
    }

    public final Point convertCanvasToOuter(int n, int n2) {
        Point point = this.getCanvasOrigin();
        Insets insets = this.getInsets();
        point.x += n + insets.left;
        point.y += n2 + insets.top;
        return point;
    }

    public final Dimension convertInnerToOuterSize(int n, int n2) {
        Dimension dimension = new Dimension(n, n2);
        Insets insets = this.getInsets();
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    public final Dimension getInnerSize() {
        Dimension dimension = this.getSize();
        Insets insets = this.getInsets();
        dimension.width -= insets.left + insets.right;
        dimension.height -= insets.top + insets.bottom;
        if (dimension.width < 0) {
            dimension.width = 0;
        }
        if (dimension.height < 0) {
            dimension.height = 0;
        }
        return dimension;
    }

    public final Point getInnerOrigin() {
        Insets insets = this.getInsets();
        return new Point(insets.left, insets.top);
    }

    public final Rectangle getInnerBounds() {
        Point point = this.getInnerOrigin();
        Dimension dimension = this.getInnerSize();
        return new Rectangle(point.x, point.y, dimension.width, dimension.height);
    }

    public Color getBorderBackground() {
        return this.getBackground();
    }

    public Color getBorderForeground() {
        return this.getForeground();
    }

    public void borderRepaintNotify() {
        this.repaint();
    }

    public void borderResizeNotify() {
        this.invalidate();
        this.repaint();
    }

    public void attachHAdjustable(Adjustable adjustable) throws ScrollableException {
        throw new ScrollableException();
    }

    public void attachVAdjustable(Adjustable adjustable) throws ScrollableException {
        throw new ScrollableException();
    }

    public void detachAdjustable(Adjustable adjustable) throws ScrollableException {
        throw new ScrollableException();
    }

    public final Rectangle getCanvasBounds() {
        Rectangle rectangle = this.getInnerBounds();
        rectangle.x = 0;
        rectangle.y = 0;
        if (this.isHScrollable()) {
            rectangle.x = this._canvasRect.x;
            rectangle.width = this._canvasRect.width;
        }
        if (this.isVScrollable()) {
            rectangle.y = this._canvasRect.y;
            rectangle.height = this._canvasRect.height;
        }
        return rectangle;
    }

    public final Point getCanvasOrigin() {
        Point point = new Point(0, 0);
        if (this.isHScrollable()) {
            point.x = this._canvasRect.x;
        }
        if (this.isVScrollable()) {
            point.y = this._canvasRect.y;
        }
        return point;
    }

    public final Dimension getCanvasSize() {
        Dimension dimension = this.getInnerSize();
        if (this.isHScrollable()) {
            dimension.width = this._canvasRect.width;
        }
        if (this.isVScrollable()) {
            dimension.height = this._canvasRect.height;
        }
        return dimension;
    }

    public Adjustable getHAdjustable() {
        return null;
    }

    public Adjustable getVAdjustable() {
        return null;
    }

    public void handleHScroll(int n, int n2) throws ScrollableException {
        if (!this.isHScrollable()) {
            throw new ScrollableException();
        }
        this._shiftCanvasX(this.getHOffsetOfValue(n));
    }

    public void handleVScroll(int n, int n2) throws ScrollableException {
        if (!this.isVScrollable()) {
            throw new ScrollableException();
        }
        this._shiftCanvasY(this.getVOffsetOfValue(n));
    }

    public boolean isHScrollable() {
        return false;
    }

    public boolean isVScrollable() {
        return false;
    }

    public void setCanvasOrigin(int n, int n2) throws ScrollableException {
        Adjustable adjustable;
        Point point = this.getCanvasOrigin();
        if (n != point.x) {
            if (!this.isHScrollable()) {
                throw new ScrollableException();
            }
            this._shiftCanvasX(n);
            adjustable = this.getHAdjustable();
            if (adjustable != null) {
                adjustable.setValue(this.getHValueOfOffset(n));
            }
        }
        if (n2 != point.y) {
            if (!this.isVScrollable()) {
                throw new ScrollableException();
            }
            this._shiftCanvasY(n2);
            adjustable = this.getVAdjustable();
            if (adjustable != null) {
                adjustable.setValue(this.getVValueOfOffset(n2));
            }
        }
    }

    public final void clipCanvasToParents(Rectangle rectangle) {
        int n;
        Point point = this.getCanvasOrigin();
        Insets insets = this.getInsets();
        rectangle.x += point.x + insets.left;
        rectangle.y += point.y + insets.top;
        this.clipToParents(rectangle);
        if (rectangle.x < insets.left) {
            rectangle.width -= insets.left - rectangle.x;
            rectangle.x = insets.left;
        }
        if (rectangle.y < insets.top) {
            rectangle.height -= insets.top - rectangle.y;
            rectangle.y = insets.top;
        }
        Dimension dimension = this.getInnerSize();
        int n2 = dimension.width - (rectangle.x - insets.left);
        if (rectangle.width > n2) {
            rectangle.width = n2;
        }
        if (rectangle.height > (n = dimension.height - (rectangle.y - insets.top))) {
            rectangle.height = n;
        }
        rectangle.x -= point.x + insets.left;
        rectangle.y -= point.y + insets.top;
    }

    public boolean isTransparent() {
        if (!super.isTransparent()) {
            return false;
        }
        Fill fill = this.getCanvasFill();
        if (fill != null) {
            return fill.isTransparent();
        }
        return true;
    }

    public void addNotify() {
        super.addNotify();
        this._damaged = false;
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
        this._damaged = true;
        super.repaint(l, n, n2, n3, n4);
    }

    public final synchronized void layout() {
        super.layout();
        Dimension dimension = this.layoutCanvas();
        this.setCanvasSize(dimension.width, dimension.height);
    }

    public final Insets insets() {
        if (this._border != null) {
            return this._border.getInsets();
        }
        return new Insets(0, 0, 0, 0);
    }

    public final void paintInterior(Graphics graphics) {
        this._damaged = false;
        Rectangle rectangle = this.getInnerBounds();
        Rectangle rectangle2 = graphics.getClipBounds();
        if (!this._isContainedBy(rectangle2, rectangle)) {
            this._paintBorder(graphics);
        }
        int n = rectangle.width;
        int n2 = rectangle.height;
        if (n > 0 && n2 > 0) {
            Point point = this.getCanvasOrigin();
            int n3 = rectangle.x + point.x;
            int n4 = rectangle.y + point.y;
            graphics.translate(n3, n4);
            graphics.clipRect(-point.x, -point.y, n, n2);
            Fill fill = this.getCanvasFill();
            if (fill != null) {
                Dimension dimension = this.getCanvasSize();
                fill.paint(graphics, Math.max(dimension.width, n), Math.max(dimension.height, n2), this.getPaintContext());
            }
            this.paintCanvasInterior(graphics);
        }
    }

    protected EwtComponent getProxyConfigurer() {
        return null;
    }

    protected void paintCanvasInterior(Graphics graphics) {
    }

    protected int getHMaximum() {
        EwtComponent ewtComponent = this.getProxyConfigurer();
        if (ewtComponent != null) {
            return ewtComponent.getHMaximum();
        }
        return this.getCanvasSize().width;
    }

    protected int getHValueOfOffset(int n) {
        EwtComponent ewtComponent = this.getProxyConfigurer();
        if (ewtComponent != null) {
            return ewtComponent.getHValueOfOffset(n);
        }
        return -n;
    }

    protected int getHOffsetOfValue(int n) {
        EwtComponent ewtComponent = this.getProxyConfigurer();
        if (ewtComponent != null) {
            return ewtComponent.getHOffsetOfValue(n);
        }
        return -n;
    }

    protected int getVMaximum() {
        EwtComponent ewtComponent = this.getProxyConfigurer();
        if (ewtComponent != null) {
            return ewtComponent.getVMaximum();
        }
        return this.getCanvasSize().height;
    }

    protected int getVOffsetOfValue(int n) {
        EwtComponent ewtComponent = this.getProxyConfigurer();
        if (ewtComponent != null) {
            return ewtComponent.getVOffsetOfValue(n);
        }
        return -n;
    }

    protected int getVValueOfOffset(int n) {
        EwtComponent ewtComponent = this.getProxyConfigurer();
        if (ewtComponent != null) {
            return ewtComponent.getVValueOfOffset(n);
        }
        return -n;
    }

    protected Dimension layoutCanvas() {
        return new Dimension(0, 0);
    }

    protected void setCanvasSize(int n, int n2) {
        Fill fill;
        boolean bl = false;
        if (this.isHScrollable()) {
            if (this._canvasRect.width != n) {
                this._canvasRect.width = n;
                bl = true;
            }
            this._configureHAdjustable();
        }
        if (this.isVScrollable()) {
            if (this._canvasRect.height != n2) {
                this._canvasRect.height = n2;
                bl = true;
            }
            this._configureVAdjustable();
        }
        if (bl && (fill = this.getCanvasFill()) != null && fill.damageOnResize()) {
            this.repaintCanvas();
        }
    }

    protected final void makeCanvasGraphics(Graphics graphics) {
        if (graphics != null) {
            Rectangle rectangle = this.getInnerBounds();
            this.clipToParents(rectangle);
            Point point = this.getCanvasOrigin();
            graphics.translate(rectangle.x + point.x, rectangle.y + point.y);
            graphics.clipRect(-point.x, -point.y, rectangle.width, rectangle.height);
        }
    }

    protected final Graphics getCanvasGraphics() {
        Graphics graphics = this.getGraphics();
        this.makeCanvasGraphics(graphics);
        return graphics;
    }

    protected String paramString() {
        String string = super.paramString();
        Border border = this.getBorder();
        if (border != null) {
            string = String.valueOf(string) + ", " + border.toString();
        }
        return string;
    }

    protected String getDefaultName() {
        if (_sDefaultName == null) {
            _sDefaultName = this.getBaseClassName();
        }
        return String.valueOf(_sDefaultName) + _sInstanceCounter++;
    }

    private boolean _isContainedBy(Rectangle rectangle, Rectangle rectangle2) {
        return rectangle.x >= rectangle2.x && rectangle.y >= rectangle2.y && rectangle.x + rectangle.width <= rectangle2.x + rectangle2.width && rectangle.y + rectangle.height <= rectangle2.y + rectangle2.height;
    }

    private void _paintBorder(Graphics graphics) {
        Border border = this.getBorder();
        if (border != null) {
            Dimension dimension = this.getSize();
            border.paint(graphics, 0, 0, dimension.width, dimension.height, this);
        }
    }

    private boolean _isDamaged() {
        return false;
    }

    private void _shiftCanvasX(int n) {
        block12: {
            Point point = this.getCanvasOrigin();
            if (n == point.x) {
                return;
            }
            this.freezeRepaints();
            try {
                Rectangle rectangle = this.getInnerBounds();
                this.clipToParents(rectangle);
                int n2 = n - point.x;
                if (this.isClippedBySibling() || this.isTransparent() || this._isDamaged() || Math.abs(n2) >= rectangle.width) {
                    this._canvasRect.x = n;
                    if (this._isDamaged()) {
                        this.repaintCanvas();
                    } else {
                        this.paintImmediateCanvas();
                    }
                    break block12;
                }
                this.getToolkit().sync();
                Graphics graphics = this.getGraphics();
                if (graphics == null) {
                    this._canvasRect.x = n;
                    this.repaintCanvas();
                    break block12;
                }
                graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                graphics.copyArea(rectangle.x, rectangle.y, rectangle.width, rectangle.height, n2, 0);
                graphics.dispose();
                Rectangle rectangle2 = new Rectangle();
                rectangle2.y = rectangle.y;
                rectangle2.height = rectangle.height;
                if (n2 < 0) {
                    rectangle2.x = rectangle.x + rectangle.width + n2;
                    rectangle2.width = -n2;
                } else {
                    rectangle2.x = rectangle.x;
                    rectangle2.width = n2;
                }
                Rectangle rectangle3 = this._canvasRect;
                synchronized (rectangle3) {
                    this._canvasRect.x = n;
                    this.shiftFrozenDamage(0, n2);
                }
                this.paintImmediate(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            }
            catch (Throwable throwable) {
                Object var4_9 = null;
                this.unfreezeRepaints();
                throw throwable;
            }
        }
        Object var4_8 = null;
        this.unfreezeRepaints();
    }

    private void _shiftCanvasY(int n) {
        block10: {
            Point point = this.getCanvasOrigin();
            if (n == point.y) {
                return;
            }
            this.freezeRepaints();
            try {
                Rectangle rectangle = this.getInnerBounds();
                this.clipToParents(rectangle);
                int n2 = n - point.y;
                if (this.isClippedBySibling() || this.isTransparent() || this._isDamaged() || Math.abs(n2) >= rectangle.height) {
                    this._canvasRect.y = n;
                    this.repaintCanvas();
                    break block10;
                }
                this.getToolkit().sync();
                Graphics graphics = this.getGraphics();
                if (graphics == null) {
                    this._canvasRect.y = n;
                    this.repaintCanvas();
                    break block10;
                }
                graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                graphics.copyArea(rectangle.x, rectangle.y, rectangle.width, rectangle.height, 0, n2);
                graphics.dispose();
                Rectangle rectangle2 = new Rectangle();
                rectangle2.x = rectangle.x;
                rectangle2.width = rectangle.width;
                if (n2 < 0) {
                    rectangle2.y = rectangle.y + rectangle.height + n2;
                    rectangle2.height = -n2;
                } else {
                    rectangle2.y = rectangle.y;
                    rectangle2.height = n2;
                }
                Rectangle rectangle3 = this._canvasRect;
                synchronized (rectangle3) {
                    this._canvasRect.y = n;
                    this.shiftFrozenDamage(0, n2);
                }
                this.paintImmediate(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            }
            catch (Throwable throwable) {
                Object var4_9 = null;
                this.unfreezeRepaints();
                throw throwable;
            }
        }
        Object var4_8 = null;
        this.unfreezeRepaints();
    }

    private void _configureAdjustable(Adjustable adjustable, int n, int n2, int n3) {
        adjustable.setMinimum(0);
        adjustable.setMaximum(n2);
        adjustable.setVisibleAmount(n3);
        adjustable.setValue(n);
        adjustable.setBlockIncrement(n3 > 1 ? n3 - 1 : 1);
    }

    private void _configureHAdjustable() {
        int n;
        int n2;
        Adjustable adjustable = this.getHAdjustable();
        if (adjustable == null) {
            return;
        }
        int n3 = this.getHMaximum();
        if (n3 < (n2 = this._getColumnsPerPage(n3))) {
            n3 = n2;
        }
        Rectangle rectangle = this.getCanvasBounds();
        Dimension dimension = this.getInnerSize();
        if (rectangle.x < 0 && rectangle.x + rectangle.width < dimension.width) {
            int n4 = dimension.width - rectangle.width;
            if (n4 > 0) {
                n4 = 0;
            }
            this._shiftCanvasX(n4);
            n = this.getHValueOfOffset(n4);
        } else {
            n = adjustable.getValue();
        }
        this._configureAdjustable(adjustable, n, n3, n2);
    }

    private void _configureVAdjustable() {
        int n;
        int n2;
        Adjustable adjustable = this.getVAdjustable();
        if (adjustable == null) {
            return;
        }
        int n3 = this.getVMaximum();
        if (n3 < (n2 = this._getRowsPerPage(n3))) {
            n3 = n2;
        }
        Rectangle rectangle = this.getCanvasBounds();
        Dimension dimension = this.getInnerSize();
        if (rectangle.y < 0 && rectangle.y + rectangle.height < dimension.height) {
            int n4 = dimension.height - rectangle.height;
            if (n4 > 0) {
                n4 = 0;
            }
            this._shiftCanvasY(n4);
            n = this.getVValueOfOffset(n4);
        } else {
            n = adjustable.getValue();
        }
        this._configureAdjustable(adjustable, n, n3, n2);
    }

    private int _getColumnsPerPage(int n) {
        int n2;
        EwtComponent ewtComponent = this.getProxyConfigurer();
        if (ewtComponent != null) {
            return ewtComponent._getColumnsPerPage(n);
        }
        Dimension dimension = this.getCanvasSize();
        int n3 = n2 = dimension.width != 0 ? n * this.getInnerSize().width / dimension.width : 0;
        if (n2 == 0) {
            n2 = 1;
        }
        return n2;
    }

    private int _getRowsPerPage(int n) {
        int n2;
        EwtComponent ewtComponent = this.getProxyConfigurer();
        if (ewtComponent != null) {
            return ewtComponent._getRowsPerPage(n);
        }
        Dimension dimension = this.getCanvasSize();
        int n3 = n2 = dimension.height != 0 ? n * this.getInnerSize().height / dimension.height : 0;
        if (n2 == 0) {
            n2 = 1;
        }
        return n2;
    }

    private class Validater
    implements Task {
        public void runTask(TaskEvent taskEvent) {
            EwtComponent.this.validate();
            EwtComponent.this.repaintCanvas();
        }

        Validater() {
            EwtComponent.this = EwtComponent.this;
        }
    }
}

