/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.tabBar;

import java.awt.AWTEvent;
import java.awt.Adjustable;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Vector;
import oracle.ewt.EwtComponent;
import oracle.ewt.event.ListenerManager;
import oracle.ewt.scrolling.ScrollableException;
import oracle.ewt.tabBar.SquareTabStyle;
import oracle.ewt.tabBar.TabBarEvent;
import oracle.ewt.tabBar.TabBarItem;
import oracle.ewt.tabBar.TabBarListener;
import oracle.ewt.tabBar.TabStyle;

public class TabBar
extends EwtComponent {
    public static final int TOP = 0;
    public static final int BOTTOM = 1;
    private static final int _ALLOWED_HORIZONTAL_GROWTH = 1;
    private Vector _tabs;
    private TabBarItem _selectItem;
    private int _orientation;
    private int _overlap;
    private Font _selectFont;
    private Color _itemBG;
    private Color _selectBG;
    private TabStyle _style;
    private ListenerManager _listeners;
    private Adjustable _hAdjustable;
    private static int _sInstanceCounter;
    private static String _sDefaultName;

    public TabBar() {
        this(SquareTabStyle.getTabStyle());
    }

    public TabBar(TabStyle tabStyle) {
        if (tabStyle == null) {
            throw new IllegalArgumentException("Null TabStyle");
        }
        this._style = tabStyle;
        this._tabs = new Vector();
        this.setOrientation(0);
        this.enableEvents(28L);
    }

    public final TabBarItem addItem(String string) {
        return this.addItem(string, null);
    }

    public final TabBarItem addItem(String string, TabBarItem tabBarItem) {
        TabBarItem tabBarItem2 = this.createItem(string);
        return this.addItem(tabBarItem2, tabBarItem);
    }

    public final TabBarItem addItem(TabBarItem tabBarItem) {
        return this.addItem(tabBarItem, null);
    }

    public TabBarItem addItem(TabBarItem tabBarItem, TabBarItem tabBarItem2) {
        if (tabBarItem == tabBarItem2) {
            throw new IllegalArgumentException();
        }
        if (tabBarItem.getParent() != null) {
            tabBarItem.getParent().removeItem(tabBarItem);
        }
        if (tabBarItem2 == null) {
            this._tabs.addElement(tabBarItem);
        } else {
            int n = this._tabs.indexOf(tabBarItem2);
            this._tabs.insertElementAt(tabBarItem, n);
        }
        tabBarItem.setParent(this);
        tabBarItem.setSize(0, 0);
        if (this.getSelectedItem() == null && tabBarItem.isVisible() && tabBarItem.isEnabled()) {
            tabBarItem.setSelected(true);
        }
        if (tabBarItem.isVisible()) {
            this.invalidateCanvas();
        }
        return tabBarItem;
    }

    public TabBarItem getItem(int n) {
        if (n >= 0 && n < this.getItemCount()) {
            return (TabBarItem)this._tabs.elementAt(n);
        }
        throw new IndexOutOfBoundsException();
    }

    public int getIndexOf(TabBarItem tabBarItem) {
        if (tabBarItem == null) {
            throw new IllegalArgumentException();
        }
        return this._tabs.indexOf(tabBarItem);
    }

    public synchronized TabBarItem getSelectedItem() {
        return this._selectItem;
    }

    public int getItemCount() {
        return this._tabs.size();
    }

    public void removeItem(TabBarItem tabBarItem) {
        int n = this.getIndexOf(tabBarItem);
        this.getItemCount();
        if (tabBarItem == this.getSelectedItem() && !this._moveSelection(true)) {
            tabBarItem.setSelected(false);
        }
        this._tabs.removeElementAt(n);
        tabBarItem.setParent(null);
        this.invalidateCanvas();
    }

    public synchronized void removeAllItems() {
        TabBarItem tabBarItem = this.getSelectedItem();
        if (tabBarItem != null) {
            tabBarItem.setSelected(false);
        }
        int n = this.getItemCount() - 1;
        while (n >= 0) {
            this.removeItem(this.getItem(n));
            --n;
        }
    }

    public void setOrientation(int n) {
        if (n != this._orientation) {
            this._orientation = n;
            this.invalidateCanvas();
        }
    }

    public void addNotify() {
        if (this.getParent().getFont() != null) {
            this.setFont(this.getParent().getFont());
        }
        super.addNotify();
    }

    public void setFont(Font font) {
        this._selectFont = this.calculateSelectFont(font);
        super.setFont(font);
        if (this.getItemCount() != 0) {
            this.invalidateCanvas();
        }
    }

    public void setItemBackground(Color color) {
        this._itemBG = color;
        this.repaintCanvas();
    }

    public Color getItemBackground() {
        if (this._itemBG != null) {
            return this._itemBG;
        }
        return this.getBackground();
    }

    public void setSelectedBackground(Color color) {
        this._selectBG = color;
        TabBarItem tabBarItem = this.getSelectedItem();
        if (tabBarItem != null) {
            tabBarItem.repaint();
        }
    }

    public Color getSelectedBackground() {
        if (this._selectBG != null) {
            return this._selectBG;
        }
        return this.getItemBackground();
    }

    public void addTabBarListener(TabBarListener tabBarListener) {
        if (this._listeners == null) {
            this._listeners = new ListenerManager();
        }
        this._listeners.addListener(tabBarListener);
    }

    public void removeTabBarListener(TabBarListener tabBarListener) {
        this._listeners.removeListener(tabBarListener);
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        if (mouseEvent.isConsumed()) {
            return;
        }
        switch (mouseEvent.getID()) {
            case 501: {
                this.requestFocus();
                this.processMouseDown(mouseEvent, mouseEvent.getX(), mouseEvent.getY());
                return;
            }
        }
    }

    protected void processMouseDown(MouseEvent mouseEvent, int n, int n2) {
        TabBarItem tabBarItem;
        if (this.isEnabled() && (mouseEvent.getModifiers() & 0x10) != 0 && (tabBarItem = this.getItemAt(n, n2)) != null) {
            Point point = this.convertOuterToCanvas(n, n2);
            tabBarItem.mousePressed(mouseEvent, point.x, point.y);
        }
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
        if (keyEvent.isConsumed()) {
            return;
        }
        if (keyEvent.getID() == 401) {
            boolean bl = false;
            int n = keyEvent.getKeyCode();
            if (n == 39) {
                bl = this._moveSelection(true);
            } else if (n == 37) {
                bl = this._moveSelection(false);
            }
            if (bl) {
                keyEvent.consume();
            }
        }
    }

    public int getOrientation() {
        return this._orientation;
    }

    public TabStyle getStyle() {
        return this._style;
    }

    public void setStyle(TabStyle tabStyle) {
        if (this._style != tabStyle) {
            this._style = tabStyle;
            this.invalidateCanvas();
        }
    }

    protected void processEventImpl(AWTEvent aWTEvent) {
        if (aWTEvent instanceof TabBarEvent) {
            this.processTabBarEvent((TabBarEvent)aWTEvent);
            return;
        }
        super.processEventImpl(aWTEvent);
    }

    protected void processTabBarEvent(TabBarEvent tabBarEvent) {
        Object object;
        Object object2;
        if (tabBarEvent.getID() == 2001) {
            object2 = tabBarEvent.getItem();
            object = this.getSelectedItem();
            if (object != object2) {
                this._setSelectedItem((TabBarItem)object2);
                if (object != null) {
                    ((TabBarItem)object).setSelected(false);
                }
            }
        }
        if ((object2 = this._listeners) != null && (object = ((ListenerManager)object2).getListeners()) != null) {
            while (object.hasMoreElements()) {
                TabBarListener tabBarListener = (TabBarListener)object.nextElement();
                switch (tabBarEvent.getID()) {
                    case 2000: {
                        tabBarListener.tabBarSelectionChanging(tabBarEvent);
                        break;
                    }
                    case 2001: {
                        tabBarListener.tabBarSelectionChanged(tabBarEvent);
                        break;
                    }
                    case 2002: {
                        tabBarListener.tabBarLayoutChanged(tabBarEvent);
                        break;
                    }
                }
            }
        }
    }

    protected void paintCanvasInterior(Graphics graphics) {
        TabBarItem tabBarItem;
        Rectangle rectangle = graphics.getClipRect();
        int n = this.getItemCount();
        if (n == 0) {
            return;
        }
        TabBarItem tabBarItem2 = this.getSelectedItem();
        if (tabBarItem2 == null || !tabBarItem2.isVisible()) {
            this._moveSelection(true);
        }
        TabStyle tabStyle = this.getStyle();
        int n2 = n - 1;
        while (n2 >= 0) {
            tabBarItem = this.getItem(n2);
            if (!tabBarItem.isSelected() && tabBarItem.isVisible() && rectangle.intersects(tabBarItem.getBounds())) {
                tabStyle.paint(graphics, tabBarItem);
            }
            --n2;
        }
        tabBarItem = this.getSelectedItem();
        if (tabBarItem != null && tabBarItem.isVisible() && rectangle.intersects(tabBarItem.getBounds())) {
            tabStyle.paint(graphics, tabBarItem);
        }
    }

    protected Dimension layoutCanvas() {
        int n;
        Dimension dimension = this.getInnerSize();
        int n2 = this.getItemCount();
        TabStyle tabStyle = this.getStyle();
        if (n2 == 0) {
            return dimension;
        }
        int n3 = this.getOrientation();
        int n4 = n = this.getAllowedHorizGrowth();
        boolean bl = false;
        int n5 = 0;
        int n6 = 0;
        while (n6 < n2) {
            TabBarItem tabBarItem = this.getItem(n6);
            if (tabBarItem.isVisible()) {
                Dimension dimension2 = tabStyle.getPreferredSize(tabBarItem);
                tabBarItem.setSize(dimension2.width, dimension2.height);
                Dimension dimension3 = tabBarItem.getSize();
                int n7 = n3 == 0 ? dimension.height - dimension3.height : 0;
                tabBarItem.setLocation(n4, n7);
                if (!bl) {
                    n5 = tabStyle.getPreferredOverlap(tabBarItem);
                    bl = true;
                }
                n4 += dimension3.width + 2 * n - n5;
            }
            ++n6;
        }
        if (n6 > 0) {
            n4 += n5;
        }
        if (bl) {
            this._overlap = n5;
        }
        this.processEvent(new TabBarEvent(this, 2002, null));
        return new Dimension(n4, dimension.height);
    }

    public Dimension getPreferredSize() {
        this.layoutCanvas();
        if (this.getItemCount() == 0) {
            return new Dimension(0, 0);
        }
        Rectangle rectangle = this._getLastItem().getBounds();
        return this.convertInnerToOuterSize(rectangle.x + rectangle.width, rectangle.height);
    }

    public synchronized Dimension getMinimumSize() {
        Dimension dimension = this.getItemCount() == 0 ? new Dimension(0, 0) : this.getStyle().getPreferredSize(this._getFirstItem());
        return this.convertInnerToOuterSize(dimension.width, dimension.height);
    }

    public synchronized void enable() {
        if (!this.isEnabled()) {
            super.enable();
            this.repaintCanvas();
        }
    }

    public synchronized void disable() {
        if (this.isEnabled()) {
            super.disable();
            this.repaintCanvas();
        }
    }

    public TabBarItem getItemAt(int n, int n2) {
        Point point = this.convertOuterToCanvas(n, n2);
        TabBarItem tabBarItem = this.getSelectedItem();
        if (tabBarItem != null && tabBarItem.contains(point.x, point.y)) {
            return tabBarItem;
        }
        int n3 = this.getItemCount();
        int n4 = 0;
        while (n4 < n3) {
            TabBarItem tabBarItem2 = this.getItem(n4);
            if (!tabBarItem2.isSelected() && tabBarItem2.isVisible() && tabBarItem2.contains(point.x, point.y)) {
                return tabBarItem2;
            }
            ++n4;
        }
        return null;
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void handleHScroll(int n, int n2) throws ScrollableException {
        super.handleHScroll(n, n2);
        this.processEvent(new TabBarEvent(this, 2002, null));
    }

    protected TabBarItem createItem(String string) {
        return new TabBarItem(string);
    }

    protected int getOverlap() {
        return this._overlap;
    }

    protected Font calculateSelectFont(Font font) {
        return new Font(font.getName(), font.getStyle() | 1, font.getSize());
    }

    protected Font getSelectFont() {
        return this._selectFont;
    }

    protected int getAllowedHorizGrowth() {
        return 1;
    }

    protected int getHMaximum() {
        int n = this.getItemCount();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (this.getItem(n3).isVisible()) {
                ++n2;
            }
            ++n3;
        }
        return n2;
    }

    protected int getHValueOfOffset(int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.getItemCount()) {
            TabBarItem tabBarItem = this.getItem(n3);
            if (tabBarItem.isVisible()) {
                Rectangle rectangle = tabBarItem.getBounds();
                if (rectangle.x >= -n) break;
                ++n2;
            }
            ++n3;
        }
        return n2;
    }

    protected int getHOffsetOfValue(int n) {
        int n2 = 0;
        int n3 = this.getItemCount();
        int n4 = this.getCanvasSize().width;
        int n5 = n4 - this.getInnerSize().width;
        int n6 = n4;
        int n7 = 0;
        while (n7 < n3) {
            TabBarItem tabBarItem = this.getItem(n7);
            if (tabBarItem.isVisible()) {
                if (n2 == n) {
                    n6 = tabBarItem.getBounds().x - this.getAllowedHorizGrowth();
                    break;
                }
                ++n2;
            }
            ++n7;
        }
        if (n6 > n5) {
            n6 = n5;
        }
        return -n6;
    }

    public void attachHAdjustable(Adjustable adjustable) throws ScrollableException {
        this._hAdjustable = adjustable;
    }

    public Adjustable getHAdjustable() {
        return this._hAdjustable;
    }

    public boolean isHScrollable() {
        return true;
    }

    protected String getDefaultName() {
        if (_sDefaultName == null) {
            _sDefaultName = this.getBaseClassName();
        }
        return String.valueOf(_sDefaultName) + _sInstanceCounter++;
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        TabBarItem tabBarItem = this.getSelectedItem();
        if (tabBarItem != null) {
            tabBarItem.repaint();
        }
        super.processFocusEvent(focusEvent);
    }

    protected void scrollIntoView(TabBarItem tabBarItem) {
        Dimension dimension = this.getInnerSize();
        if (dimension.width <= 0) {
            return;
        }
        Point point = this.getCanvasOrigin();
        Rectangle rectangle = tabBarItem.getBounds();
        int n = this.getIndexOf(tabBarItem);
        int n2 = n - 1;
        while (n2 >= 0) {
            if (!this.getItem(n2).isVisible()) {
                --n;
            }
            --n2;
        }
        if (rectangle.x < -point.x) {
            this.setCanvasOrigin(this.getHOffsetOfValue(n), 0);
            return;
        }
        if (rectangle.x + rectangle.width > -point.x + dimension.width) {
            int n3 = this.getHValueOfOffset(point.x);
            int n4 = this.getHMaximum();
            while (rectangle.x + rectangle.width > -this.getHOffsetOfValue(++n3) + dimension.width && n3 < n4) {
            }
            this.setCanvasOrigin(this.getHOffsetOfValue(n3), 0);
        }
    }

    void itemDeselected(TabBarItem tabBarItem) {
        if (this.getSelectedItem() == tabBarItem) {
            this._setSelectedItem(null);
            this.processEvent(new TabBarEvent(this, 2001, null));
        }
    }

    private synchronized TabBarItem _getFirstItem() {
        TabBarItem tabBarItem;
        TabBarItem tabBarItem2 = tabBarItem = (TabBarItem)this._tabs.firstElement();
        while (!tabBarItem.isVisible()) {
            if ((tabBarItem = this._getNextItem(tabBarItem)) == tabBarItem2) break;
        }
        return tabBarItem;
    }

    private synchronized TabBarItem _getLastItem() {
        TabBarItem tabBarItem;
        TabBarItem tabBarItem2 = tabBarItem = (TabBarItem)this._tabs.lastElement();
        while (!tabBarItem.isVisible()) {
            if ((tabBarItem = this._getPrevItem(tabBarItem)) == tabBarItem2) break;
        }
        return tabBarItem;
    }

    private synchronized TabBarItem _getNextItem(TabBarItem tabBarItem) {
        int n = this.getIndexOf(tabBarItem);
        if (++n == this.getItemCount()) {
            n = 0;
        }
        return this.getItem(n);
    }

    private synchronized TabBarItem _getPrevItem(TabBarItem tabBarItem) {
        int n = this.getIndexOf(tabBarItem);
        n = n > 0 ? --n : this.getItemCount() - 1;
        return this.getItem(n);
    }

    private synchronized int _getSelectedIndex() {
        TabBarItem tabBarItem = this.getSelectedItem();
        if (tabBarItem != null) {
            return this.getIndexOf(tabBarItem);
        }
        return -1;
    }

    private void _setSelectedItem(TabBarItem tabBarItem) {
        this._selectItem = tabBarItem;
    }

    boolean _moveSelection(boolean bl) {
        TabBarItem tabBarItem = this.getSelectedItem();
        if (tabBarItem == null && (tabBarItem = this._getFirstItem()) == null) {
            return false;
        }
        TabBarItem tabBarItem2 = tabBarItem;
        while (!((tabBarItem2 = bl ? this._getNextItem(tabBarItem2) : this._getPrevItem(tabBarItem2)) == tabBarItem || tabBarItem2.isEnabled() && tabBarItem2.isVisible())) {
        }
        if (tabBarItem2 != tabBarItem) {
            tabBarItem2.setSelected(true);
            return true;
        }
        return false;
    }
}

