/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.forms;

import COM.livingston.forms.LEAddDialog;
import COM.livingston.forms.LECmdErrorDialog;
import COM.livingston.forms.LEFormLine;
import COM.livingston.forms.LEFormLineFactory;
import COM.livingston.forms.LELoginUsersForm;
import COM.livingston.forms.LETableForm;
import COM.livingston.model.LEDBNetUser;
import COM.livingston.model.LEDBNetUsers;
import COM.livingston.model.LEDataSpec;
import COM.livingston.model.LELocations;
import COM.livingston.model.LEPortMaster;
import COM.livingston.model.LETable;
import COM.livingston.model.LEUsers;
import COM.livingston.ui.LEErrorDialog;
import COM.livingston.ui.LEFont;
import COM.livingston.ui.LEUiUtils;
import COM.livingston.util.LEVector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Label;
import java.awt.Panel;

public class LEDBNetUsersForm
extends LETableForm {
    String m_addName;
    String m_addLoc;

    boolean addNewEntry(LEDataSpec lEDataSpec, LEDataSpec lEDataSpec2) {
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        Label label = new Label(String.valueOf(lEDataSpec.getDescription()) + ":");
        label.setFont(LEFont.getBoldFont());
        panel.add("West", label);
        Component component = LEFormLineFactory.BuildFormLine(null, null, null, lEDataSpec);
        panel.add("Center", component);
        LEAddDialog lEAddDialog = new LEAddDialog(LEUiUtils.GetBaseFrame(), "Add Dialback Network User", panel);
        if (lEAddDialog.okay()) {
            this.m_addName = ((LEFormLine)((Object)component)).getValue();
            if (this.m_addName.length() > 0) {
                return true;
            }
            if (this.m_addName.length() == 0) {
                new LEErrorDialog(LEUiUtils.GetBaseFrame(), "A user name must be specified");
            }
        }
        return false;
    }

    void addNewEntryTo(LEPortMaster lEPortMaster) {
        LEUsers lEUsers = (LEUsers)lEPortMaster.get("1835008");
        if (lEUsers.getUser(this.m_addName) == null) {
            LELocations lELocations = (LELocations)lEPortMaster.get("1703936");
            if (lELocations == null || lELocations.size() == 0) {
                new LEErrorDialog(LEUiUtils.GetBaseFrame(), String.valueOf(lEPortMaster.getHostname()) + " must contain at least one location before you can add a dialback network user");
                return;
            }
            LEDBNetUsers lEDBNetUsers = (LEDBNetUsers)this.getTable(lEPortMaster);
            this.m_addLoc = this.getLocationName(lEPortMaster, lEDBNetUsers);
            if (this.m_addLoc == null) {
                return;
            }
            LEVector lEVector = lEDBNetUsers.add(this.m_addName, this.m_addLoc);
            if (lEVector != null) {
                new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), lEPortMaster.getConfigFacility(), lEVector);
            }
            this.addEntry(lEPortMaster.getHostname(), lEDBNetUsers, this.m_addName);
            return;
        }
        new LEErrorDialog(LEUiUtils.GetBaseFrame(), String.valueOf(lEPortMaster.getHostname()) + " already contains a user named " + this.m_addName);
    }

    String getLocationName(LEPortMaster lEPortMaster, LEDBNetUsers lEDBNetUsers) {
        String string = null;
        LEDataSpec lEDataSpec = lEDBNetUsers.getSpecFor("entry");
        LEDataSpec lEDataSpec2 = lEDataSpec.getSpecFor("368");
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        Label label = new Label("Select location for " + lEPortMaster.getHostname() + ":", 1);
        label.setFont(LEFont.getBoldFont());
        panel.add("North", label);
        label = new Label("Location:");
        label.setFont(LEFont.getBoldFont());
        panel.add("West", label);
        Component component = LEFormLineFactory.BuildFormLine(lEPortMaster, null, null, lEDataSpec2);
        panel.add("Center", component);
        LEAddDialog lEAddDialog = new LEAddDialog(LEUiUtils.GetBaseFrame(), "Select Location for Dialback Network User", panel);
        if (lEAddDialog.okay()) {
            string = ((LEFormLine)((Object)component)).getValue();
        }
        return string;
    }

    void delete(LEPortMaster lEPortMaster, LETable lETable, String string) {
        if (!(lETable instanceof LEDBNetUsers)) {
            return;
        }
        LEDBNetUsers lEDBNetUsers = (LEDBNetUsers)lETable;
        LEVector lEVector = lEDBNetUsers.delete(string);
        if (lEVector != null) {
            new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), lEPortMaster.getConfigFacility(), lEVector);
        }
    }

    String getPasteKey(LEPortMaster lEPortMaster, Object object) {
        LEVector lEVector;
        if (!(object instanceof LEDBNetUser)) {
            return null;
        }
        LEDBNetUser lEDBNetUser = (LEDBNetUser)object;
        LEDBNetUsers lEDBNetUsers = (LEDBNetUsers)this.getTable(lEPortMaster);
        String string = lEDBNetUser.getName();
        String string2 = (String)lEDBNetUser.get("368");
        if (string2 == null) {
            return null;
        }
        LEUsers lEUsers = (LEUsers)lEPortMaster.get("1835008");
        if (lEUsers.getUser(string) != null) {
            string = LELoginUsersForm.GetUniqueKey(lEUsers, string, 8);
        }
        if ((lEVector = lEDBNetUsers.add(string, string2)) != null) {
            new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), lEPortMaster.getConfigFacility(), lEVector);
            string = null;
        }
        return string;
    }
}

