/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.amf.LEAMFactory;
import COM.livingston.amf.LEAMObserver;
import COM.livingston.backend.LEMonSessionsMessage;
import COM.livingston.backend.LEMonitorFactory;
import COM.livingston.backend.LEPMCommand;
import COM.livingston.model.LEDialerMessage;
import COM.livingston.model.LELocation;
import COM.livingston.model.LELocations;
import COM.livingston.model.LEPortMaster;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LEObservable;
import COM.livingston.util.LEVector;

public class LEDialer
extends LEObservable
implements LEAMObserver {
    private static final String IDLE = "IDLE";
    private static final String CONNECTING = "CONNECTING";
    private static final String ESTABLISHED = "ESTABLISHED";
    private static final int SESSION_MONITOR = 65536;
    private static final int MONITOR_TIME = 1000;
    LELocation m_location;
    boolean m_locexists = false;
    LEPortMaster m_pm;
    String m_port;
    String m_slot;
    String m_previous_state = "";
    int m_dial_count;
    long m_monitorID;

    public LEDialer(LEPortMaster lEPortMaster) {
        this.m_pm = lEPortMaster;
        this.m_dial_count = 0;
        this.m_port = "";
        this.m_slot = "";
    }

    public LEVector setLocation(LELocation lELocation) {
        LEVector lEVector = new LEVector();
        this.m_location = (LELocation)lELocation.clone();
        LELocations lELocations = (LELocations)this.m_pm.get("1703936");
        LEVector lEVector2 = lELocations.getKeys();
        if (lEVector2.contains(this.m_location.getName())) {
            this.m_locexists = true;
        } else {
            lELocations.set(this.m_location.getName(), this.m_location);
            lEVector = lELocations.saveChanges();
        }
        return lEVector;
    }

    public LEVector removeLocation() {
        LEVector lEVector = new LEVector();
        if (!this.m_locexists) {
            LELocations lELocations = (LELocations)this.m_pm.get("1703936");
            lEVector = lELocations.delete(this.m_location.getName());
        }
        return lEVector;
    }

    public void dialLocation() {
        int n = -1;
        String string = "dial " + this.m_location.getName();
        LEMonitorFactory.GetFactory().addObserver(this.m_pm.getHostname(), this);
        LEPMCommand lEPMCommand = this.m_pm.execute(string);
        String string2 = lEPMCommand.getResult();
        if (!lEPMCommand.getStatus()) {
            this.sendFailMessage(string2);
            return;
        }
        int n2 = string2.indexOf("using");
        if (n2 > -1) {
            String string3 = string2.substring(n2 + 6);
            this.m_port = (n2 = string3.indexOf(" ")) > -1 ? string3.substring(0, n2).trim() : string3.trim();
        }
        if ((n2 = string2.indexOf("Slot")) > -1) {
            this.m_slot = string2.substring(n2 + 4).trim();
            n = Integer.parseInt(this.m_slot);
        }
        try {
            if (n > -1) {
                this.m_monitorID = this.m_pm.getDSS().monitor(65536, 1000, n);
                return;
            }
            this.m_monitorID = this.m_pm.getDSS().monitor(65536, 1000);
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            this.sendFailMessage(exception.getMessage());
            this.disconnect();
            return;
        }
    }

    public void update(LEAMFactory lEAMFactory, String string, Object object) {
        if (object instanceof LEMonSessionsMessage) {
            LEMonSessionsMessage lEMonSessionsMessage = (LEMonSessionsMessage)object;
            if (!this.m_slot.equals("") && !lEMonSessionsMessage.getBoard().equals(this.m_slot)) {
                return;
            }
            if (!lEMonSessionsMessage.getPortName().equals(this.m_port)) {
                return;
            }
            String string2 = lEMonSessionsMessage.getStatus();
            if (this.m_dial_count < 10) {
                ++this.m_dial_count;
            } else {
                this.sendFailMessage(null);
                this.disconnect();
            }
            if (string2.equals(IDLE)) {
                if (this.m_previous_state.equals(CONNECTING)) {
                    this.sendFailMessage(null);
                    this.disconnect();
                }
                this.m_previous_state = string2;
                return;
            }
            if (string2.equals(CONNECTING)) {
                this.m_previous_state = string2;
                return;
            }
            if (string2.equals(ESTABLISHED)) {
                this.sendSuccessMessage();
                this.disconnect();
            }
        }
    }

    protected void sendFailMessage(String string) {
        LEDialerMessage lEDialerMessage = new LEDialerMessage();
        lEDialerMessage.setSuccess(false);
        lEDialerMessage.setPortName(this.m_port);
        lEDialerMessage.setBoard(this.m_slot);
        lEDialerMessage.setLocation(this.m_location.getName());
        lEDialerMessage.setMessage(string);
        this.notifyObservers(lEDialerMessage);
    }

    protected void sendSuccessMessage() {
        LEDialerMessage lEDialerMessage = new LEDialerMessage();
        lEDialerMessage.setSuccess(true);
        lEDialerMessage.setPortName(this.m_port);
        lEDialerMessage.setBoard(this.m_slot);
        lEDialerMessage.setLocation(this.m_location.getName());
        this.notifyObservers(lEDialerMessage);
    }

    protected void disconnect() {
        LEMonitorFactory.GetFactory().deleteObserver(this.m_pm.getHostname(), this);
        try {
            this.m_pm.getDSS().killMonitor(this.m_monitorID);
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return;
        }
    }
}

