/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.model.LEConfig;
import COM.livingston.model.LEConfigFacility;
import COM.livingston.model.LEDLCITable;
import COM.livingston.model.LEDialScript;
import COM.livingston.util.LEVector;

public class LELocation
extends LEConfig {
    public static final String ADDRESS = "9";
    public static final String ANALOG = "292";
    public static final String ASYNC_MAP = "299";
    public static final String ASYNC_SCRIPT = "script";
    public static final String CHAP = "170";
    public static final String COMPRESSION = "290";
    public static final String COST = "242";
    public static final String DEADTIME = "244";
    public static final String DESTINATION = "74";
    public static final String DIAL_FILTER = "294";
    public static final String DOSBS = "293";
    public static final String GROUP = "129";
    public static final String HELLOINTERVAL = "243";
    public static final String HIGH_WATER = "298";
    public static final String IDLE_TIMEOUT = "297";
    public static final String INPUT_FILTER = "193";
    public static final String IP_DLCI = "ipdlci";
    public static final String IPX_DLCI = "ipxdlci";
    public static final String IPX_NETWORK = "189";
    public static final String LOCAL_IP = "177";
    public static final String MAX_PORTS = "296";
    public static final String MIGRATION = "241";
    public static final String MULTILINK = "291";
    public static final String MTU = "295";
    public static final String NAT_TCP_TIMEOUT = "353";
    public static final String NAT_OTHER_TIMEOUT = "354";
    public static final String NAT_FAIL_ACTION = "355";
    public static final String NAT_IN_MAP = "356";
    public static final String NAT_PROXY_IN_MAP = "357";
    public static final String NAT_OUT_MAP = "358";
    public static final String NAT_PROXY_OUT_MAP = "359";
    public static final String NAT_LOG_FAILURE = "360";
    public static final String NAT_LOG_SUCCESS = "361";
    public static final String NAT_LOG_SYSLOG = "362";
    public static final String NAT_LOG_CONSOLE = "363";
    public static final String NETMASK = "15";
    public static final String OSPF_STATUS = "246";
    public static final String OUTPUT_FILTER = "194";
    public static final String PASSWORD = "300";
    public static final String PPP_IP_TYPE = "PPPIPType";
    public static final String PPP_IPX_TYPE = "PPPIPXType";
    public static final String PROTOCOL = "289";
    public static final String RIP_BROAD = "187";
    public static final String RIP_LISTEN = "188";
    public static final String TELEPHONE = "301";
    public static final String TYPE = "288";
    public static final String USERNAME = "2";
    public static final String V25BIS_SCRIPT = "v25bis";
    public static final String WANTYPE = "245";
    public static final int KEY_COUNT = 49;
    public static final String ASYNC_SCRIPT_TAG = "script";
    public static final String V25BIS_SCRIPT_TAG = "v25bis";
    public static final String LOCATION_TAG = "location";
    public static final String NEGOTIATED = "negotiated";
    public static final String SPECIFIED = "specified";
    public static final String CONTINUOUS = "continuous";
    public static final String MANUAL = "manual";
    public static final String ON_DEMAND = "on-demand";
    public static final String SUB_INTERFACE = "sub-interface";
    public static final String FRAME_RELAY = "frame-relay";
    public static final String PPP = "ppp";
    public static final String SLIP = "slip";
    public static final String X75_SYNC = "x75-sync";
    public static final String STAC = "stac";
    public static final String VJ = "vj";
    public static final String MINUTES = "minutes";
    public static final String SECONDS = "seconds";
    static String[] s_keys = null;
    String m_name;
    String m_tag;

    public static String[] GetAllPossibleKeys() {
        if (s_keys == null) {
            s_keys = new String[49];
            int n = 0;
            LELocation.s_keys[n++] = ADDRESS;
            LELocation.s_keys[n++] = ANALOG;
            LELocation.s_keys[n++] = ASYNC_MAP;
            LELocation.s_keys[n++] = "script";
            LELocation.s_keys[n++] = CHAP;
            LELocation.s_keys[n++] = COMPRESSION;
            LELocation.s_keys[n++] = COST;
            LELocation.s_keys[n++] = DEADTIME;
            LELocation.s_keys[n++] = DESTINATION;
            LELocation.s_keys[n++] = DIAL_FILTER;
            LELocation.s_keys[n++] = DOSBS;
            LELocation.s_keys[n++] = GROUP;
            LELocation.s_keys[n++] = HELLOINTERVAL;
            LELocation.s_keys[n++] = HIGH_WATER;
            LELocation.s_keys[n++] = IDLE_TIMEOUT;
            LELocation.s_keys[n++] = INPUT_FILTER;
            LELocation.s_keys[n++] = IP_DLCI;
            LELocation.s_keys[n++] = IPX_DLCI;
            LELocation.s_keys[n++] = IPX_NETWORK;
            LELocation.s_keys[n++] = LOCAL_IP;
            LELocation.s_keys[n++] = MAX_PORTS;
            LELocation.s_keys[n++] = MIGRATION;
            LELocation.s_keys[n++] = MULTILINK;
            LELocation.s_keys[n++] = MTU;
            LELocation.s_keys[n++] = NAT_TCP_TIMEOUT;
            LELocation.s_keys[n++] = NAT_OTHER_TIMEOUT;
            LELocation.s_keys[n++] = NAT_FAIL_ACTION;
            LELocation.s_keys[n++] = NAT_IN_MAP;
            LELocation.s_keys[n++] = NAT_PROXY_IN_MAP;
            LELocation.s_keys[n++] = NAT_OUT_MAP;
            LELocation.s_keys[n++] = NAT_PROXY_OUT_MAP;
            LELocation.s_keys[n++] = NAT_LOG_FAILURE;
            LELocation.s_keys[n++] = NAT_LOG_SUCCESS;
            LELocation.s_keys[n++] = NAT_LOG_SYSLOG;
            LELocation.s_keys[n++] = NAT_LOG_CONSOLE;
            LELocation.s_keys[n++] = NETMASK;
            LELocation.s_keys[n++] = OSPF_STATUS;
            LELocation.s_keys[n++] = OUTPUT_FILTER;
            LELocation.s_keys[n++] = PASSWORD;
            LELocation.s_keys[n++] = PPP_IP_TYPE;
            LELocation.s_keys[n++] = PPP_IPX_TYPE;
            LELocation.s_keys[n++] = PROTOCOL;
            LELocation.s_keys[n++] = RIP_BROAD;
            LELocation.s_keys[n++] = RIP_LISTEN;
            LELocation.s_keys[n++] = TELEPHONE;
            LELocation.s_keys[n++] = TYPE;
            LELocation.s_keys[n++] = USERNAME;
            LELocation.s_keys[n++] = "v25bis";
            LELocation.s_keys[n++] = WANTYPE;
        }
        return s_keys;
    }

    public LELocation(LEConfigFacility lEConfigFacility, String string) {
        super(lEConfigFacility);
        this.m_name = string;
        this.m_tag = "location " + this.m_name;
    }

    public Object clone() {
        LELocation lELocation = new LELocation(this.m_facility, this.m_name);
        lELocation.copy(this);
        return lELocation;
    }

    public String getName() {
        return this.m_name;
    }

    public void initialize() {
        this.setField(ADDRESS, "0.0.0.0");
        this.setField(ANALOG, "off");
        this.setField(ASYNC_MAP, "0x00000000");
        this.setField("script", this.createConfig("script"));
        this.setField(CHAP, "off");
        this.setField(COMPRESSION, VJ);
        this.setField(DESTINATION, SPECIFIED);
        this.setField(DOSBS, "off");
        this.setField(GROUP, "0");
        this.setField(HIGH_WATER, "0");
        this.setField(IDLE_TIMEOUT, "0 minutes");
        this.setField(INPUT_FILTER, "");
        this.setField(IP_DLCI, this.createConfig(IP_DLCI));
        this.setField(IPX_DLCI, this.createConfig(IPX_DLCI));
        this.setField(IPX_NETWORK, "");
        this.setField(MAX_PORTS, "0");
        this.setField(MTU, "1500");
        this.setField(MULTILINK, "off");
        this.setField(NETMASK, "0.0.0.0");
        this.setField(OUTPUT_FILTER, "");
        this.setField(PASSWORD, "");
        this.setField(PROTOCOL, PPP);
        this.setField(RIP_BROAD, "off");
        this.setField(RIP_LISTEN, "off");
        this.setField(TELEPHONE, "");
        this.setField(TYPE, MANUAL);
        this.setField(USERNAME, "");
        this.setField("v25bis", this.createConfig("v25bis"));
    }

    public void initializeNAT() {
        this.setField(NAT_IN_MAP, "");
        this.setField(NAT_PROXY_IN_MAP, "");
        this.setField(NAT_OUT_MAP, "");
        this.setField(NAT_PROXY_OUT_MAP, "");
        this.setField(NAT_TCP_TIMEOUT, "1440 minutes");
        this.setField(NAT_OTHER_TIMEOUT, "15 seconds");
        this.setField(NAT_FAIL_ACTION, "drop");
        this.setField(NAT_LOG_CONSOLE, "off");
        this.setField(NAT_LOG_SYSLOG, "off");
        this.setField(NAT_LOG_FAILURE, "off");
        this.setField(NAT_LOG_SUCCESS, "off");
    }

    public void initializeOSPF() {
        this.setField(COST, "1");
        this.setField(DEADTIME, "40");
        this.setField(HELLOINTERVAL, "10");
        this.setField(OSPF_STATUS, "off");
        this.setField(WANTYPE, "nbma");
    }

    LEConfig createConfig(String string) {
        if (string.equals("script")) {
            return new LEDialScript(this.m_facility, String.valueOf(this.m_tag) + " " + "script");
        }
        if (string.equals("v25bis")) {
            return new LEDialScript(this.m_facility, String.valueOf(this.m_tag) + " " + "v25bis");
        }
        if (string.equals(IP_DLCI)) {
            return new LEDLCITable(this.m_facility, this.m_board, this.m_name, IP_DLCI);
        }
        if (string.equals(IPX_DLCI)) {
            return new LEDLCITable(this.m_facility, this.m_board, this.m_name, IPX_DLCI);
        }
        return new LEConfig(this.m_facility);
    }

    boolean generateCommands(LEVector lEVector, LEVector lEVector2) {
        CharSequence charSequence;
        CharSequence charSequence2;
        boolean bl = lEVector == null;
        int n = lEVector2.size();
        if (bl || lEVector.contains(ADDRESS) || lEVector.contains(DESTINATION)) {
            charSequence2 = (String)this.get(DESTINATION);
            if (charSequence2 != null && ((String)charSequence2).equals(NEGOTIATED)) {
                charSequence = new StringBuffer("set ");
                ((StringBuffer)charSequence).append(this.m_tag);
                ((StringBuffer)charSequence).append(" destination ");
                ((StringBuffer)charSequence).append("255.255.255.255");
                lEVector2.addElement(((StringBuffer)charSequence).toString());
            } else if (charSequence2 != null) {
                this.makeSetCommand(lEVector2, this.m_tag, ADDRESS, "destination");
            }
        }
        if (bl || lEVector.contains(ANALOG)) {
            this.makeSetCommand(lEVector2, this.m_tag, ANALOG, "analog");
        }
        if (bl || lEVector.contains(ASYNC_MAP)) {
            this.makeSetCommand(lEVector2, this.m_tag, ASYNC_MAP, "map");
        }
        if (bl || lEVector.contains(CHAP)) {
            this.makeSetCommand(lEVector2, this.m_tag, CHAP, "chap");
        }
        if (bl || lEVector.contains(COMPRESSION)) {
            this.makeSetCommand(lEVector2, this.m_tag, COMPRESSION, "compression");
        }
        if (bl || lEVector.contains(DOSBS)) {
            this.makeSetCommand(lEVector2, this.m_tag, DOSBS, "voice");
        }
        if (bl || lEVector.contains(GROUP)) {
            this.makeSetCommand(lEVector2, this.m_tag, GROUP, "group");
        }
        if (bl || lEVector.contains(HIGH_WATER)) {
            this.makeSetCommand(lEVector2, this.m_tag, HIGH_WATER, "high_water");
        }
        if (bl || lEVector.contains(IDLE_TIMEOUT)) {
            this.makeSetCommand(lEVector2, this.m_tag, IDLE_TIMEOUT, "idle");
        }
        if (bl || lEVector.contains(INPUT_FILTER)) {
            this.makeSetCommand(lEVector2, this.m_tag, INPUT_FILTER, "ifilter");
        }
        if (bl || lEVector.contains(IPX_NETWORK)) {
            this.makeSetCommand(lEVector2, this.m_tag, IPX_NETWORK, "ipxnet");
        }
        if (bl || lEVector.contains(LOCAL_IP)) {
            this.makeSetCommand(lEVector2, this.m_tag, LOCAL_IP, "local-ip-address");
        }
        if (bl || lEVector.contains(MAX_PORTS)) {
            this.makeSetCommand(lEVector2, this.m_tag, MAX_PORTS, "maxports");
        }
        if (bl || lEVector.contains(MULTILINK)) {
            this.makeSetCommand(lEVector2, this.m_tag, MULTILINK, "multilink");
        }
        if (bl || lEVector.contains(MTU)) {
            this.makeSetCommand(lEVector2, this.m_tag, MTU, "mtu");
        }
        if (bl || lEVector.contains(NAT_TCP_TIMEOUT)) {
            this.makeNATTimeOutCommand(lEVector2, this.m_tag, NAT_TCP_TIMEOUT, NAT_TCP_TIMEOUT);
        }
        if (bl || lEVector.contains(NAT_OTHER_TIMEOUT)) {
            this.makeNATTimeOutCommand(lEVector2, this.m_tag, NAT_OTHER_TIMEOUT, NAT_OTHER_TIMEOUT);
        }
        if (bl || lEVector.contains(NAT_FAIL_ACTION)) {
            this.makeNATFailActionCommand(lEVector2, this.m_tag, NAT_FAIL_ACTION);
        }
        if (bl || lEVector.contains(NAT_IN_MAP)) {
            this.makeNATMapCommand(lEVector2, this.m_tag, NAT_IN_MAP, true, false);
        }
        if (bl || lEVector.contains(NAT_PROXY_IN_MAP)) {
            this.makeNATMapCommand(lEVector2, this.m_tag, NAT_PROXY_IN_MAP, true, true);
        }
        if (bl || lEVector.contains(NAT_OUT_MAP)) {
            this.makeNATMapCommand(lEVector2, this.m_tag, NAT_OUT_MAP, false, false);
        }
        if (bl || lEVector.contains(NAT_PROXY_OUT_MAP)) {
            this.makeNATMapCommand(lEVector2, this.m_tag, NAT_PROXY_OUT_MAP, false, true);
        }
        if (bl || lEVector.contains(NAT_LOG_FAILURE)) {
            this.makeNATLogCommand(lEVector2, this.m_tag, NAT_LOG_FAILURE, NAT_LOG_FAILURE);
        }
        if (bl || lEVector.contains(NAT_LOG_SUCCESS)) {
            this.makeNATLogCommand(lEVector2, this.m_tag, NAT_LOG_SUCCESS, NAT_LOG_SUCCESS);
        }
        if (bl || lEVector.contains(NAT_LOG_SYSLOG)) {
            this.makeNATLogCommand(lEVector2, this.m_tag, NAT_LOG_SYSLOG, NAT_LOG_SYSLOG);
        }
        if (bl || lEVector.contains(NAT_LOG_CONSOLE)) {
            this.makeNATLogCommand(lEVector2, this.m_tag, NAT_LOG_CONSOLE, NAT_LOG_CONSOLE);
        }
        if (bl || lEVector.contains(NETMASK)) {
            this.makeSetCommand(lEVector2, this.m_tag, NETMASK, "netmask");
        }
        if (bl || lEVector.contains(OUTPUT_FILTER)) {
            this.makeSetCommand(lEVector2, this.m_tag, OUTPUT_FILTER, "ofilter");
        }
        if (bl || lEVector.contains(PASSWORD)) {
            this.makeSetCommand(lEVector2, this.m_tag, PASSWORD, "password");
        }
        if (bl || lEVector.contains(PROTOCOL)) {
            this.makeSetCommand(lEVector2, this.m_tag, PROTOCOL, "protocol");
        }
        if (bl || lEVector.contains(TELEPHONE)) {
            this.makeSetCommand(lEVector2, this.m_tag, TELEPHONE, "telephone");
        }
        if (bl || lEVector.contains(USERNAME)) {
            this.makeSetCommand(lEVector2, this.m_tag, USERNAME, "username");
        }
        if (bl || lEVector.contains(TYPE)) {
            charSequence2 = (String)this.get(TYPE);
            if (((String)charSequence2).equals("on_demand")) {
                this.makeSetCommand(lEVector2, this.m_tag, ON_DEMAND, null);
            } else {
                this.makeSetCommand(lEVector2, this.m_tag, TYPE, null);
            }
        }
        if (bl || lEVector.contains(RIP_BROAD) || lEVector.contains(RIP_LISTEN)) {
            this.makeRIPCommand(lEVector2, this.m_tag, "rip", (String)this.get(RIP_BROAD), (String)this.get(RIP_LISTEN));
        }
        if ((bl || lEVector.contains(OSPF_STATUS)) && this.get(OSPF_STATUS) != null) {
            charSequence2 = new StringBuffer(100);
            ((StringBuffer)charSequence2).append("set ");
            ((StringBuffer)charSequence2).append(this.m_tag);
            ((StringBuffer)charSequence2).append(" ospf ");
            charSequence = (String)this.get(OSPF_STATUS);
            ((StringBuffer)charSequence2).append((String)charSequence);
            if (((String)charSequence).equals("on")) {
                String string;
                String string2;
                String string3;
                String string4;
                String string5 = (String)this.get(COST);
                if (string5 != null && string5.length() > 0) {
                    ((StringBuffer)charSequence2).append(" cost ");
                    ((StringBuffer)charSequence2).append(string5);
                }
                if ((string4 = (String)this.get(MIGRATION)) != null && string4.length() > 0) {
                    ((StringBuffer)charSequence2).append(" accept-rip ");
                    ((StringBuffer)charSequence2).append(string4);
                }
                if ((string3 = (String)this.get(HELLOINTERVAL)) != null && string3.length() > 0) {
                    ((StringBuffer)charSequence2).append(" hello-interval ");
                    ((StringBuffer)charSequence2).append(string3);
                }
                if ((string2 = (String)this.get(DEADTIME)) != null && string2.length() > 0) {
                    ((StringBuffer)charSequence2).append(" dead-time ");
                    ((StringBuffer)charSequence2).append(string2);
                }
                if ((string = (String)this.get(WANTYPE)) != null && string.length() > 0) {
                    ((StringBuffer)charSequence2).append(" ");
                    ((StringBuffer)charSequence2).append(string);
                }
            }
            ((StringBuffer)charSequence2).append(" ");
            lEVector2.add(new String((StringBuffer)charSequence2));
        }
        return lEVector2.size() > n;
    }
}

