/*
 * Decompiled with CFR 0.152.
 */
import COM.livingston.amf.LEAMFactory;
import COM.livingston.amf.LEAMObserver;
import COM.livingston.backend.LEDeltaFactory;
import COM.livingston.backend.LEMonitorFactory;
import COM.livingston.backend.LEStatusFactory;
import COM.livingston.backend.LEStatusMessage;
import COM.livingston.model.LEMonitorFacility;
import COM.livingston.model.LEPortMaster;
import COM.livingston.ui.LEMLEvent;
import COM.livingston.ui.LEMLListener;
import COM.livingston.ui.LEMultiList;
import COM.livingston.ui.LEScrollPanel;
import COM.livingston.util.LEAlphaNumericCompare;
import COM.livingston.util.LEDebug;
import java.awt.Button;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.Date;
import java.util.Hashtable;

public abstract class LEMonitorPanel
extends LEMultiList
implements LEView,
LEMLListener,
LEAMObserver,
ActionListener {
    public static final Long ZERO = new Long(0L);
    static final String PORTMASTER = new String("PortMaster");
    LEViewListener m_listener;
    LEScrollPanel m_scroll;
    Hashtable m_deltas = new Hashtable();
    Hashtable m_monitors = new Hashtable();
    Hashtable m_rowKey = new Hashtable();
    LEPortMaster[] m_pms;
    Panel m_buttons = new Panel();
    Button m_reset;
    Button m_restore;
    Label m_resetTime;
    int[] m_resetCols;

    public LEMonitorPanel() {
        this.m_buttons.setLayout(new FlowLayout(1));
        this.m_reset = new Button("Reset Counters");
        this.m_buttons.add(this.m_reset);
        this.m_reset.addActionListener(this);
        this.m_restore = new Button("Restore Counters");
        this.m_buttons.add(this.m_restore);
        this.m_resetTime = new Label("");
        this.m_buttons.add(this.m_resetTime);
        this.m_restore.addActionListener(this);
    }

    public void initialize(int n, int n2, int n3) {
        super.initialize(n, n2, n3);
        int n4 = n2 + n3;
        int n5 = 0;
        while (n5 < n) {
            Object[] objectArray = new Object[n4];
            objectArray[0] = PORTMASTER;
            this.createColumnTitles(n5, 1, objectArray);
            this.setTitles(n5, objectArray);
            ++n5;
        }
        int n6 = 0;
        while (n6 < n4) {
            this.setSortable(n6, true);
            ++n6;
        }
        this.setSortObject(1, LEAlphaNumericCompare.GetCompareObject());
        super.addListener(this);
        this.m_scroll = new LEScrollPanel(this);
    }

    public synchronized void setSelection(LEPortMaster[] lEPortMasterArray) {
        int n;
        boolean bl;
        int n2;
        if (this.m_pms != null) {
            n2 = 0;
            while (n2 < this.m_pms.length) {
                bl = false;
                n = 0;
                while (!bl && n < lEPortMasterArray.length) {
                    if (this.m_pms[n2] == lEPortMasterArray[n]) {
                        bl = true;
                    }
                    ++n;
                }
                if (!bl) {
                    this.stopMonitoring(this.m_pms[n2]);
                }
                ++n2;
            }
        }
        n2 = 0;
        while (n2 < lEPortMasterArray.length) {
            bl = false;
            if (this.m_pms != null) {
                n = 0;
                while (!bl && n < this.m_pms.length) {
                    if (lEPortMasterArray[n2] == this.m_pms[n]) {
                        bl = true;
                    }
                    ++n;
                }
            }
            if (!bl) {
                this.startMonitoring(lEPortMasterArray[n2]);
            }
            ++n2;
        }
        this.m_pms = lEPortMasterArray;
    }

    public void addListener(LEViewListener lEViewListener) {
        this.m_listener = lEViewListener;
    }

    public void deleteListener(LEViewListener lEViewListener) {
        if (this.m_listener == lEViewListener) {
            this.m_listener = null;
        }
    }

    public Component getMainPanel() {
        return this.m_scroll;
    }

    public Component getBottomPanel() {
        return this.m_buttons;
    }

    public synchronized void going() {
        if (this.m_pms == null) {
            return;
        }
        int n = 0;
        while (n < this.m_pms.length) {
            this.stopMonitoring(this.m_pms[n]);
            ++n;
        }
        this.m_pms = null;
    }

    public synchronized void gone() {
        try {
            super.deleteListener(this);
            this.m_deltas = null;
            this.m_monitors = null;
            this.m_rowKey = null;
            this.cleanUp();
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return;
        }
    }

    public synchronized void onLEMLEvent(LEMLEvent lEMLEvent) {
        if (this.m_pms == null) {
            return;
        }
        if (lEMLEvent.getType() == 5) {
            this.m_rowKey.clear();
            int n = this.getNumRows();
            int n2 = 0;
            while (n2 < n) {
                String string = (String)this.getCellItem(n2, 0);
                String string2 = ((LEMonitorData)this.getRowObject(n2)).getEntity();
                this.saveRowKey(string, string2, n2);
                ++n2;
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.m_resetCols == null) {
            return;
        }
        if (actionEvent.getSource() == this.m_reset) {
            int n = 0;
            while (n < this.m_resetCols.length) {
                this.resetColumn(this.m_resetCols[n]);
                ++n;
            }
            Date date = new Date();
            DateFormat dateFormat = DateFormat.getDateTimeInstance(1, 1);
            this.m_resetTime.setText("Last Reset: " + dateFormat.format(date));
            this.m_buttons.invalidate();
            this.m_buttons.validate();
            return;
        }
        int n = 0;
        while (n < this.m_resetCols.length) {
            this.restoreColumn(this.m_resetCols[n]);
            ++n;
        }
        this.m_resetTime.setText("");
        this.m_buttons.invalidate();
        this.m_buttons.validate();
    }

    void updateStatus(String string, LEStatusMessage lEStatusMessage) {
        LEPortMaster lEPortMaster = null;
        int n = 0;
        while (lEPortMaster == null && n < this.m_pms.length) {
            if (string.equals(this.m_pms[n].getHostname())) {
                lEPortMaster = this.m_pms[n];
            }
            ++n;
        }
        if (lEPortMaster == null) {
            return;
        }
        switch (lEStatusMessage.getStatus()) {
            case 1: {
                this.startMonitoring(lEPortMaster);
                return;
            }
            case 2: 
            case 4: {
                this.stopMonitoring(lEPortMaster);
                LEStatusFactory.GetFactory().addObserver(string, this);
                return;
            }
        }
    }

    void saveRowKey(String string, String string2, int n) {
        Hashtable<String, Integer> hashtable = (Hashtable<String, Integer>)this.m_rowKey.get(string);
        if (hashtable == null) {
            hashtable = new Hashtable<String, Integer>();
            this.m_rowKey.put(string, hashtable);
        }
        hashtable.put(string2, new Integer(n));
    }

    Integer getRow(String string, String string2) {
        Integer n = null;
        Hashtable hashtable = (Hashtable)this.m_rowKey.get(string);
        if (hashtable != null) {
            n = (Integer)hashtable.get(string2);
        }
        return n;
    }

    void addRow(String string, String string2, Object[] objectArray) {
        int n = this.getNumRows();
        int n2 = this.getNumColumns();
        this.addRow(objectArray);
        this.setRowObject(n, new LEMonitorData(string2, n2));
        this.saveRowKey(string, string2, n);
        this.layoutGrid();
    }

    void resetColumn(int n) {
        int n2 = this.getNumRows();
        int n3 = 0;
        while (n3 < n2) {
            Long l;
            LEMonitorData lEMonitorData = (LEMonitorData)this.getRowObject(n3);
            if (lEMonitorData != null && (l = (Long)this.getCellItem(n3, n)) != null) {
                lEMonitorData.resetColumn(n, l);
                this.setCellItem(n3, n, ZERO);
            }
            ++n3;
        }
    }

    void restoreColumn(int n) {
        int n2 = this.getNumRows();
        int n3 = 0;
        while (n3 < n2) {
            Long l;
            LEMonitorData lEMonitorData = (LEMonitorData)this.getRowObject(n3);
            if (lEMonitorData != null && (l = (Long)this.getCellItem(n3, n)) != null) {
                this.setCellItem(n3, n, new Long(l + lEMonitorData.getReset(n)));
                lEMonitorData.restoreColumn(n);
            }
            ++n3;
        }
    }

    int parseBoardID(String string) {
        int n;
        block2: {
            n = -1;
            if (string == null || string.length() <= 0) break block2;
            try {
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {
                LEDebug.getLog().logln(20, exception);
            }
        }
        return n;
    }

    void startMonitoring(LEPortMaster lEPortMaster) {
        this.startMonitoring(lEPortMaster, null);
    }

    void startMonitoring(LEPortMaster lEPortMaster, String string) {
        int n;
        int n2 = this.parseBoardID(string);
        String string2 = lEPortMaster.getHostname();
        LEStatusFactory.GetFactory().addObserver(string2, this);
        LEMonitorFacility lEMonitorFacility = lEPortMaster.getMonitorFacility();
        if (lEMonitorFacility == null) {
            return;
        }
        int[] nArray = this.getMonitorEntities();
        if (nArray != null) {
            LEMonitorFactory.GetFactory().addObserver(string2, this);
            n = 0;
            while (n < nArray.length) {
                lEMonitorFacility.startMonitor(nArray[n], n2);
                ++n;
            }
        }
        if ((nArray = this.getDeltaEntities()) != null) {
            LEDeltaFactory.GetFactory().addObserver(string2, this);
            n = 0;
            while (n < nArray.length) {
                lEMonitorFacility.startDelta(nArray[n], n2);
                ++n;
            }
        }
    }

    void stopMonitoring(LEPortMaster lEPortMaster) {
        this.stopMonitoring(lEPortMaster, null);
    }

    void stopMonitoring(LEPortMaster lEPortMaster, String string) {
        int n;
        int n2 = this.parseBoardID(string);
        String string2 = lEPortMaster.getHostname();
        LEStatusFactory.GetFactory().deleteObserver(string2, this);
        LEMonitorFacility lEMonitorFacility = lEPortMaster.getMonitorFacility();
        if (lEMonitorFacility == null) {
            return;
        }
        int[] nArray = this.getMonitorEntities();
        if (nArray != null) {
            LEMonitorFactory.GetFactory().deleteObserver(string2, this);
            n = 0;
            while (n < nArray.length) {
                lEMonitorFacility.stopMonitor(nArray[n], n2);
                ++n;
            }
        }
        if ((nArray = this.getDeltaEntities()) != null) {
            LEDeltaFactory.GetFactory().deleteObserver(string2, this);
            n = 0;
            while (n < nArray.length) {
                lEMonitorFacility.stopDelta(nArray[n], n2);
                ++n;
            }
        }
        this.m_rowKey.remove(string2);
        int n3 = this.getNumRows();
        int n4 = n3 - 1;
        while (n4 > -1) {
            String string3 = (String)this.getCellItem(n4, 0);
            if (string3.equals(string2)) {
                this.deleteRow(n4);
            }
            --n4;
        }
    }

    int[] getMonitorEntities() {
        return null;
    }

    int[] getDeltaEntities() {
        return null;
    }

    abstract void createColumnTitles(int var1, int var2, Object[] var3);

    public abstract void update(LEAMFactory var1, String var2, Object var3);
}

