/*
 * Decompiled with CFR 0.152.
 */
import COM.livingston.amf.LEAMFactory;
import COM.livingston.amf.LEAMObserver;
import COM.livingston.backend.LEStatusFactory;
import COM.livingston.backend.LEStatusMessage;
import COM.livingston.forms.LERebootDialog;
import COM.livingston.model.LEPortMaster;
import COM.livingston.ui.LEMLEvent;
import COM.livingston.ui.LEMultiList;
import COM.livingston.ui.LEUiUtils;
import COM.livingston.util.LEUpTimeCompare;
import java.util.Enumeration;
import java.util.Hashtable;

public class LEPMGrid
extends LEMultiList
implements LEAMObserver,
Runnable {
    public static final String REBOOTING = "Rebooting...";
    public static final String NOT_CONNECTED = "Connection Lost";
    static final int COLUMNS = 4;
    Hashtable m_pms = new Hashtable();

    public LEPMGrid() {
        super(1, 0, 4);
        Object[] objectArray = new String[]{new String("PortMaster"), new String("Model"), new String("ComOS"), new String("Up Time")};
        this.setTitles(0, objectArray);
        this.setSortable(0, true);
        this.setSortable(1, true);
        this.setSortable(2, true);
        this.setSortable(3, true);
        this.setSortObject(3, LEUpTimeCompare.getCompareObject());
        this.setCellJustification(3, 2);
        LEStatusFactory.GetFactory().addObserver("", this);
        Thread thread = new Thread(this);
        thread.setName("LEPMGrid Updater");
        thread.start();
    }

    public synchronized boolean connectedTo(String string) {
        return this.m_pms.containsKey(string);
    }

    public synchronized LEPortMaster getPortMaster(String string) {
        return (LEPortMaster)this.m_pms.get(string);
    }

    public void addPortMaster(String string, LEPortMaster lEPortMaster) {
        this.m_pms.put(string, lEPortMaster);
        Object[] objectArray = new String[]{string, lEPortMaster.getHardwareType(), lEPortMaster.getSoftwareVersion(), lEPortMaster.getUpTime()};
        this.addRow(objectArray);
        if (this.m_pms.size() == 1) {
            int[] nArray = new int[]{0};
            this.selectRows(nArray);
        }
        this.repaint();
    }

    public synchronized void deletePortMaster(LEPortMaster lEPortMaster) {
        if (lEPortMaster == null) {
            return;
        }
        lEPortMaster.disconnect();
    }

    public synchronized void removeSelectedPMs() {
        LEPortMaster[] lEPortMasterArray = this.getSelectedPMs();
        int n = 0;
        while (n < lEPortMasterArray.length) {
            this.removePM(lEPortMasterArray[n]);
            ++n;
        }
    }

    public synchronized void removePM(LEPortMaster lEPortMaster) {
        String string = lEPortMaster.getHostname();
        int n = this.getPortMasterRow(string);
        this.m_pms.remove(string);
        LECommandView.removePM(string);
        LEDebugView.RemovePM(string);
        this.deletePortMaster(lEPortMaster);
        this.deleteRow(n);
    }

    public synchronized void deleteSelectedPMs() {
        LEPortMaster[] lEPortMasterArray = this.getSelectedPMs();
        int n = 0;
        while (n < lEPortMasterArray.length) {
            this.deletePortMaster(lEPortMasterArray[n]);
            ++n;
        }
    }

    public synchronized void reconnectSelectedPMs() {
        LEPortMaster[] lEPortMasterArray = this.getSelectedPMs();
        int n = 0;
        while (n < lEPortMasterArray.length) {
            if (!lEPortMasterArray[n].isConnected()) {
                new LEReconnectThread(lEPortMasterArray[n]);
            }
            ++n;
        }
    }

    public synchronized void rebootSelectedPMs() {
        LEPortMaster[] lEPortMasterArray = this.getSelectedPMs();
        String[] stringArray = new String[1];
        int n = 0;
        while (n < lEPortMasterArray.length) {
            stringArray[0] = "Reboot " + lEPortMasterArray[n].getHostname() + "?";
            LERebootDialog lERebootDialog = new LERebootDialog(LEUiUtils.getFrame(this), stringArray);
            if (lERebootDialog.shouldReboot()) {
                new LERebootThread(lEPortMasterArray[n]);
            }
            ++n;
        }
    }

    public synchronized LEPortMaster[] getSelectedPMs() {
        int[] nArray = this.getSelectedRows();
        LEPortMaster[] lEPortMasterArray = new LEPortMaster[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            String string = (String)this.getCellItem(nArray[n], 0);
            lEPortMasterArray[n] = (LEPortMaster)this.m_pms.get(string);
            ++n;
        }
        return lEPortMasterArray;
    }

    public void updateUpTimes() {
        int n = this.getNumRows();
        int n2 = 0;
        while (n2 < n) {
            LEPortMaster lEPortMaster;
            String string = (String)this.getCellItem(n2, 0);
            if (string != null && (lEPortMaster = (LEPortMaster)this.m_pms.get(string)) != null && lEPortMaster.isConnected() && lEPortMaster.ping()) {
                this.setCellItem(n2, 2, lEPortMaster.getSoftwareVersion());
                this.setCellItem(n2, 3, lEPortMaster.getUpTime());
            }
            ++n2;
        }
    }

    public synchronized void update(LEAMFactory lEAMFactory, String string, Object object) {
        if (object instanceof LEStatusMessage) {
            LEStatusMessage lEStatusMessage = (LEStatusMessage)object;
            LEPortMaster lEPortMaster = (LEPortMaster)this.m_pms.get(string);
            if (lEPortMaster == null) {
                return;
            }
            String string2 = null;
            String string3 = null;
            switch (lEStatusMessage.getStatus()) {
                case 1: {
                    lEPortMaster.ping();
                    string2 = lEPortMaster.getUpTime();
                    string3 = lEPortMaster.getSoftwareVersion();
                    break;
                }
                case 2: {
                    string2 = NOT_CONNECTED;
                    break;
                }
                case 4: {
                    string2 = REBOOTING;
                    break;
                }
            }
            if (string2 != null || string3 != null) {
                int n = this.getPortMasterRow(string);
                if (n > -1) {
                    if (string3 != null) {
                        this.setCellItem(n, 2, string3);
                    }
                    if (string2 != null) {
                        this.setCellItem(n, 3, string2);
                    }
                }
                this.notifyListeners(new LEMLEvent(3));
            }
        }
    }

    public void shutdown() {
        Enumeration enumeration = this.m_pms.elements();
        while (enumeration.hasMoreElements()) {
            LEPortMaster lEPortMaster = (LEPortMaster)enumeration.nextElement();
            lEPortMaster.disconnect();
        }
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    Thread.currentThread();
                    Thread.sleep(90000L);
                    this.updateUpTimes();
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    int getPortMasterRow(String string) {
        int n = -1;
        int n2 = this.getNumRows();
        int n3 = 0;
        while (n == -1 && n3 < n2) {
            if (string.equals((String)this.getCellItem(n3, 0))) {
                n = n3;
            }
            ++n3;
        }
        return n;
    }
}

