/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.model.LEConfig;
import COM.livingston.model.LEConfigFacility;
import COM.livingston.util.LEVector;

public class LEEthernet
extends LEConfig {
    public static final String ADDRESS = "9";
    public static final String BROADCAST = "186";
    public static final String COST = "242";
    public static final String DEADTIME = "244";
    public static final String HELLOINTERVAL = "243";
    public static final String INPUT_FILTER = "193";
    public static final String IP_STATUS = "191";
    public static final String IPX_FRAME = "190";
    public static final String IPX_NETWORK = "189";
    public static final String IPX_STATUS = "192";
    public static final String MAC_ADDRESS = "195";
    public static final String NAT_TCP_TIMEOUT = "353";
    public static final String NAT_OTHER_TIMEOUT = "354";
    public static final String NAT_FAIL_ACTION = "355";
    public static final String NAT_IN_MAP = "356";
    public static final String NAT_PROXY_IN_MAP = "357";
    public static final String NAT_OUT_MAP = "358";
    public static final String NAT_PROXY_OUT_MAP = "359";
    public static final String NAT_LOG_FAILURE = "360";
    public static final String NAT_LOG_SUCCESS = "361";
    public static final String NAT_LOG_SYSLOG = "362";
    public static final String NAT_LOG_CONSOLE = "363";
    public static final String NETMASK = "15";
    public static final String OSPF_STATUS = "246";
    public static final String OUTPUT_FILTER = "194";
    public static final String RIP_BROAD = "187";
    public static final String RIP_LISTEN = "188";
    public static final int KEY_COUNT = 27;
    public static final String HIGH = "high";
    public static final String LOW = "low";
    public static final String ETHERNET_802_2 = "ethernet_802.2";
    public static final String ETHERNET_802_2_II = "ethernet_802.2_ii";
    public static final String ETHERNET_802_3 = "ethernet_802.3";
    public static final String ETHERNET_II = "ethernet_ii";
    static String[] s_keys = null;
    String m_name;

    public static String[] GetAllPossibleKeys() {
        if (s_keys == null) {
            s_keys = new String[27];
            int i = 0;
            LEEthernet.s_keys[i++] = ADDRESS;
            LEEthernet.s_keys[i++] = BROADCAST;
            LEEthernet.s_keys[i++] = COST;
            LEEthernet.s_keys[i++] = DEADTIME;
            LEEthernet.s_keys[i++] = HELLOINTERVAL;
            LEEthernet.s_keys[i++] = INPUT_FILTER;
            LEEthernet.s_keys[i++] = IP_STATUS;
            LEEthernet.s_keys[i++] = IPX_FRAME;
            LEEthernet.s_keys[i++] = IPX_NETWORK;
            LEEthernet.s_keys[i++] = IPX_STATUS;
            LEEthernet.s_keys[i++] = MAC_ADDRESS;
            LEEthernet.s_keys[i++] = NAT_TCP_TIMEOUT;
            LEEthernet.s_keys[i++] = NAT_OTHER_TIMEOUT;
            LEEthernet.s_keys[i++] = NAT_FAIL_ACTION;
            LEEthernet.s_keys[i++] = NAT_IN_MAP;
            LEEthernet.s_keys[i++] = NAT_PROXY_IN_MAP;
            LEEthernet.s_keys[i++] = NAT_OUT_MAP;
            LEEthernet.s_keys[i++] = NAT_PROXY_OUT_MAP;
            LEEthernet.s_keys[i++] = NAT_LOG_FAILURE;
            LEEthernet.s_keys[i++] = NAT_LOG_SUCCESS;
            LEEthernet.s_keys[i++] = NAT_LOG_SYSLOG;
            LEEthernet.s_keys[i++] = NAT_LOG_CONSOLE;
            LEEthernet.s_keys[i++] = NETMASK;
            LEEthernet.s_keys[i++] = OSPF_STATUS;
            LEEthernet.s_keys[i++] = OUTPUT_FILTER;
            LEEthernet.s_keys[i++] = RIP_BROAD;
            LEEthernet.s_keys[i++] = RIP_LISTEN;
        }
        return s_keys;
    }

    public LEEthernet(LEConfigFacility facility, String board, String name) {
        super(facility, board);
        this.m_name = name;
    }

    public LEEthernet(LEConfigFacility facility, String name) {
        super(facility);
        this.m_name = name;
    }

    public Object clone() {
        LEEthernet config = new LEEthernet(this.m_facility, this.m_board, this.m_name);
        config.copy(this);
        return config;
    }

    boolean generateCommands(LEVector keys, LEVector cmds) {
        boolean allCmds = keys == null;
        int start = cmds.size();
        if (allCmds || keys.contains(ADDRESS)) {
            this.makeSetCommand(cmds, this.m_name, ADDRESS, "address");
        }
        if (allCmds || keys.contains(BROADCAST)) {
            this.makeSetCommand(cmds, this.m_name, BROADCAST, "broadcast");
        }
        if (allCmds || keys.contains(INPUT_FILTER)) {
            this.makeSetCommand(cmds, this.m_name, INPUT_FILTER, "ifilter");
        }
        if (allCmds || keys.contains(IP_STATUS)) {
            this.makeSetCommand(cmds, this.m_name, IP_STATUS, "ip");
        }
        if (allCmds || keys.contains(IPX_FRAME)) {
            this.makeSetCommand(cmds, this.m_name, IPX_FRAME, "ipxframe");
        }
        if (allCmds || keys.contains(IPX_NETWORK)) {
            this.makeSetCommand(cmds, this.m_name, IPX_NETWORK, "ipxnet");
        }
        if (allCmds || keys.contains(IPX_STATUS)) {
            this.makeSetCommand(cmds, this.m_name, IPX_STATUS, "ipx");
        }
        if (allCmds || keys.contains(NAT_TCP_TIMEOUT)) {
            this.makeNATTimeOutCommand(cmds, this.m_name, NAT_TCP_TIMEOUT, NAT_TCP_TIMEOUT);
        }
        if (allCmds || keys.contains(NAT_OTHER_TIMEOUT)) {
            this.makeNATTimeOutCommand(cmds, this.m_name, NAT_OTHER_TIMEOUT, NAT_OTHER_TIMEOUT);
        }
        if (allCmds || keys.contains(NAT_FAIL_ACTION)) {
            this.makeNATFailActionCommand(cmds, this.m_name, NAT_FAIL_ACTION);
        }
        if (allCmds || keys.contains(NAT_IN_MAP)) {
            this.makeNATMapCommand(cmds, this.m_name, NAT_IN_MAP, true, false);
        }
        if (allCmds || keys.contains(NAT_PROXY_IN_MAP)) {
            this.makeNATMapCommand(cmds, this.m_name, NAT_PROXY_IN_MAP, true, true);
        }
        if (allCmds || keys.contains(NAT_OUT_MAP)) {
            this.makeNATMapCommand(cmds, this.m_name, NAT_OUT_MAP, false, false);
        }
        if (allCmds || keys.contains(NAT_PROXY_OUT_MAP)) {
            this.makeNATMapCommand(cmds, this.m_name, NAT_PROXY_OUT_MAP, false, true);
        }
        if (allCmds || keys.contains(NAT_LOG_FAILURE)) {
            this.makeNATLogCommand(cmds, this.m_name, NAT_LOG_FAILURE, NAT_LOG_FAILURE);
        }
        if (allCmds || keys.contains(NAT_LOG_SUCCESS)) {
            this.makeNATLogCommand(cmds, this.m_name, NAT_LOG_SUCCESS, NAT_LOG_SUCCESS);
        }
        if (allCmds || keys.contains(NAT_LOG_SYSLOG)) {
            this.makeNATLogCommand(cmds, this.m_name, NAT_LOG_SYSLOG, NAT_LOG_SYSLOG);
        }
        if (allCmds || keys.contains(NAT_LOG_CONSOLE)) {
            this.makeNATLogCommand(cmds, this.m_name, NAT_LOG_CONSOLE, NAT_LOG_CONSOLE);
        }
        if (allCmds || keys.contains(NETMASK)) {
            this.makeSetCommand(cmds, this.m_name, NETMASK, "netmask");
        }
        if (allCmds || keys.contains(OUTPUT_FILTER)) {
            this.makeSetCommand(cmds, this.m_name, OUTPUT_FILTER, "ofilter");
        }
        if (allCmds || keys.contains(RIP_BROAD) || keys.contains(RIP_LISTEN)) {
            this.makeRIPCommand(cmds, this.m_name, "rip", (String)this.get(RIP_BROAD), (String)this.get(RIP_LISTEN));
        }
        if ((allCmds || keys.contains(OSPF_STATUS)) && this.get(OSPF_STATUS) != null) {
            StringBuffer buf = new StringBuffer(100);
            buf.append("set ");
            buf.append(" ");
            buf.append(this.m_name);
            buf.append(" ospf ");
            String status = (String)this.get(OSPF_STATUS);
            buf.append(status);
            if (status.equals("on")) {
                String dead;
                String hello;
                String cost = (String)this.get(COST);
                if (cost != null && cost.length() > 0) {
                    buf.append(" cost ");
                    buf.append(cost);
                }
                if ((hello = (String)this.get(HELLOINTERVAL)) != null && hello.length() > 0) {
                    buf.append(" hello-interval ");
                    buf.append(hello);
                }
                if ((dead = (String)this.get(DEADTIME)) != null && dead.length() > 0) {
                    buf.append(" dead-time ");
                    buf.append(dead);
                }
            }
            buf.append(" ");
            cmds.add(new String(buf));
        }
        return cmds.size() > start;
    }
}

