/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.backend.LEDSSFlatFile;
import COM.livingston.backend.LEPMCommand;
import COM.livingston.model.LEConfig;
import COM.livingston.model.LEConfigFacility;
import COM.livingston.model.LEFilterFileParser;
import COM.livingston.model.LEFilters;
import COM.livingston.model.LELocationFileParser;
import COM.livingston.model.LELocations;
import COM.livingston.util.LEAppInfo;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LEVector;
import java.io.IOException;

public class LEFileConfigFacility
implements LEConfigFacility {
    String m_path;
    LEConfig m_config;
    LEDSSFlatFile m_dssfile;
    int m_mode;

    public LEFileConfigFacility(LEConfig config, String dirname, String filename) {
        this.m_path = LEAppInfo.createFullPath(dirname, filename);
        this.m_config = config;
        this.m_dssfile = null;
        this.m_mode = -1;
    }

    public boolean getConfig(String key) {
        try {
            this.openFile(0);
            LEVector cmds = this.m_dssfile.getCommands();
            if (key.equals("filter")) {
                LEFilterFileParser parser = new LEFilterFileParser();
                parser.readFilters(cmds);
                LEFilters filters = parser.getFilters();
                this.m_config.set(key, filters);
            } else if (key.equals("1703936")) {
                LELocationFileParser parser = new LELocationFileParser();
                parser.createPatterns();
                parser.readLocations(cmds);
                LELocations locations = parser.getLocations();
                this.m_config.set(key, locations);
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
            return false;
        }
        return true;
    }

    public boolean getConfig(String key, String board_id) {
        return this.getConfig(key);
    }

    public String getDescription() {
        return this.m_path;
    }

    public LEPMCommand execute(String command) {
        LEVector cmd = new LEVector(1);
        cmd.add(command);
        LEPMCommand pmcmd = new LEPMCommand(command);
        try {
            this.openFile(1);
            this.m_dssfile.writeConfig(cmd);
            pmcmd.setStatus(true);
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
            pmcmd.setResult("No connection");
            pmcmd.setStatus(false);
        }
        cmd = null;
        return pmcmd;
    }

    public void close() throws IOException {
        if (this.m_dssfile != null) {
            this.m_dssfile.disconnect();
        }
        this.m_dssfile = null;
    }

    protected void openFile(int mode) throws IOException {
        if (this.m_dssfile != null) {
            if (this.m_mode == mode) {
                return;
            }
            this.m_dssfile.disconnect();
            this.m_dssfile = null;
        }
        this.m_mode = mode;
        this.m_dssfile = new LEDSSFlatFile(this.m_path, this.m_mode);
        this.m_dssfile.connect();
    }
}

