/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.model.LEConfig;
import COM.livingston.model.LEConfigFacility;
import COM.livingston.model.LELine;
import COM.livingston.model.LETable;
import COM.livingston.util.LEVector;

public class LELines
extends LETable {
    public LELines(LEConfigFacility facility, String board, String key) {
        super(facility, board, key);
    }

    public LELines(LEConfigFacility facility) {
        super(facility);
    }

    public Object clone() {
        LELines config = new LELines(this.m_facility, this.m_board, this.m_fetchKey);
        config.copy(this);
        return config;
    }

    LEConfig createConfig(String key) {
        return new LELine(this.m_facility, this.m_board, key);
    }

    boolean getChangedCommands(LEVector cmds) {
        int start = cmds.size();
        boolean gen = super.getChangedCommands(cmds);
        if (gen) {
            this.checkCommands(cmds, start);
        }
        return gen;
    }

    boolean getAllCommands(LEVector cmds) {
        int start = cmds.size();
        boolean gen = super.getAllCommands(cmds);
        if (gen) {
            this.checkCommands(cmds, start);
        }
        return gen;
    }

    void checkCommands(LEVector cmds, int start) {
        if (this.m_board == null) {
            this.removeReboots(cmds, start);
        } else {
            this.removePowerCycles(cmds, start);
        }
    }

    void removeReboots(LEVector cmds, int start) {
        int end = cmds.size();
        int reboot = -1;
        int i = start;
        while (i < end) {
            String cmd = (String)cmds.elementAt(i);
            if (cmd.equals("reboot")) {
                if (reboot > 0) {
                    cmds.removeElementAt(reboot);
                    --end;
                }
                reboot = --i;
            }
            ++i;
        }
    }

    void removePowerCycles(LEVector cmds, int start) {
        String test = "set slot" + this.m_board + " on";
        int end = cmds.size();
        int power = -1;
        int i = start;
        while (i < end) {
            String cmd = (String)cmds.elementAt(i);
            if (cmd.equals(test)) {
                if (power > 0) {
                    cmds.removeElementAt(power);
                    cmds.removeElementAt(power - 1);
                    cmds.removeElementAt(power - 2);
                    i -= 3;
                    end -= 3;
                }
                power = i;
            }
            ++i;
        }
    }
}

