/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.backend.LEPMCommand;
import COM.livingston.model.LEConfig;
import COM.livingston.model.LEConfigFacility;
import COM.livingston.model.LELocation;
import COM.livingston.model.LETable;
import COM.livingston.util.LEVector;

public class LELocations
extends LETable {
    public LELocations(LEConfigFacility facility) {
        super(facility);
    }

    public Object clone() {
        LELocations config = new LELocations(this.m_facility);
        config.copy(this);
        return config;
    }

    public LEVector add(String name) {
        LEVector errors = null;
        String cmd = this.makeAddCommand("location", name);
        LEPMCommand ret = this.m_facility.execute(cmd);
        if (ret.getStatus()) {
            ret = this.m_facility.execute("save all");
            if (!ret.getStatus()) {
                errors = new LEVector();
                errors.addElement(ret);
            }
            this.refresh();
        } else {
            errors = new LEVector();
            errors.addElement(ret);
        }
        return errors;
    }

    public LEVector delete(String name) {
        LEVector errors = null;
        String cmd = this.makeDeleteCommand("location", name);
        LEPMCommand ret = this.m_facility.execute(cmd);
        if (ret.getStatus()) {
            this.remove(name);
            ret = this.m_facility.execute("save all");
            if (!ret.getStatus()) {
                this.refresh();
            }
        }
        if (!ret.getStatus()) {
            errors = new LEVector();
            errors.addElement(ret);
        }
        return errors;
    }

    LEConfig createConfig(String key) {
        return new LELocation(this.m_facility, key);
    }

    boolean generateAddCommand(String key, LEVector cmds) {
        cmds.addElement(this.makeAddCommand("location", key));
        return true;
    }

    boolean generateDeleteCommand(String key, LEVector cmds) {
        cmds.addElement(this.makeDeleteCommand("location", key));
        return true;
    }
}

