/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.model.LEConfigFacility;
import COM.livingston.model.LEPort;
import COM.livingston.util.LEVector;

public class LEParallelPort
extends LEPort {
    public static final String DEVICE = Integer.toString(310);
    public static final String DISCONNECT = Integer.toString(311);
    public static final String HOST = Integer.toString(173);
    public static final String SERVICE = Integer.toString(309);
    public static final int KEY_COUNT = 4;
    static String[] s_keys = null;

    public static String[] GetAllPossibleKeys() {
        if (s_keys == null) {
            s_keys = new String[4];
            int i = 0;
            LEParallelPort.s_keys[i++] = DEVICE;
            LEParallelPort.s_keys[i++] = DISCONNECT;
            LEParallelPort.s_keys[i++] = HOST;
            LEParallelPort.s_keys[i++] = SERVICE;
        }
        return s_keys;
    }

    public LEParallelPort(LEConfigFacility facility, String board, String name) {
        super(facility, board, name);
    }

    public Object clone() {
        LEParallelPort config = new LEParallelPort(this.m_facility, this.m_board, this.m_name);
        config.copy(this);
        return config;
    }

    boolean generateCommands(LEVector keys, LEVector cmds) {
        boolean allCmds = keys == null;
        int start = cmds.size();
        if (allCmds || keys.contains(DEVICE)) {
            String device = (String)this.get(DEVICE);
            if (device.length() == 0 || device.equals("/")) {
                StringBuffer buf = new StringBuffer(16);
                buf.append("set ");
                buf.append(this.m_name);
                buf.append(" disabled");
                cmds.addElement(buf.toString());
            } else if (device != null) {
                StringBuffer buf = new StringBuffer(25);
                buf.append("set ");
                buf.append(this.m_name);
                buf.append(" device ");
                buf.append(device);
                cmds.addElement(buf.toString());
            }
        }
        if (allCmds || keys.contains(DISCONNECT)) {
            this.makeSetCommand(cmds, this.m_name, DISCONNECT, "disconnect");
        }
        if (allCmds || keys.contains(HOST)) {
            this.makeSetCommand(cmds, this.m_name, HOST, "host");
        }
        if (allCmds || keys.contains(SERVICE)) {
            this.makeServiceCommand(cmds, this.m_name, SERVICE, "service_device");
        }
        return cmds.size() > start;
    }
}

