/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.backend.LEPMCommand;
import COM.livingston.model.LEConfig;
import COM.livingston.model.LEConfigFacility;
import COM.livingston.model.LESubInterface;
import COM.livingston.model.LETable;
import COM.livingston.util.LEVector;

public class LESubInterfaces
extends LETable {
    public LESubInterfaces(LEConfigFacility facility) {
        super(facility);
    }

    public Object clone() {
        LESubInterfaces config = new LESubInterfaces(this.m_facility);
        config.copy(this);
        return config;
    }

    public LEVector add(String subname) {
        LEVector errors = null;
        String cmd = this.makeAddCommand("subinterface", subname);
        LEPMCommand ret = this.m_facility.execute(cmd);
        if (ret.getStatus()) {
            ret = this.m_facility.execute("save all");
            this.refresh();
        }
        if (!ret.getStatus()) {
            errors = new LEVector();
            errors.addElement(ret);
        }
        return errors;
    }

    public LEVector delete(String subname) {
        LESubInterface sub = (LESubInterface)this.get(subname);
        if (sub == null) {
            return null;
        }
        LEVector errors = null;
        String cmd = this.makeDeleteCommand("subinterface", subname);
        LEPMCommand ret = this.m_facility.execute(cmd);
        if (ret.getStatus()) {
            this.m_fields.remove(subname);
            ret = this.m_facility.execute("save all");
            if (!ret.getStatus()) {
                this.refresh();
            }
        }
        if (!ret.getStatus()) {
            errors = new LEVector();
            errors.addElement(ret);
        }
        return errors;
    }

    LEConfig createConfig(String key) {
        return new LESubInterface(this.m_facility, key);
    }

    boolean generateAddCommand(String key, LEVector cmds) {
        cmds.addElement(this.makeAddCommand("subinterface", key));
        return true;
    }

    boolean generateDeleteCommand(String key, LEVector cmds) {
        cmds.addElement(this.makeDeleteCommand("subinterface", key));
        return true;
    }
}

