/*
 * Decompiled with CFR 0.152.
 */
import COM.livingston.amf.LEAMFactory;
import COM.livingston.backend.LEDSSException;
import COM.livingston.backend.LEDSSPortMaster;
import COM.livingston.backend.LEMonNATStatsMessage;
import COM.livingston.backend.LEMonitorFactory;
import COM.livingston.backend.LEStatusFactory;
import COM.livingston.backend.LEStatusMessage;
import COM.livingston.model.LEPortMaster;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LEVector;

public class LEMonNATStatsView
extends LEMonitorPanel {
    public LEMonNATStatsView() {
        this.initialize(1, 2, 9);
        int n = this.getNumColumns();
        int n2 = 2;
        while (n2 < n) {
            this.setCellJustification(n2, 2);
            ++n2;
        }
        this.m_resetCols = new int[9];
        int n3 = 0;
        while (n3 < 9) {
            this.m_resetCols[n3] = n3 + 2;
            ++n3;
        }
    }

    public synchronized void update(LEAMFactory lEAMFactory, String string, Object object) {
        if (this.m_pms == null) {
            return;
        }
        if (object instanceof LEMonNATStatsMessage) {
            LEMonNATStatsMessage lEMonNATStatsMessage = (LEMonNATStatsMessage)object;
            String string2 = String.valueOf(lEMonNATStatsMessage.getName()) + lEMonNATStatsMessage.getPortName();
            Integer n = this.getRow(string, string2 = String.valueOf(string2) + lEMonNATStatsMessage.getSessionDirection());
            if (n == null) {
                this.createRow(string, string2, lEMonNATStatsMessage);
                return;
            }
            this.updateRow(n, lEMonNATStatsMessage);
            return;
        }
        if (object instanceof LEStatusMessage) {
            this.updateStatus(string, (LEStatusMessage)object);
        }
    }

    void createColumnTitles(int n, int n2, Object[] objectArray) {
        objectArray[n2++] = new String("Port Name");
        objectArray[n2++] = new String("Session Direction");
        objectArray[n2++] = new String("Good Translated Packets");
        objectArray[n2++] = new String("Internal Failures");
        objectArray[n2++] = new String("Address/TU Port Shortages");
        objectArray[n2++] = new String("Invalid Direction");
        objectArray[n2++] = new String("Session Timeouts");
        objectArray[n2++] = new String("Session Limits Exceeded");
        objectArray[n2++] = new String("Session Types Not Allowed");
        objectArray[n2++] = new String("Miscellaneous Failures");
    }

    void createRow(String string, String string2, LEMonNATStatsMessage lEMonNATStatsMessage) {
        Object[] objectArray = new Object[this.getNumColumns()];
        int n = 0;
        objectArray[n++] = string;
        objectArray[n++] = lEMonNATStatsMessage.getName();
        objectArray[n++] = lEMonNATStatsMessage.getSessionDirection();
        objectArray[n++] = new Long(lEMonNATStatsMessage.getGoodPackets());
        objectArray[n++] = new Long(lEMonNATStatsMessage.getInternalErrors());
        objectArray[n++] = new Long(lEMonNATStatsMessage.getPortShortages());
        objectArray[n++] = new Long(lEMonNATStatsMessage.getInvalidDir());
        objectArray[n++] = new Long(lEMonNATStatsMessage.getTimeouts());
        objectArray[n++] = new Long(lEMonNATStatsMessage.getLimitsExceeded());
        objectArray[n++] = new Long(lEMonNATStatsMessage.getTypesNotAllowed());
        objectArray[n++] = new Long(lEMonNATStatsMessage.getMiscFailures());
        this.addRow(string, string2, objectArray);
    }

    void updateRow(int n, LEMonNATStatsMessage lEMonNATStatsMessage) {
        LEMonitorData lEMonitorData = (LEMonitorData)this.getRowObject(n);
        if (lEMonitorData == null) {
            return;
        }
        int n2 = 0;
        ++n2;
        ++n2;
        ++n2;
        this.setCellItem(n, ++n2, lEMonitorData.getCounter(n2, lEMonNATStatsMessage.getGoodPackets()));
        this.setCellItem(n, ++n2, lEMonitorData.getCounter(n2, lEMonNATStatsMessage.getInternalErrors()));
        this.setCellItem(n, ++n2, lEMonitorData.getCounter(n2, lEMonNATStatsMessage.getPortShortages()));
        this.setCellItem(n, ++n2, lEMonitorData.getCounter(n2, lEMonNATStatsMessage.getInvalidDir()));
        this.setCellItem(n, ++n2, lEMonitorData.getCounter(n2, lEMonNATStatsMessage.getTimeouts()));
        this.setCellItem(n, ++n2, lEMonitorData.getCounter(n2, lEMonNATStatsMessage.getLimitsExceeded()));
        this.setCellItem(n, ++n2, lEMonitorData.getCounter(n2, lEMonNATStatsMessage.getTypesNotAllowed()));
        this.setCellItem(n, ++n2, lEMonitorData.getCounter(n2, lEMonNATStatsMessage.getMiscFailures()));
    }

    void startMonitoring(LEPortMaster lEPortMaster) {
        String string = lEPortMaster.getHostname();
        LEStatusFactory.GetFactory().addObserver(string, this);
        LEMonitorFactory.GetFactory().addObserver(string, this);
        LEDSSPortMaster lEDSSPortMaster = lEPortMaster.getDSS();
        try {
            long l = lEDSSPortMaster.monitor(0x2B0000, 30000);
            LEVector lEVector = new LEVector();
            lEVector.addElement(new Long(l));
            this.m_monitors.put(string, lEVector);
            return;
        }
        catch (LEDSSException lEDSSException) {
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return;
        }
    }

    String getMonitorName() {
        return "Monitor NAT Statistics";
    }
}

