/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.button;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import oracle.ewt.button.ButtonContent;
import oracle.ewt.graphics.GraphicUtils;

public class TextContent
implements ButtonContent {
    private Component _parent;
    private String _text;
    private static final int _TEXT_MARGIN = 1;

    public TextContent(String string) {
        this._text = string;
    }

    public void setParent(Component component) {
        this._parent = component;
    }

    public Component getParent() {
        return this._parent;
    }

    public String getText() {
        return this._text;
    }

    public void setText(String string) {
        String string2 = this.getText();
        if (string2 == string) {
            return;
        }
        this._text = string;
        if (string2 != null && string2.equals(string)) {
            return;
        }
        Component component = this.getParent();
        if (component != null && component.isShowing()) {
            component.invalidate();
            component.repaint();
        }
    }

    public Dimension getPreferredSize() {
        Component component = this.getParent();
        Font font = component.getFont();
        if (font != null) {
            FontMetrics fontMetrics = component.getFontMetrics(font);
            String string = this.getText();
            if (fontMetrics != null && string != null) {
                return new Dimension(fontMetrics.stringWidth(string) + 2, fontMetrics.getHeight() + 2);
            }
        }
        return new Dimension(0, 0);
    }

    public void paint(Graphics graphics, int n, int n2, int n3, int n4) {
        String string = this.getText();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n5 = (n3 - fontMetrics.stringWidth(string)) / 2;
        int n6 = (n4 - fontMetrics.getHeight()) / 2;
        if (string != null && fontMetrics != null) {
            n += n5;
            n2 += n6 + fontMetrics.getAscent();
            if (this.getParent().isEnabled()) {
                graphics.drawString(string, n, n2);
                return;
            }
            GraphicUtils.drawDisabledString(graphics, string, n, n2);
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + ": " + this.getText();
    }
}

