/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.backend.LEDSSException;
import COM.livingston.backend.LEDSSPortMaster;
import COM.livingston.model.LEMonitorSetting;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LEVector;
import java.util.Enumeration;
import java.util.Hashtable;

public class LEDebugFacility {
    public static final int NO_BOARD = -1;
    LEDSSPortMaster m_dss;
    Hashtable m_hexes = new Hashtable();
    Hashtable m_hexReqs = new Hashtable();
    Hashtable m_boards = new Hashtable();

    public LEDebugFacility(LEDSSPortMaster dss) {
        this.m_dss = dss;
    }

    public synchronized boolean startDebug(int entity, int debug, int board) {
        if (entity == 393216) {
            return this.startHexDebug(debug, board);
        }
        return this.startEntityDebug(entity, debug, board);
    }

    public synchronized void stopDebug(int entity, int debug, int board) {
        if (entity == 393216) {
            this.stopHexDebug(debug, board);
        } else {
            this.stopEntityDebug(entity, debug, board);
        }
    }

    public synchronized void shutdown() {
        this.m_hexes.clear();
        Enumeration enumeration = this.m_hexReqs.keys();
        while (enumeration.hasMoreElements()) {
            Integer id = (Integer)enumeration.nextElement();
            Long req = (Long)this.m_hexReqs.get(id);
            if (!this.m_dss.isConnected()) continue;
            this.resetHexDebug(req, 0, -1);
        }
        this.m_hexReqs.clear();
        Enumeration bds = this.m_boards.elements();
        while (bds.hasMoreElements()) {
            Hashtable entities = (Hashtable)bds.nextElement();
            Enumeration ents = entities.elements();
            while (ents.hasMoreElements()) {
                Hashtable debugs = (Hashtable)ents.nextElement();
                Enumeration dbgs = debugs.elements();
                while (dbgs.hasMoreElements()) {
                    LEMonitorSetting setting = (LEMonitorSetting)dbgs.nextElement();
                    try {
                        if (!this.m_dss.isConnected()) continue;
                        this.m_dss.killDebug(setting.getRequestID());
                    }
                    catch (LEDSSException lEDSSException) {
                    }
                    catch (Exception e) {
                        LEDebug.getLog().logln(20, e);
                    }
                }
                debugs.clear();
            }
            entities.clear();
        }
        this.m_boards.clear();
    }

    boolean startHexDebug(int hex, int board) {
        Integer id = new Integer(board);
        LEVector hexes = (LEVector)this.m_hexes.get(id);
        if (hexes == null) {
            hexes = new LEVector();
            this.m_hexes.put(id, hexes);
        }
        int old_mask = 0;
        int len = hexes.size();
        int i = 0;
        while (i < len) {
            old_mask |= ((Integer)hexes.elementAt(i)).intValue();
            ++i;
        }
        hexes.addElement(new Integer(hex));
        int mask = old_mask | hex;
        if (mask == old_mask) {
            return true;
        }
        long req = 0L;
        Long request = (Long)this.m_hexReqs.remove(id);
        if (request != null) {
            req = request;
        }
        if ((req = this.resetHexDebug(req, mask, board)) > 0L) {
            this.m_hexReqs.put(id, new Long(req));
            return true;
        }
        return false;
    }

    boolean startEntityDebug(int entity, int debug, int board) {
        Integer dbg;
        LEMonitorSetting setting;
        Integer ent;
        Hashtable<Integer, LEMonitorSetting> debugs;
        Integer id = new Integer(board);
        Hashtable entities = (Hashtable)this.m_boards.get(id);
        if (entities == null) {
            entities = new Hashtable();
            this.m_boards.put(id, entities);
        }
        if ((debugs = (Hashtable<Integer, LEMonitorSetting>)entities.get(ent = new Integer(entity))) == null) {
            debugs = new Hashtable<Integer, LEMonitorSetting>();
            entities.put(ent, debugs);
        }
        if ((setting = (LEMonitorSetting)debugs.get(dbg = new Integer(debug))) == null) {
            try {
                long request = 0L;
                request = board == -1 ? this.m_dss.debug(entity, debug) : this.m_dss.debug(entity, debug, board);
                setting = new LEMonitorSetting(request);
                debugs.put(dbg, setting);
            }
            catch (Exception e) {
                LEDebug.getLog().logln(20, e);
                return false;
            }
        } else {
            setting.increment();
        }
        return true;
    }

    void stopHexDebug(int hex, int board) {
        Integer id = new Integer(board);
        LEVector hexes = (LEVector)this.m_hexes.get(id);
        if (hexes == null) {
            return;
        }
        hexes.removeElement(new Integer(hex));
        int mask = 0;
        int len = hexes.size();
        int i = 0;
        while (i < len) {
            mask |= ((Integer)hexes.elementAt(i)).intValue();
            ++i;
        }
        int old_mask = mask | hex;
        if (old_mask == mask) {
            return;
        }
        long req = 0L;
        Long request = (Long)this.m_hexReqs.remove(id);
        if (request != null) {
            req = request;
        }
        if ((req = this.resetHexDebug(req, mask, board)) > 0L) {
            this.m_hexReqs.put(id, new Long(req));
        }
    }

    void stopEntityDebug(int entity, int debug, int board) {
        block5: {
            Integer id = new Integer(board);
            Hashtable entities = (Hashtable)this.m_boards.get(id);
            if (entities == null) {
                return;
            }
            Integer ent = new Integer(entity);
            Hashtable debugs = (Hashtable)entities.get(ent);
            if (debugs == null) {
                return;
            }
            Integer dbg = new Integer(debug);
            LEMonitorSetting setting = (LEMonitorSetting)debugs.get(dbg);
            if (setting == null) {
                return;
            }
            if (setting.decrement() != 0) break block5;
            debugs.remove(dbg);
            try {
                this.m_dss.killDebug(setting.getRequestID());
            }
            catch (Exception e) {
                LEDebug.getLog().logln(20, e);
            }
        }
    }

    long resetHexDebug(long request, int mask, int board) {
        block11: {
            if (request > 0L) {
                try {
                    if (this.m_dss.isConnected()) {
                        this.m_dss.killDebug(request);
                    }
                }
                catch (LEDSSException lEDSSException) {
                }
                catch (Exception e) {
                    LEDebug.getLog().logln(20, e);
                }
                request = 0L;
            }
            if (mask <= 0) break block11;
            try {
                if (board != -1) break block11;
                if (this.m_dss.isConnected()) {
                    request = this.m_dss.debug(393216, mask);
                } else if (this.m_dss.isConnected()) {
                    request = this.m_dss.debug(393216, mask, board);
                }
            }
            catch (LEDSSException lEDSSException) {
            }
            catch (Exception e) {
                LEDebug.getLog().logln(20, e);
            }
        }
        return request;
    }
}

