/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.model.LEConfig;
import COM.livingston.model.LEConfigFacility;
import COM.livingston.util.LEVector;

public class LERoute
extends LEConfig {
    public static final String CHANGED = Integer.toString(83);
    public static final String GATEWAY = Integer.toString(75);
    public static final String INTERFACE = Integer.toString(81);
    public static final String METRIC = Integer.toString(79);
    public static final String OBSOLETE = Integer.toString(84);
    public static final String SOURCE = Integer.toString(77);
    public static final String STATUS = Integer.toString(82);
    public static final String TYPE = Integer.toString(78);
    public static final int KEY_COUNT = 8;
    public static final String DYNAMIC = "dynamic";
    public static final String LOCAL = "local";
    public static final String STATIC = "static";
    public static final String HOST = "host";
    public static final String NETWORK = "network";
    static String[] s_keys = null;
    String m_name;

    public static String[] GetAllPossibleKeys() {
        if (s_keys == null) {
            s_keys = new String[8];
            int i = 0;
            LERoute.s_keys[i++] = CHANGED;
            LERoute.s_keys[i++] = GATEWAY;
            LERoute.s_keys[i++] = INTERFACE;
            LERoute.s_keys[i++] = METRIC;
            LERoute.s_keys[i++] = OBSOLETE;
            LERoute.s_keys[i++] = SOURCE;
            LERoute.s_keys[i++] = STATUS;
            LERoute.s_keys[i++] = TYPE;
        }
        return s_keys;
    }

    public LERoute(LEConfigFacility facility, String name) {
        super(facility);
        this.m_name = name;
    }

    public Object clone() {
        LERoute config = new LERoute(this.m_facility, this.m_name);
        config.copy(this);
        return config;
    }

    public String getName() {
        return this.m_name;
    }

    boolean generateCommands(LEVector keys, LEVector cmds) {
        boolean gen = false;
        String status = (String)this.get(STATUS);
        String source = (String)this.get(SOURCE);
        String obsolete = (String)this.get(OBSOLETE);
        if (status != null && status.equals(STATIC) && source != null && source.equals(LOCAL) && (obsolete == null || obsolete.equals("0"))) {
            String gateway = (String)this.get(GATEWAY);
            String metric = (String)this.get(METRIC);
            if (gateway != null && gateway.length() > 0 && metric != null && metric.length() > 0) {
                StringBuffer buf = new StringBuffer("add ");
                buf.append("route ");
                buf.append(this.m_name);
                buf.append(" ");
                buf.append(gateway);
                buf.append(" ");
                buf.append(metric);
                cmds.addElement(new String(buf));
                gen = true;
            }
        }
        return gen;
    }
}

