/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.ui;

import COM.livingston.ui.LEScrollPanel;
import COM.livingston.ui.LEScrollable;
import COM.livingston.util.LEDebug;
import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;

public abstract class LEGridTitles
extends Canvas
implements LEScrollable {
    String[] m_titles;
    int m_height = -1;
    int m_border;
    int m_width = -1;
    Image m_buf;
    int m_x;
    int m_y;

    public LEGridTitles(String[] stringArray, int n) {
        this.m_titles = stringArray;
        this.m_border = n;
    }

    public int getHeight() {
        if (this.m_height == -1) {
            this.calculateLayout();
        }
        return this.m_height;
    }

    public int getWidth() {
        if (this.m_width == -1) {
            this.calculateLayout();
        }
        return this.m_width;
    }

    public String getTitle(int n) {
        if (this.m_titles != null && n < this.m_titles.length) {
            return this.m_titles[n];
        }
        return null;
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.m_width, this.m_height);
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    public void update(Graphics graphics) {
        try {
            if (this.m_buf == null) {
                this.drawTitles();
            }
            graphics.drawImage(this.m_buf, this.m_x, this.m_y, null);
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return;
        }
    }

    public void setScrollPanel(LEScrollPanel lEScrollPanel) {
    }

    public void setOrigin(int n, int n2) {
        this.m_x = n;
        this.m_y = n2;
    }

    public void startScroll() {
    }

    public void scrollTo(int n, int n2) {
        this.m_x = n;
        this.m_y = n2;
        this.repaint();
    }

    public void endScroll() {
    }

    public Dimension totalArea() {
        return new Dimension(this.m_width, this.m_height);
    }

    abstract void drawTitles();

    abstract void calculateLayout();
}

