/*
 * Decompiled with CFR 0.152.
 */
import COM.livingston.amf.LEAMFactory;
import COM.livingston.amf.LEAMObserver;
import COM.livingston.backend.LEDeltaFactory;
import COM.livingston.backend.LEDeltaModemsMessage;
import COM.livingston.backend.LEMonIfacesMessage;
import COM.livingston.backend.LEMonLinesMessage;
import COM.livingston.backend.LEMonModemsMessage;
import COM.livingston.backend.LEMonSessionsMessage;
import COM.livingston.backend.LEMonitorFactory;
import COM.livingston.backend.LEStatusFactory;
import COM.livingston.backend.LEStatusMessage;
import COM.livingston.model.LEISDNPorts;
import COM.livingston.model.LELines;
import COM.livingston.model.LEModem;
import COM.livingston.model.LEModems;
import COM.livingston.model.LEMonitorFacility;
import COM.livingston.model.LEPortMaster;
import COM.livingston.model.LEPorts;
import COM.livingston.ui.LEColor;
import COM.livingston.ui.LEFont;
import COM.livingston.ui.LELEDs;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LEResource;
import COM.livingston.util.LEVector;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;

public class LEPM_3Display
implements LEMonitorDisplay,
LEAMObserver,
ImageObserver,
Runnable {
    public static final String DASH = "-";
    public static final String DOWN = "down";
    public static final String DOWN0 = "less than -22.5Db";
    public static final String DOWN1 = "-";
    public static final String ESTAB = "Established";
    public static final String LINE0 = "line0";
    public static final String LINE1 = "line1";
    public static final String LINE2 = "line2";
    public static final String SESSIONS = "Sessions";
    public static final int MAX_MODEMS = 60;
    public static final String NOT_CONNECTED = "Not connected";
    public static final String WRONG_COMOS = "Monitoring requires ComOS 3.8 or later";
    static Image s_pm3 = null;
    static Image s_wancard = null;
    LEPortMaster m_pm;
    String m_host;
    int m_height = -1;
    int m_width = -1;
    int m_nameHeight;
    int m_x;
    int m_y;
    int m_sessX;
    int m_sessY;
    int m_flags;
    int m_wanX;
    int m_wanY;
    int m_wanRow;
    int m_wanCol;
    boolean m_drawModems;
    boolean m_drawSessions;
    boolean m_drawLines;
    boolean m_drawInterfaces;
    boolean m_drawWanLines;
    boolean m_drawWan;
    boolean m_hasWan;
    boolean m_blink;
    boolean m_active;
    boolean m_connected;
    boolean m_drawHeartbeat;
    Image m_hb;
    Image m_line0Top;
    Image m_line0Bottom;
    Image m_line1Top;
    Image m_line1Bottom;
    Image m_line2Top;
    Image m_line2Bottom;
    Image m_etherTop;
    Image m_etherBottom;
    LEModem[] m_modems = new LEModem[60];
    Image[] m_sessions = new Image[60];
    int m_portsPerRow;

    public LEPM_3Display() {
        Toolkit toolkit;
        if (s_pm3 == null && !(toolkit = Toolkit.getDefaultToolkit()).prepareImage(s_pm3 = LEResource.GetImage("pm3.gif"), -1, -1, this)) {
            this.m_flags = 2;
        }
        if (s_wancard == null && !(toolkit = Toolkit.getDefaultToolkit()).prepareImage(s_wancard = LEResource.GetImage("wancard.gif"), -1, -1, this)) {
            this.m_flags = 2;
        }
        this.m_hb = LELEDs.GetLED(LELEDs.GREEN);
        this.m_line0Top = LELEDs.GetLED(LELEDs.GRAY);
        this.m_line0Bottom = LELEDs.GetLED(LELEDs.RED);
        this.m_line1Top = LELEDs.GetLED(LELEDs.GRAY);
        this.m_line1Bottom = LELEDs.GetLED(LELEDs.RED);
        this.m_line2Top = LELEDs.GetLED(LELEDs.GRAY);
        this.m_line2Bottom = LELEDs.GetLED(LELEDs.RED);
        this.m_etherTop = LELEDs.GetLED(LELEDs.GREEN);
        this.m_etherBottom = LELEDs.GetLED(LELEDs.GRAY);
    }

    public void setPortMaster(LEPortMaster lEPortMaster) {
        this.m_pm = lEPortMaster;
        this.m_host = this.m_pm.getHostname();
        this.m_connected = this.m_pm.isConnected();
        LEStatusFactory.GetFactory().addObserver(this.m_host, this);
        LEDeltaFactory.GetFactory().addObserver(this.m_host, this);
        LEMonitorFactory.GetFactory().addObserver(this.m_host, this);
        if (!this.m_connected) {
            this.m_hb = LELEDs.GetLED(LELEDs.GRAY);
            this.m_line0Top = LELEDs.GetLED(LELEDs.GRAY);
            this.m_line0Bottom = LELEDs.GetLED(LELEDs.GRAY);
            this.m_line1Top = LELEDs.GetLED(LELEDs.GRAY);
            this.m_line1Bottom = LELEDs.GetLED(LELEDs.GRAY);
            this.m_etherTop = LELEDs.GetLED(LELEDs.GRAY);
            this.m_etherBottom = LELEDs.GetLED(LELEDs.GRAY);
        }
        this.m_active = this.m_pm.getDSS().supportsEntities();
        if (this.m_active) {
            int n = 0;
            try {
                int n2;
                String string;
                int n3;
                LEPorts lEPorts = (LEPorts)lEPortMaster.get("262144");
                LELines lELines = (LELines)lEPortMaster.get("131072");
                LEModems lEModems = (LEModems)lEPortMaster.get("196608");
                LEVector lEVector = lELines.getKeys();
                LEISDNPorts lEISDNPorts = (LEISDNPorts)lEPorts.get("ISDNPort");
                if (lEISDNPorts != null) {
                    LEVector lEVector2 = lEISDNPorts.getKeys();
                    int n4 = lEVector2.size();
                    n3 = 0;
                    while (n3 < n4) {
                        string = (String)lEVector2.elementAt(n3);
                        if (string.startsWith("S")) {
                            n2 = Integer.parseInt(string.substring(1));
                            n = Math.max(n, n2);
                        }
                        ++n3;
                    }
                }
                int n5 = lEVector.size();
                n2 = 0;
                while (n2 < n5) {
                    string = (String)lEVector.elementAt(n2);
                    if (string.equals(LINE2)) {
                        this.m_drawWan = true;
                        this.m_hasWan = true;
                        this.m_wanRow = -1;
                        this.m_wanCol = -1;
                    }
                    ++n2;
                }
                if (this.m_hasWan) {
                    n3 = 0;
                    while (this.m_wanRow < 0 && n3 < 6) {
                        String string2 = "M" + Integer.toString(n3 * 10);
                        String string3 = (String)lEModems.get(string2);
                        if (string3 == null) {
                            switch (n3) {
                                case 0: {
                                    this.m_wanRow = 0;
                                    this.m_wanCol = 0;
                                    break;
                                }
                                case 1: {
                                    this.m_wanRow = 0;
                                    this.m_wanCol = 1;
                                    break;
                                }
                                case 2: {
                                    this.m_wanRow = 0;
                                    this.m_wanCol = 2;
                                    break;
                                }
                                case 3: {
                                    this.m_wanRow = 1;
                                    this.m_wanCol = 0;
                                    break;
                                }
                                case 4: {
                                    this.m_wanRow = 1;
                                    this.m_wanCol = 1;
                                    break;
                                }
                                case 5: {
                                    this.m_wanRow = 1;
                                    this.m_wanCol = 2;
                                    break;
                                }
                            }
                        }
                        ++n3;
                    }
                    if (this.m_wanRow == -1) {
                        this.m_wanRow = 0;
                        this.m_wanCol = 2;
                    }
                }
            }
            catch (Exception exception) {
                LEDebug.getLog().logln(20, exception);
            }
            this.m_portsPerRow = n > 48 ? 10 : 8;
            this.startMonitoring();
        }
    }

    public void select(int n, int n2, LEViewListener lEViewListener) {
        LEViewEvent lEViewEvent = null;
        if ((n -= this.m_x) < 100 && (n2 -= this.m_y) > 6) {
            lEViewEvent = new LEViewEvent(1, LEControlTree.SESSIONS);
        } else if (n2 > 6 && n2 < 43 && n > 106) {
            lEViewEvent = new LEViewEvent(1, LEControlTree.MODEMS);
        } else if (n2 > 51 && n2 < 76) {
            if (n > 119 && n < 193) {
                lEViewEvent = new LEViewEvent(1, LEControlTree.LINES);
            } else if (n > 203 && n < 267) {
                LEVector lEVector = new LEVector();
                lEVector.addElement(LEControlTree.ROOT);
                lEVector.addElement(LEControlTree.DIAGNOSE);
                lEVector.addElement(LEControlTree.DEBUG);
                lEViewEvent = new LEViewEvent(3, lEVector);
            } else if (n > 317) {
                lEViewEvent = new LEViewEvent(1, LEControlTree.IFACES);
            }
        }
        if (lEViewEvent != null) {
            lEViewListener.onLEViewEvent(lEViewEvent);
        }
    }

    public int getHeight(Graphics graphics) {
        if (this.m_height < 1) {
            this.determineSize(graphics);
            this.m_flags |= 4;
        }
        return this.m_height;
    }

    public int getWidth(Graphics graphics) {
        if (this.m_width < 1) {
            this.determineSize(graphics);
            this.m_flags |= 4;
        }
        return this.m_width;
    }

    public void draw(Graphics graphics, int n, int n2) {
        if (this.m_width == -1 || this.m_height == -1) {
            this.determineSize(graphics);
        }
        if (this.m_width == -1 || this.m_height == -1) {
            return;
        }
        graphics.setColor(LEColor.getBackground());
        graphics.fillRect(n, n2, this.m_width, this.m_height);
        Font font = LEFont.getBoldFont();
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        int n3 = n + (this.m_width - fontMetrics.stringWidth(this.m_host)) / 2;
        graphics.setColor(LEColor.getForeground());
        graphics.drawString(this.m_host, n3, n2 + fontMetrics.getAscent());
        this.m_nameHeight = fontMetrics.getHeight() + 2;
        this.m_x = n;
        this.m_y = n2 + this.m_nameHeight;
        graphics.drawImage(s_pm3, this.m_x, this.m_y, this);
        this.drawHeartbeat(graphics);
        if (this.m_hasWan) {
            this.drawWan(graphics, this.m_wanRow, this.m_wanCol);
        }
        this.drawLines(graphics);
        this.drawInterfaces(graphics);
        if (this.m_active && this.m_connected) {
            this.drawModems(graphics);
            this.drawSessions(graphics);
            return;
        }
        if (this.m_active) {
            graphics.setFont(LEFont.getFont());
            fontMetrics = graphics.getFontMetrics();
            int n4 = fontMetrics.stringWidth(NOT_CONNECTED) + 20;
            int n5 = fontMetrics.getHeight() + 20;
            n3 = this.m_x + (this.m_width - n4) / 2;
            int n6 = this.m_y + (this.m_height - this.m_nameHeight - n5) / 2;
            this.drawBox(graphics, n3, n6, n4, n5);
            graphics.drawString(NOT_CONNECTED, n3 + 10, n6 + 10 + fontMetrics.getAscent());
            return;
        }
        graphics.setFont(LEFont.getFont());
        fontMetrics = graphics.getFontMetrics();
        int n7 = fontMetrics.stringWidth(WRONG_COMOS) + 20;
        int n8 = fontMetrics.getHeight() + 20;
        n3 = this.m_x + (this.m_width - n7) / 2;
        int n9 = this.m_y + (this.m_height - this.m_nameHeight - n8) / 2;
        this.drawBox(graphics, n3, n9, n7, n8);
        graphics.drawString(WRONG_COMOS, n3 + 10, n9 + 10 + fontMetrics.getAscent());
    }

    public synchronized int heartbeat(Graphics graphics) {
        if (this.m_connected) {
            this.m_hb = LELEDs.GetLED(LELEDs.GRAY);
            this.drawHeartbeat(graphics);
            this.m_drawHeartbeat = true;
            return 1;
        }
        return 0;
    }

    public synchronized int blink(Graphics graphics, boolean bl) {
        this.m_blink = bl;
        if (this.m_drawHeartbeat) {
            this.m_hb = LELEDs.GetLED(LELEDs.GREEN);
            this.drawHeartbeat(graphics);
        }
        if (this.m_drawWan) {
            this.drawWan(graphics, this.m_wanRow, this.m_wanCol);
        }
        if (this.m_connected && (this.m_drawModems || this.blinkModems())) {
            this.drawModems(graphics);
        }
        if (this.m_connected && this.m_drawSessions) {
            this.drawSessions(graphics);
        }
        if (this.m_drawLines || this.m_drawWanLines) {
            this.drawLines(graphics);
        }
        if (this.m_drawInterfaces) {
            this.drawInterfaces(graphics);
        }
        int n = this.m_flags;
        this.m_flags = 0;
        return n;
    }

    public void shutdown() {
        LEStatusFactory.GetFactory().deleteObserver(this.m_host, this);
        LEMonitorFactory.GetFactory().deleteObserver(this.m_host, this);
        LEDeltaFactory.GetFactory().deleteObserver(this.m_host, this);
        this.stopMonitoring();
    }

    public synchronized boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if ((n & 0x20) != 0) {
            this.m_flags |= 2;
            return false;
        }
        return true;
    }

    public synchronized void update(LEAMFactory lEAMFactory, String string, Object object) {
        if (object instanceof LEDeltaModemsMessage) {
            this.updateModem((LEDeltaModemsMessage)object);
            return;
        }
        if (object instanceof LEMonModemsMessage) {
            this.updateModem((LEMonModemsMessage)object);
            return;
        }
        if (object instanceof LEMonSessionsMessage) {
            this.updateSession((LEMonSessionsMessage)object);
            return;
        }
        if (object instanceof LEMonLinesMessage) {
            this.updateLine((LEMonLinesMessage)object);
            return;
        }
        if (object instanceof LEMonIfacesMessage) {
            this.updateInterface((LEMonIfacesMessage)object);
            return;
        }
        if (object instanceof LEStatusMessage) {
            this.updateStatus((LEStatusMessage)object);
        }
    }

    void determineSize(Graphics graphics) {
        this.m_width = s_pm3.getWidth(this);
        this.m_height = s_pm3.getHeight(this);
        if (this.m_width == -1 || this.m_height == -1) {
            return;
        }
        Font font = LEFont.getBoldFont();
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        this.m_height += fontMetrics.getHeight() + 4;
    }

    void startMonitoring() {
        new Thread(this).start();
    }

    public void run() {
        LEMonitorFacility lEMonitorFacility = this.m_pm.getMonitorFacility();
        if (lEMonitorFacility == null) {
            return;
        }
        try {
            lEMonitorFacility.startMonitor(196608, -1);
            Thread.currentThread();
            Thread.sleep(1500L);
            lEMonitorFacility.startMonitor(65536, -1);
            Thread.currentThread();
            Thread.sleep(1500L);
            lEMonitorFacility.startMonitor(131072, -1);
            lEMonitorFacility.startDelta(196608, -1);
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return;
        }
    }

    void stopMonitoring() {
        LEMonitorFacility lEMonitorFacility = this.m_pm.getMonitorFacility();
        if (lEMonitorFacility == null) {
            return;
        }
        lEMonitorFacility.stopMonitor(196608, -1);
        lEMonitorFacility.stopMonitor(65536, -1);
        lEMonitorFacility.stopMonitor(131072, -1);
        lEMonitorFacility.stopDelta(196608, -1);
    }

    void updateModem(LEDeltaModemsMessage lEDeltaModemsMessage) {
        this.updateModem(lEDeltaModemsMessage.getName(), lEDeltaModemsMessage.getState(), lEDeltaModemsMessage.getTXCountChanged(), lEDeltaModemsMessage.getRXCountChanged());
    }

    void updateModem(LEMonModemsMessage lEMonModemsMessage) {
        this.updateModem(lEMonModemsMessage.getName(), lEMonModemsMessage.getState(), false, false);
    }

    void updateModem(String string, String string2, boolean bl, boolean bl2) {
        try {
            int n = Integer.parseInt(string.substring(1, string.length()));
            if (this.m_modems[n] == null) {
                this.m_modems[n] = new LEModem(string2);
            } else {
                this.m_modems[n].setState(string2, bl, bl2);
            }
            this.m_drawModems = true;
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return;
        }
    }

    void updateSession(LEMonSessionsMessage lEMonSessionsMessage) {
        String string = lEMonSessionsMessage.getPortName();
        String string2 = lEMonSessionsMessage.getStatus();
        try {
            if (string.charAt(0) != 'S') {
                return;
            }
            int n = Integer.parseInt(string.substring(1, string.length()));
            if (n > 29 && this.m_portsPerRow == 10) {
                n -= 2;
            }
            this.m_sessions[n] = string2.equalsIgnoreCase(ESTAB) ? LELEDs.GetLED(LELEDs.BLUE) : LELEDs.GetLED(LELEDs.GRAY);
            this.m_drawSessions = true;
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return;
        }
    }

    void updateLine(LEMonLinesMessage lEMonLinesMessage) {
        String string = lEMonLinesMessage.getName();
        String string2 = lEMonLinesMessage.getStatus();
        String string3 = lEMonLinesMessage.getRecvLevel();
        if (string == null || string2 == null || string3 == null) {
            return;
        }
        boolean bl = false;
        if (string2.equals(DOWN) || string2.equals("-") && (string3.equals(DOWN0) || string3.equals("-"))) {
            bl = true;
        }
        if (string.equals(LINE0)) {
            if (bl) {
                this.m_line0Top = LELEDs.GetLED(LELEDs.GRAY);
                this.m_line0Bottom = LELEDs.GetLED(LELEDs.RED);
            } else {
                this.m_line0Top = LELEDs.GetLED(LELEDs.GREEN);
                this.m_line0Bottom = LELEDs.GetLED(LELEDs.GRAY);
            }
        } else if (string.equals(LINE1)) {
            if (bl) {
                this.m_line1Top = LELEDs.GetLED(LELEDs.GRAY);
                this.m_line1Bottom = LELEDs.GetLED(LELEDs.RED);
            } else {
                this.m_line1Top = LELEDs.GetLED(LELEDs.GREEN);
                this.m_line1Bottom = LELEDs.GetLED(LELEDs.GRAY);
            }
        } else if (string.equals(LINE2)) {
            if (bl) {
                this.m_line2Top = LELEDs.GetLED(LELEDs.GRAY);
                this.m_line2Bottom = LELEDs.GetLED(LELEDs.RED);
            } else {
                this.m_line2Top = LELEDs.GetLED(LELEDs.GREEN);
                this.m_line2Bottom = LELEDs.GetLED(LELEDs.GRAY);
            }
            this.m_drawWanLines = true;
        }
        this.m_drawLines = true;
    }

    void updateInterface(LEMonIfacesMessage lEMonIfacesMessage) {
    }

    void updateStatus(LEStatusMessage lEStatusMessage) {
        switch (lEStatusMessage.getStatus()) {
            case 1: {
                this.m_active = this.m_pm.getDSS().supportsEntities();
                if (this.m_active) {
                    this.startMonitoring();
                }
                this.m_connected = true;
                this.m_hb = LELEDs.GetLED(LELEDs.GREEN);
                this.m_line0Top = LELEDs.GetLED(LELEDs.GRAY);
                this.m_line0Bottom = LELEDs.GetLED(LELEDs.RED);
                this.m_line1Top = LELEDs.GetLED(LELEDs.GRAY);
                this.m_line1Bottom = LELEDs.GetLED(LELEDs.RED);
                this.m_line2Top = LELEDs.GetLED(LELEDs.GRAY);
                this.m_line2Bottom = LELEDs.GetLED(LELEDs.RED);
                this.m_etherTop = LELEDs.GetLED(LELEDs.GREEN);
                this.m_etherBottom = LELEDs.GetLED(LELEDs.GRAY);
                this.m_flags |= 2;
                return;
            }
            case 2: 
            case 4: {
                this.m_connected = false;
                this.m_hb = LELEDs.GetLED(LELEDs.GRAY);
                this.m_line0Top = LELEDs.GetLED(LELEDs.GRAY);
                this.m_line0Bottom = LELEDs.GetLED(LELEDs.GRAY);
                this.m_line1Top = LELEDs.GetLED(LELEDs.GRAY);
                this.m_line1Bottom = LELEDs.GetLED(LELEDs.GRAY);
                this.m_line2Top = LELEDs.GetLED(LELEDs.GRAY);
                this.m_line2Bottom = LELEDs.GetLED(LELEDs.GRAY);
                this.m_etherTop = LELEDs.GetLED(LELEDs.GRAY);
                this.m_etherBottom = LELEDs.GetLED(LELEDs.GRAY);
                this.m_flags |= 2;
                return;
            }
        }
    }

    void drawHeartbeat(Graphics graphics) {
        graphics.drawImage(this.m_hb, this.m_x + 277, this.m_y + 59, null);
        this.m_drawHeartbeat = false;
        this.m_flags |= 1;
    }

    void drawModems(Graphics graphics) {
        int n = 0;
        while (n < this.m_modems.length) {
            this.drawModem(graphics, n);
            ++n;
        }
        this.m_flags |= 1;
        this.m_drawModems = false;
    }

    void drawModem(Graphics graphics, int n) {
        if (this.m_modems[n] == null) {
            return;
        }
        int n2 = n / 10;
        int n3 = n2 / 3;
        int n4 = n2 % 3;
        if (this.m_hasWan && n3 == this.m_wanRow && n4 == this.m_wanCol) {
            return;
        }
        int n5 = this.m_x + 125;
        int n6 = this.m_y + 10;
        if (n3 == 1 && n4 == 0) {
            n6 += 17;
        } else if (n3 == 1) {
            n6 += 18;
        }
        if (n4 == 1) {
            n5 += 117;
        } else if (n4 == 2) {
            n5 += 233;
        }
        int n7 = n % 10;
        n5 += n7 * (LELEDs.LED_WIDTH - 1);
        if (n7 % 2 > 0) {
            n6 += 5;
        }
        int n8 = LELEDs.BLACK;
        switch (this.m_modems[n].getState()) {
            case 0: {
                n8 = LELEDs.BLACK;
                break;
            }
            case 1: {
                n8 = LELEDs.RED;
                if (n7 != 8 && n7 != 9) break;
                int n9 = n2 * 10;
                int n10 = n9 + 8;
                boolean bl = true;
                int n11 = n9;
                while (n11 < n10) {
                    if (this.m_modems[n11] != null && this.m_modems[n11].getState() < 2) {
                        bl = false;
                    }
                    ++n11;
                }
                if (!bl) break;
                n8 = LELEDs.BLACK;
                break;
            }
            case 2: {
                n8 = LELEDs.GRAY;
                break;
            }
            case 3: {
                if (this.m_blink) {
                    n8 = LELEDs.YELLOW;
                    break;
                }
                n8 = LELEDs.GRAY;
                break;
            }
            case 4: {
                n8 = LELEDs.GREEN;
                break;
            }
            case 5: {
                if (this.m_blink) {
                    n8 = LELEDs.GREEN;
                    break;
                }
                n8 = LELEDs.GRAY;
                break;
            }
            case 6: {
                if (this.m_blink) {
                    n8 = LELEDs.BLUE;
                    break;
                }
                n8 = LELEDs.GREEN;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n8 = LELEDs.BLUE;
                break;
            }
        }
        graphics.drawImage(LELEDs.GetLED(n8), n5, n6, null);
    }

    boolean blinkModems() {
        boolean bl = false;
        int n = 0;
        while (!bl && n < 60) {
            int n2;
            if (this.m_modems[n] != null && ((n2 = this.m_modems[n].getState()) == 5 || n2 == 6 || n2 == 3)) {
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    void drawSessions(Graphics graphics) {
        this.drawBox(graphics, this.m_x + 4, this.m_y + 6, 100, this.m_height - this.m_nameHeight - 12);
        graphics.setFont(LEFont.getFont());
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.stringWidth(SESSIONS);
        int n2 = this.m_x + 4;
        int n3 = this.m_y + 9 + fontMetrics.getAscent();
        graphics.drawString(SESSIONS, n2 + (100 - n) / 2, n3);
        this.m_sessX = n2 + 3 + 8 * ((12 - this.m_portsPerRow) / 2);
        this.m_sessY = n3 += fontMetrics.getDescent() + fontMetrics.getLeading();
        int n4 = 0;
        while (n4 < this.m_sessions.length) {
            this.drawSession(graphics, n4);
            ++n4;
        }
        this.m_flags |= 1;
        this.m_drawSessions = false;
    }

    void drawSession(Graphics graphics, int n) {
        if (this.m_sessions[n] == null) {
            return;
        }
        int n2 = n / this.m_portsPerRow;
        int n3 = n % this.m_portsPerRow;
        int n4 = this.m_sessX + 8 * n3;
        int n5 = this.m_sessY + 8 * n2;
        graphics.drawImage(this.m_sessions[n], n4, n5, null);
    }

    void drawLines(Graphics graphics) {
        graphics.drawImage(this.m_line0Top, this.m_x + 144, this.m_y + 54, null);
        graphics.drawImage(this.m_line0Bottom, this.m_x + 144, this.m_y + 62, null);
        graphics.drawImage(this.m_line1Top, this.m_x + 182, this.m_y + 54, null);
        graphics.drawImage(this.m_line1Bottom, this.m_x + 182, this.m_y + 62, null);
        if (this.m_hasWan) {
            graphics.drawImage(this.m_line2Top, this.m_wanX + 56, this.m_wanY + 5, null);
            graphics.drawImage(this.m_line2Bottom, this.m_wanX + 64, this.m_wanY + 5, null);
            this.m_drawWanLines = false;
        }
        this.m_flags |= 1;
        this.m_drawLines = false;
    }

    void drawInterfaces(Graphics graphics) {
        graphics.drawImage(this.m_etherTop, this.m_x + 318, this.m_y + 54, null);
        graphics.drawImage(this.m_etherBottom, this.m_x + 318, this.m_y + 62, null);
        this.m_flags |= 1;
        this.m_drawInterfaces = false;
    }

    void drawWan(Graphics graphics, int n, int n2) {
        this.m_wanX = this.m_x + 109;
        this.m_wanY = this.m_y + 7;
        if (n == 1 && n2 == 0) {
            this.m_wanY += 17;
        } else if (n == 1) {
            this.m_wanY += 18;
        }
        if (n2 == 1) {
            this.m_wanX += 117;
        } else if (n2 == 2) {
            this.m_wanX += 233;
        }
        if (s_wancard != null) {
            graphics.drawImage(s_wancard, this.m_wanX, this.m_wanY, null);
            this.m_flags |= 1;
        }
        this.m_drawWan = false;
    }

    void drawBox(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setColor(Color.white);
        graphics.fillRect(n, n2, n3, n4);
        graphics.setColor(Color.black);
        graphics.drawRect(n, n2, n3, n4);
        graphics.drawRect(n + 1, n2 + 1, n3 - 2, n4 - 2);
    }
}

