/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.topicWindow;

import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.util.Locale;
import java.util.ResourceBundle;
import oracle.help.topicWindow.SyncGoMenu;
import oracle.help.topicWindow.TopicWindow;
import oracle.help.util.MenuDefs;

public class TopicWindowMenuBar
extends MenuBar
implements SyncGoMenu {
    protected Menu _file;
    protected Menu _edit;
    protected Menu _go;
    protected Menu _tools;
    protected MenuItem _print;
    protected MenuItem _close;
    protected MenuItem _exit;
    protected MenuItem _copy;
    protected MenuItem _back;
    protected MenuItem _forward;
    protected MenuItem _navigator;
    protected MenuItem _search;
    protected MenuItem _dock;
    protected MenuItem _preferences;
    protected TopicWindow _window;
    static String[] FILE_LABELS = new String[]{"File", "PrintTopic", "-", "Close", "Exit"};
    static final int FILE_INDEX = 0;
    static final int FILE_PRINT_INDEX = 0;
    static final int FILE_CLOSE_INDEX = 2;
    static final int FILE_EXIT_INDEX = 3;
    static String[] EDIT_LABELS = new String[]{"Edit", "Copy"};
    static final int EDIT_INDEX = 1;
    static final int EDIT_COPY_INDEX = 0;
    static String[] GO_LABELS = new String[]{"Go", "Back", "Forward"};
    static final int GO_INDEX = 2;
    static final int GO_BACK_INDEX = 0;
    static final int GO_FORWARD_INDEX = 1;
    static String[] TOOLS_LABELS = new String[]{"Tools", "Navigator", "Search", "-", "Dock", "-", "Preferences"};
    static final int TOOLS_INDEX = 3;
    static final int TOOLS_NAVIGATOR_INDEX = 0;
    static final int TOOLS_SEARCH_INDEX = 1;
    static final int TOOLS_DOCK_INDEX = 3;
    static final int TOOLS_DOCK_PREFERENCES = 5;

    public TopicWindowMenuBar(TopicWindow topicWindow) {
        this(topicWindow, false);
    }

    public TopicWindowMenuBar(TopicWindow topicWindow, boolean bl) {
        this._window = topicWindow;
        this.populateMenuBar(bl);
    }

    public void populateMenuBar(boolean bl) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("oracle.help.resource.MenuLabels", Locale.getDefault());
        TopicWindow topicWindow = this._window;
        String[] stringArray = FILE_LABELS;
        this._file = MenuDefs.createMenu(topicWindow, null, stringArray, resourceBundle, false);
        topicWindow = this._window;
        stringArray = GO_LABELS;
        this._go = MenuDefs.createMenu(topicWindow, null, stringArray, resourceBundle, false);
        topicWindow = this._window;
        stringArray = TOOLS_LABELS;
        this._tools = MenuDefs.createMenu(topicWindow, null, stringArray, resourceBundle, false);
        this.add(this._file);
        this.add(this._go);
        this.add(this._tools);
        this._print = this._file.getItem(0);
        this._close = this._file.getItem(2);
        this._exit = this._file.getItem(3);
        this._back = this._go.getItem(0);
        this._forward = this._go.getItem(1);
        this._navigator = this._tools.getItem(0);
        this._search = this._tools.getItem(1);
        this._dock = this._tools.getItem(3);
        this._preferences = this._tools.getItem(5);
    }

    public void setEnableAll(boolean bl) {
        MenuDefs.setEnableAll(this, bl);
        this._print.setEnabled(true);
        this._close.setEnabled(true);
        this._exit.setEnabled(true);
        this._preferences.setEnabled(true);
    }

    public MenuItem getMenuItem(String string) {
        return MenuDefs.getMenuItem(this, string);
    }

    public void setNavigatorEnabled(boolean bl) {
        this._navigator.setEnabled(bl);
    }

    public void setSearchEnabled(boolean bl) {
        this._search.setEnabled(bl);
    }

    public void setDockEnabled(boolean bl) {
        this._dock.setEnabled(bl);
    }

    public void setBackEnabled(boolean bl) {
        this._back.setEnabled(bl);
    }

    public void setForwardEnabled(boolean bl) {
        this._forward.setEnabled(bl);
    }
}

