/*
 * Decompiled with CFR 0.152.
 */
import com.lucent.ra.nms.amf.LEAMFactory;
import com.lucent.ra.nms.amf.LEAMObserver;
import com.lucent.ra.nms.backend.LEStatusFactory;
import com.lucent.ra.nms.backend.LEStatusMessage;
import com.lucent.ra.nms.forms.LERebootDialog;
import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.model.LEPMConnectionFacade;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.ui.LEMLEvent;
import com.lucent.ra.nms.ui.LEMultiList;
import com.lucent.ra.nms.ui.LEUiUtils;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEResourceID;
import com.lucent.ra.nms.util.LEStatusManager;
import com.lucent.ra.nms.util.LEUpTimeCompare;
import java.util.Enumeration;
import java.util.Hashtable;

public class LEPMGrid
extends LEMultiList
implements LEAMObserver,
Runnable {
    public static final String REBOOTING = "Rebooting...";
    public static final String NOT_CONNECTED = "Connection Lost";
    public static final String UPGRADING = "Upgrading";
    static final int COLUMNS = 4;
    Hashtable m_pms = new Hashtable();
    Thread m_thread;

    public LEPMGrid() {
        super(1, 0, 4);
        Object[] objectArray = new String[]{new String("Device"), new String("Model"), new String("ComOS"), new String("Up Time")};
        this.setTitles(0, objectArray);
        this.setSortable(0, true);
        this.setSortable(1, true);
        this.setSortable(2, true);
        this.setSortable(3, true);
        this.setSortObject(3, new LEUpTimeCompare());
        this.setCellJustification(3, 2);
        this.m_thread = new Thread(this);
        this.m_thread.setName("LEPMGrid Updater");
        this.m_thread.start();
    }

    public boolean connectedTo(String string, String string2) {
        String string3 = LEResourceID.CreatePM_ID(string, string2);
        return this.m_pms.containsKey(string3);
    }

    public LEPortMaster getPortMaster(String string) {
        return (LEPortMaster)this.m_pms.get(string);
    }

    public void addPortMaster(LEPortMaster lEPortMaster) {
        String string = lEPortMaster.getResourceID();
        LEStatusFactory.GetFactory().addObserver(string, this);
        this.m_pms.put(string, lEPortMaster);
        Object[] objectArray = new String[]{lEPortMaster.getDescription(), lEPortMaster.getHardwareType(), lEPortMaster.getSoftwareVersion(), lEPortMaster.getUpTime()};
        this.addRow(objectArray);
        this.setRowObject(this.getNumRows() - 1, string);
        if (this.m_pms.size() == 1) {
            int[] nArray = new int[]{0};
            this.selectRows(nArray);
        }
        this.repaint();
    }

    public void deletePortMaster(LEPortMaster lEPortMaster) {
        if (lEPortMaster == null) {
            return;
        }
        lEPortMaster.disconnect();
    }

    public void removeSelectedPMs() {
        LEPortMaster[] lEPortMasterArray = this.getSelectedPMs();
        int n = 0;
        while (n < lEPortMasterArray.length) {
            this.removePM(lEPortMasterArray[n]);
            ++n;
        }
    }

    public void removePM(LEPortMaster lEPortMaster) {
        String string = lEPortMaster.getResourceID();
        LEStatusFactory.GetFactory().deleteObserver(string, this);
        int n = this.getPortMasterRow(string);
        this.m_pms.remove(string);
        LECommandView.removePM(string);
        LEDebugView.RemovePM(string);
        this.deletePortMaster(lEPortMaster);
        this.deleteRow(n);
    }

    public void deleteSelectedPMs() {
        LEPortMaster[] lEPortMasterArray = this.getSelectedPMs();
        int n = 0;
        while (n < lEPortMasterArray.length) {
            this.deletePortMaster(lEPortMasterArray[n]);
            ++n;
        }
    }

    public void reconnectSelectedPMs() {
        LEPortMaster[] lEPortMasterArray = this.getSelectedPMs();
        int n = 0;
        while (n < lEPortMasterArray.length) {
            if (!lEPortMasterArray[n].isConnected()) {
                new LEReconnectThread(lEPortMasterArray[n]);
            }
            ++n;
        }
    }

    public void rebootSelectedPMs() {
        LEPortMaster[] lEPortMasterArray = this.getSelectedPMs();
        String[] stringArray = new String[1];
        int n = 0;
        while (n < lEPortMasterArray.length) {
            stringArray[0] = "Reboot " + lEPortMasterArray[n].getDescription() + "?";
            LERebootDialog lERebootDialog = new LERebootDialog(LEUiUtils.getFrame(this), stringArray);
            if (lERebootDialog.shouldReboot()) {
                new LERebootThread(lEPortMasterArray[n]);
            }
            ++n;
        }
    }

    public LEPortMaster[] getSelected(String string) {
        int[] nArray = this.getSelectedRows();
        LEPortMaster[] lEPortMasterArray = new LEPortMaster[nArray.length];
        int n = 0;
        int n2 = 0;
        while (n2 < nArray.length) {
            String string2 = (String)this.getRowObject(nArray[n2]);
            LEPortMaster lEPortMaster = (LEPortMaster)this.m_pms.get(string2);
            if (string.equals(lEPortMaster.getPlatformKey())) {
                lEPortMasterArray[n++] = lEPortMaster;
            }
            ++n2;
        }
        LEPortMaster[] lEPortMasterArray2 = new LEPortMaster[n];
        if (n > 0) {
            System.arraycopy(lEPortMasterArray, 0, lEPortMasterArray2, 0, n);
        }
        return lEPortMasterArray2;
    }

    public LEPortMaster[] getSelectedPMs() {
        int[] nArray = this.getSelectedRows();
        LEPortMaster[] lEPortMasterArray = new LEPortMaster[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            String string = (String)this.getRowObject(nArray[n]);
            lEPortMasterArray[n] = (LEPortMaster)this.m_pms.get(string);
            ++n;
        }
        return lEPortMasterArray;
    }

    public void updateUpTimes() {
        int n = this.getNumRows();
        int n2 = 0;
        while (n2 < n) {
            LEConnectionFacade lEConnectionFacade;
            LEPortMaster lEPortMaster;
            String string = (String)this.getRowObject(n2);
            if (string != null && (lEPortMaster = (LEPortMaster)this.m_pms.get(string)) != null && lEPortMaster.isConnected() && lEPortMaster.ping() && (!((lEConnectionFacade = lEPortMaster.getFacade()) instanceof LEPMConnectionFacade) || !((LEPMConnectionFacade)lEConnectionFacade).isUpgrading())) {
                this.setCellItem(n2, 2, lEPortMaster.getSoftwareVersion());
                this.setCellItem(n2, 3, lEPortMaster.getUpTime());
            }
            ++n2;
        }
    }

    public void update(LEAMFactory lEAMFactory, String string, Object object) {
        if (object instanceof LEStatusMessage) {
            LEStatusMessage lEStatusMessage = (LEStatusMessage)object;
            LEPortMaster lEPortMaster = (LEPortMaster)this.m_pms.get(string);
            if (lEPortMaster == null) {
                return;
            }
            String string2 = null;
            String string3 = null;
            switch (lEStatusMessage.getStatus()) {
                case 1: 
                case 6: {
                    lEPortMaster.ping();
                    string2 = lEPortMaster.getUpTime();
                    string3 = lEPortMaster.getSoftwareVersion();
                    break;
                }
                case 2: {
                    string2 = NOT_CONNECTED;
                    break;
                }
                case 4: {
                    string2 = REBOOTING;
                    break;
                }
                case 5: {
                    string2 = UPGRADING;
                    break;
                }
            }
            if (string2 != null || string3 != null) {
                int n = this.getPortMasterRow(string);
                if (n > -1) {
                    if (string3 != null) {
                        this.setCellItem(n, 2, string3);
                    }
                    if (string2 != null) {
                        this.setCellItem(n, 3, string2);
                    }
                }
                this.notifyListeners(new LEMLEvent(this, 3));
            }
        }
    }

    public void shutdown() {
        if (this.m_thread != null) {
            this.m_thread.stop();
            this.m_thread = null;
        }
        Enumeration enumeration = this.m_pms.elements();
        while (enumeration.hasMoreElements()) {
            LEPortMaster lEPortMaster = (LEPortMaster)enumeration.nextElement();
            if (!lEPortMaster.isConnected()) continue;
            LEStatusManager.SetStatus("Closing connection to " + lEPortMaster.getDescription());
            try {
                lEPortMaster.disconnect();
            }
            catch (Exception exception) {
                LEDebug.getLog().logln(20, exception);
            }
        }
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    Thread.currentThread();
                    Thread.sleep(90000L);
                    this.updateUpTimes();
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    int getPortMasterRow(String string) {
        int n = -1;
        int n2 = this.getNumRows();
        int n3 = 0;
        while (n == -1 && n3 < n2) {
            if (string.equals((String)this.getRowObject(n3))) {
                n = n3;
            }
            ++n3;
        }
        return n;
    }
}

