/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.backend;

import com.lucent.ra.nms.amf.LEAMFactory;
import com.lucent.ra.nms.amf.LEAMObserver;
import com.lucent.ra.nms.amf.LEAMRouter_RI;
import com.lucent.ra.nms.backend.LEAlarmFacility_R;
import com.lucent.ra.nms.backend.LEAlarmFactory;
import com.lucent.ra.nms.backend.LEAlarmMessage;
import com.lucent.ra.nms.backend.LEDSSException;
import com.lucent.ra.nms.backend.LEDSSPortMaster_I;
import com.lucent.ra.nms.backend.LEStatusFactory;
import com.lucent.ra.nms.backend.LEStatusMessage;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEVector;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;

public class LEAlarmFacility_RI
extends UnicastRemoteObject
implements LEAlarmFacility_R,
LEAMObserver {
    LEDSSPortMaster_I m_dss;
    LEVector m_alarms = new LEVector();
    long m_req;

    public LEAlarmFacility_RI(LEDSSPortMaster_I lEDSSPortMaster_I) throws RemoteException {
        this.m_dss = lEDSSPortMaster_I;
        String string = this.m_dss.getResourceID();
        if (this.m_dss.isConnected()) {
            this.startAlarms();
        }
        LEStatusFactory.GetFactory().addObserver(string, this);
    }

    public LEVector getAlarms() throws RemoteException {
        return this.m_alarms;
    }

    public boolean clearAlarm(String string) throws RemoteException {
        if (this.m_req == 0L || !this.m_dss.isConnected()) {
            return false;
        }
        boolean bl = true;
        try {
            this.m_dss.clearAlarm(Long.parseLong(string));
            int n = this.m_alarms.size();
            int n2 = n - 1;
            while (n2 > -1) {
                LEAlarmMessage lEAlarmMessage = (LEAlarmMessage)this.m_alarms.elementAt(n2);
                if (lEAlarmMessage.getName().equals(string)) {
                    this.alarmCleared(lEAlarmMessage);
                }
                --n2;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public synchronized void update(LEAMFactory lEAMFactory, String string, Object object) {
        if (object instanceof LEAlarmMessage) {
            this.updateAlarm((LEAlarmMessage)object);
            return;
        }
        if (object instanceof LEStatusMessage) {
            this.updateStatus((LEStatusMessage)object);
        }
    }

    void shutdown() {
        if (this.m_dss.isConnected()) {
            this.stopAlarms();
        }
    }

    void updateAlarm(LEAlarmMessage lEAlarmMessage) {
        String string = lEAlarmMessage.getName();
        int n = this.m_alarms.size();
        boolean bl = false;
        int n2 = 0;
        while (!bl && n2 < n) {
            LEAlarmMessage lEAlarmMessage2 = (LEAlarmMessage)this.m_alarms.elementAt(n2);
            if (string.equals(lEAlarmMessage2.getName())) {
                bl = true;
                this.m_alarms.setElementAt(lEAlarmMessage, n2);
            }
            ++n2;
        }
        if (!bl) {
            this.m_alarms.addElement(lEAlarmMessage);
        }
    }

    void updateStatus(LEStatusMessage lEStatusMessage) {
        switch (lEStatusMessage.getStatus()) {
            case 1: {
                if (this.m_req != 0L) break;
                this.startAlarms();
                return;
            }
            case 2: 
            case 4: {
                this.m_alarms.removeAllElements();
                this.m_req = 0L;
                return;
            }
        }
    }

    void alarmCleared(LEAlarmMessage lEAlarmMessage) {
        lEAlarmMessage.clear();
        LEAMRouter_RI.GetAMRouter().distribute(lEAlarmMessage.getResourceID(), "ALARM", lEAlarmMessage);
    }

    void startAlarms() {
        LEAlarmFactory.GetFactory().addObserver(this.m_dss.getResourceID(), this);
        try {
            this.m_req = this.m_dss.alarm(655360);
            return;
        }
        catch (LEDSSException lEDSSException) {
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return;
        }
    }

    void stopAlarms() {
        LEAlarmFactory.GetFactory().deleteObserver(this.m_dss.getResourceID(), this);
        this.m_alarms.removeAllElements();
        try {
            if (this.m_req > 0L) {
                this.m_dss.killAlarm(this.m_req);
                return;
            }
        }
        catch (LEDSSException lEDSSException) {
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
    }
}

