/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.forms;

import com.lucent.ra.nms.forms.LEAddDialog;
import com.lucent.ra.nms.forms.LECmdErrorDialog;
import com.lucent.ra.nms.forms.LEFormLine;
import com.lucent.ra.nms.forms.LEFormLineFactory;
import com.lucent.ra.nms.forms.LENewEntry;
import com.lucent.ra.nms.forms.LETableForm;
import com.lucent.ra.nms.model.LEDataSpec;
import com.lucent.ra.nms.model.LELocalIPAddress;
import com.lucent.ra.nms.model.LELocalIPAddresses;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.model.LETable;
import com.lucent.ra.nms.ui.LECompGrid;
import com.lucent.ra.nms.ui.LEErrorDialog;
import com.lucent.ra.nms.ui.LEFont;
import com.lucent.ra.nms.ui.LEUiUtils;
import com.lucent.ra.nms.util.LEVector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Label;
import java.awt.Panel;

public class LELocalIPAddressesForm
extends LETableForm {
    static final String PORTMASTER = "Device";
    static final String BLANK = "";
    String m_num;
    String m_address;

    public LELocalIPAddressesForm() {
        this.m_keyReadonly = false;
    }

    boolean addNewEntry(LEDataSpec lEDataSpec, LEDataSpec lEDataSpec2) {
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        Component[][] componentArray = new Component[2][2];
        componentArray[0][0] = new Label(String.valueOf(lEDataSpec.getDescription()) + ":");
        componentArray[0][0].setFont(LEFont.getBoldFont());
        componentArray[0][1] = LEFormLineFactory.BuildFormLine(null, null, null, lEDataSpec);
        LEDataSpec lEDataSpec3 = lEDataSpec2.getSpecFor("9");
        componentArray[1][0] = new Label(String.valueOf(lEDataSpec3.getDescription()) + ":");
        componentArray[1][0].setFont(LEFont.getBoldFont());
        componentArray[1][1] = LEFormLineFactory.BuildFormLine(null, null, null, lEDataSpec3);
        panel.add("Center", new LECompGrid(componentArray, 2, false));
        LEAddDialog lEAddDialog = new LEAddDialog(LEUiUtils.GetBaseFrame(), "Add Local IP address", panel);
        if (lEAddDialog.okay()) {
            this.m_num = ((LEFormLine)((Object)componentArray[0][1])).getValue();
            this.m_address = ((LEFormLine)((Object)componentArray[1][1])).getValue();
            if (this.m_address.length() > 0) {
                return true;
            }
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), "An IP address must be entered");
        }
        return false;
    }

    LENewEntry addNewEntryTo(LEPortMaster lEPortMaster) {
        LENewEntry lENewEntry = null;
        LETable lETable = this.getTable(lEPortMaster);
        if (lETable.get(this.m_num) == null) {
            LEVector lEVector = ((LELocalIPAddresses)lETable).add(this.m_num, this.m_address);
            if (lEVector != null) {
                new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), lEPortMaster.getConnectionFacade(), lEVector);
            } else {
                this.addEntry(lEPortMaster.getDescription(), lETable, this.m_num);
                lENewEntry = new LENewEntry(lEPortMaster, lETable, this.m_num);
            }
        } else {
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), String.valueOf(lEPortMaster.getDescription()) + " already contains a local IP address numbered " + this.m_num);
        }
        return lENewEntry;
    }

    void delete(LEPortMaster lEPortMaster, LETable lETable, String string) {
        if (!(lETable instanceof LELocalIPAddresses)) {
            return;
        }
        LELocalIPAddresses lELocalIPAddresses = (LELocalIPAddresses)lETable;
        LEVector lEVector = lELocalIPAddresses.delete(string);
        if (lEVector != null) {
            new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), lEPortMaster.getConnectionFacade(), lEVector);
        }
    }

    String getPasteKey(LEPortMaster lEPortMaster, Object object) {
        LEVector lEVector;
        if (!(object instanceof LELocalIPAddress)) {
            return null;
        }
        LELocalIPAddress lELocalIPAddress = (LELocalIPAddress)object;
        LELocalIPAddresses lELocalIPAddresses = (LELocalIPAddresses)this.getTable(lEPortMaster);
        String string = lELocalIPAddress.getNumber();
        String string2 = (String)lELocalIPAddress.get("9");
        if (lELocalIPAddresses.get(string) != null) {
            string = LETableForm.GetUniqueKey(lELocalIPAddresses, string, 16);
        }
        if ((lEVector = lELocalIPAddresses.add(string, string2)) != null) {
            new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), lEPortMaster.getConnectionFacade(), lEVector);
            string = null;
        }
        return string;
    }
}

