/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.forms;

import com.lucent.ra.nms.forms.LEAddDialog;
import com.lucent.ra.nms.forms.LECmdErrorDialog;
import com.lucent.ra.nms.forms.LEFormLine;
import com.lucent.ra.nms.forms.LEFormLineFactory;
import com.lucent.ra.nms.forms.LENewEntry;
import com.lucent.ra.nms.forms.LETableForm;
import com.lucent.ra.nms.model.LEDataSpec;
import com.lucent.ra.nms.model.LENATMap;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.model.LETable;
import com.lucent.ra.nms.ui.LEErrorDialog;
import com.lucent.ra.nms.ui.LEFont;
import com.lucent.ra.nms.ui.LEUiUtils;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEVector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Label;
import java.awt.Panel;

public class LENATMapForm
extends LETableForm {
    private static final int MAX_RULES = 20;
    String m_addType;
    int m_numRules;

    void addEntry(String string, LETable lETable, String string2) {
        if (lETable instanceof LENATMap) {
            this.m_numRules = lETable.size();
        }
        super.addEntry(string, lETable, string2);
    }

    boolean addNewEntry(LEDataSpec lEDataSpec, LEDataSpec lEDataSpec2) {
        if (this.m_numRules < 20) {
            Panel panel = new Panel();
            panel.setLayout(new BorderLayout());
            LEDataSpec lEDataSpec3 = lEDataSpec2.getSpecFor("type");
            Label label = new Label(String.valueOf(lEDataSpec3.getDescription()) + ": ");
            label.setFont(LEFont.getBoldFont());
            panel.add("West", label);
            Component component = LEFormLineFactory.BuildFormLine(null, null, null, lEDataSpec3);
            panel.add("East", component);
            LEAddDialog lEAddDialog = new LEAddDialog(LEUiUtils.GetBaseFrame(), "Add NAT Map Rule", panel);
            if (lEAddDialog.okay()) {
                this.m_addType = ((LEFormLine)((Object)component)).getValue();
                return true;
            }
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("You cannot have more than ");
            stringBuffer.append(20);
            stringBuffer.append(" rules in a NAT Map.");
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), stringBuffer.toString());
        }
        return false;
    }

    LENewEntry addNewEntryTo(LEPortMaster lEPortMaster) {
        LENewEntry lENewEntry = null;
        LENATMap lENATMap = (LENATMap)this.getTable(lEPortMaster);
        LEVector lEVector = null;
        if (this.m_addType.equals("addrmap") || this.m_addType.equals("staticaddrmap")) {
            lEVector = lENATMap.add(this.m_addType, "1.2.3.4", "1.2.3.4", false);
        } else if (this.m_addType.equals("statictuportmap")) {
            lEVector = lENATMap.add(this.m_addType, "1.2.3.4:1", "1.2.3.4:1", false);
        }
        if (lEVector != null) {
            new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), lEPortMaster.getConnectionFacade(), lEVector);
            this.refresh();
        } else {
            String string = Integer.toString(lENATMap.size());
            this.addEntry(lEPortMaster.getDescription(), lENATMap, string);
            lENewEntry = new LENewEntry(lEPortMaster, lENATMap, string);
        }
        return lENewEntry;
    }

    void delete(LEPortMaster lEPortMaster, LETable lETable, String string) {
        if (!(lETable instanceof LENATMap)) {
            return;
        }
        LENATMap lENATMap = (LENATMap)lETable;
        try {
            int n = Integer.parseInt(string);
            LEVector lEVector = lENATMap.delete(n);
            if (lEVector != null) {
                new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), lEPortMaster.getConnectionFacade(), lEVector);
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            LEDebug.getLog().logln(20, numberFormatException);
        }
    }
}

