/*
 * Decompiled with CFR 0.152.
 */
import com.lucent.ra.nms.amf.LEAMFactory;
import com.lucent.ra.nms.backend.LEMonModemsMessage;
import com.lucent.ra.nms.backend.LEMonSessionsMessage;
import com.lucent.ra.nms.backend.LEMonUsersMessage;
import com.lucent.ra.nms.backend.LEMonitorFactory;
import com.lucent.ra.nms.backend.LEStatusFactory;
import com.lucent.ra.nms.backend.LEStatusMessage;
import com.lucent.ra.nms.forms.LECmdErrorDialog;
import com.lucent.ra.nms.model.LEBoard;
import com.lucent.ra.nms.model.LEBoards;
import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.model.LEPMConnectionFacade;
import com.lucent.ra.nms.model.LEPort;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.model.LEPorts;
import com.lucent.ra.nms.ui.LEMLEvent;
import com.lucent.ra.nms.ui.LEUiUtils;
import com.lucent.ra.nms.util.LEVector;
import java.awt.Button;
import java.awt.Component;
import java.awt.event.ActionEvent;

public class LEMonUsersNewView
extends LEMonitorDetailPanel {
    Button m_resetPorts;
    boolean m_new;

    public LEMonUsersNewView() {
        this.initialize(1, 3, 9);
        this.setCellJustification(1, 2);
        int n = this.getNumColumns();
        int n2 = 5;
        while (n2 < n) {
            this.setCellJustification(n2, 2);
            ++n2;
        }
        this.m_resetCols = new int[2];
        this.m_resetCols[0] = 7;
        this.m_resetCols[1] = 8;
        this.m_resetPorts = new Button("Reset Port");
        this.m_buttons.add((Component)this.m_resetPorts, 0);
        this.m_resetPorts.addActionListener(this);
        this.m_resetPorts.setEnabled(false);
    }

    public synchronized void onLEMLEvent(LEMLEvent lEMLEvent) {
        super.onLEMLEvent(lEMLEvent);
        if (lEMLEvent.getType() == 3) {
            if (this.getSelectSize() > 0) {
                this.m_resetPorts.setEnabled(true);
                return;
            }
            this.m_resetPorts.setEnabled(false);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.m_resetPorts) {
            LEConfig lEConfig;
            Object object;
            if (this.getSelectSize() == 0) {
                return;
            }
            LEPorts lEPorts = null;
            if (this.m_selected_brd != null) {
                object = (LEBoards)this.m_selected_pm.get("2555904");
                if (object == null) {
                    return;
                }
                lEConfig = (LEBoard)((LEConfig)object).get(this.m_selected_brd);
                if (lEConfig == null) {
                    return;
                }
                lEPorts = (LEPorts)lEConfig.get(LEBoard.PORTS);
            } else {
                lEPorts = (LEPorts)this.m_selected_pm.get("262144");
            }
            if (lEPorts == null) {
                return;
            }
            int[] nArray = this.getSelectedRows();
            int n = 0;
            while (n < nArray.length) {
                object = (String)this.getCellItem(nArray[n], 2);
                lEConfig = null;
                LEVector lEVector = null;
                if (object != null) {
                    lEConfig = lEPorts.getPort((String)object);
                }
                if (lEConfig != null) {
                    lEVector = ((LEPort)lEConfig).reset();
                }
                if (lEVector != null) {
                    new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), this.m_selected_pm.getConnectionFacade(), lEVector);
                }
                ++n;
            }
            return;
        }
        super.actionPerformed(actionEvent);
    }

    public synchronized void update(LEAMFactory lEAMFactory, String string, Object object) {
        if (this.m_pms == null || !this.validMessage(string, object)) {
            return;
        }
        if (object instanceof LEMonUsersMessage) {
            this.updateUser(string, (LEMonUsersMessage)object);
            return;
        }
        if (object instanceof LEMonSessionsMessage) {
            this.updateSession(string, (LEMonSessionsMessage)object);
            return;
        }
        if (object instanceof LEMonModemsMessage) {
            this.updateModem(string, (LEMonModemsMessage)object);
            return;
        }
        if (object instanceof LEStatusMessage) {
            this.updateStatus(string, (LEStatusMessage)object);
        }
    }

    void createColumnTitles(int n, int n2, Object[] objectArray) {
        objectArray[n2++] = new String("Board");
        objectArray[n2++] = new String("User");
        objectArray[n2++] = new String("Port");
        objectArray[n2++] = new String("Modem");
        objectArray[n2++] = new String("Start");
        objectArray[n2++] = new String("In Bytes");
        objectArray[n2++] = new String("Out Bytes");
        objectArray[n2++] = new String("RD Rate");
        objectArray[n2++] = new String("TR Rate");
        objectArray[n2++] = new String("Protocol");
        objectArray[n2++] = new String("Comp.");
    }

    void createRow(String string, String string2, LEMonUsersMessage lEMonUsersMessage) {
        LEPortMaster lEPortMaster = this.getPM(string);
        if (lEPortMaster == null) {
            return;
        }
        Object[] objectArray = new Object[13];
        int n = 0;
        objectArray[n++] = lEPortMaster.getDescription();
        objectArray[n++] = lEMonUsersMessage.getBoard();
        objectArray[n++] = lEMonUsersMessage.getUsername();
        objectArray[n++] = lEMonUsersMessage.getPortName();
        objectArray[n++] = lEMonUsersMessage.getModem();
        objectArray[n++] = lEMonUsersMessage.getStartTime();
        objectArray[n++] = new Long(lEMonUsersMessage.getInputBytes());
        objectArray[n++] = new Long(lEMonUsersMessage.getOutputBytes());
        objectArray[n++] = lEMonUsersMessage.getRXRate();
        objectArray[n++] = lEMonUsersMessage.getTXRate();
        objectArray[n++] = lEMonUsersMessage.getProtocol();
        objectArray[n++] = lEMonUsersMessage.getCompression();
        this.addRow(string, string2, objectArray);
    }

    void createRow(String string, String string2, LEMonSessionsMessage lEMonSessionsMessage) {
        LEPortMaster lEPortMaster = this.getPM(string);
        if (lEPortMaster == null) {
            return;
        }
        Object[] objectArray = new Object[13];
        int n = 0;
        objectArray[n++] = this.getPM(string).getDescription();
        objectArray[n++] = lEMonSessionsMessage.getBoard();
        objectArray[n++] = lEMonSessionsMessage.getUsername();
        objectArray[n++] = lEMonSessionsMessage.getPortName();
        objectArray[n++] = new String("");
        objectArray[n++] = lEMonSessionsMessage.getStartTime();
        objectArray[n++] = new Long(lEMonSessionsMessage.getInputBytes());
        objectArray[n++] = new Long(lEMonSessionsMessage.getOutputBytes());
        objectArray[n++] = new String("");
        objectArray[n++] = new String("");
        objectArray[n++] = new String("");
        objectArray[n++] = new String("");
        this.addRow(string, string2, objectArray);
    }

    void updateUser(String string, LEMonUsersMessage lEMonUsersMessage) {
        if (this.m_selected_pm == null || !string.equals(this.m_selected_pm.getResourceID())) {
            return;
        }
        if (!this.isCurrentBoard(lEMonUsersMessage.getBoard())) {
            return;
        }
        if (lEMonUsersMessage.getPortName().equals("")) {
            return;
        }
        String string2 = lEMonUsersMessage.getPortName();
        Integer n = this.getRow(string, string2);
        if (n == null) {
            this.createRow(string, string2, lEMonUsersMessage);
            return;
        }
        this.updateRow((int)n, lEMonUsersMessage);
    }

    void updateSession(String string, LEMonSessionsMessage lEMonSessionsMessage) {
        if (this.m_selected_pm == null || !string.equals(this.m_selected_pm.getResourceID())) {
            return;
        }
        if (!this.isCurrentBoard(lEMonSessionsMessage.getBoard())) {
            return;
        }
        String string2 = lEMonSessionsMessage.getPortName();
        String string3 = lEMonSessionsMessage.getUsername();
        Integer n = this.getRow(string, string2);
        if (n == null) {
            if (string3 != null && string3.length() > 0) {
                this.createRow(string, string2, lEMonSessionsMessage);
                return;
            }
        } else {
            if (string3 != null && string3.length() > 0) {
                String string4 = (String)this.getCellItem(n, 2);
                if (string4.equals(string3)) {
                    this.updateRow((int)n, lEMonSessionsMessage);
                    return;
                }
                this.removeRow(n);
                this.createRow(string, string2, lEMonSessionsMessage);
                return;
            }
            this.removeRow(n);
        }
    }

    void updateModem(String string, LEMonModemsMessage lEMonModemsMessage) {
        if (this.m_selected_pm == null || !string.equals(this.m_selected_pm.getResourceID())) {
            return;
        }
        if (!this.isCurrentBoard(lEMonModemsMessage.getBoard())) {
            return;
        }
        String string2 = lEMonModemsMessage.getPortName();
        Integer n = this.getRow(string, string2);
        if (n != null) {
            this.updateRow((int)n, lEMonModemsMessage);
        }
    }

    void updateRow(int n, LEMonUsersMessage lEMonUsersMessage) {
        int n2 = 0;
        ++n2;
        ++n2;
        int n3 = ++n2;
        this.setCellItem(n, n3, lEMonUsersMessage.getPortName());
        int n4 = ++n2;
        this.setCellItem(n, n4, lEMonUsersMessage.getModem());
        int n5 = ++n2;
        ++n2;
        this.setCellItem(n, n5, lEMonUsersMessage.getStartTime());
        LEMonitorData lEMonitorData = (LEMonitorData)this.getRowObject(n);
        if (lEMonitorData == null) {
            return;
        }
        this.setCellItem(n, n2, lEMonitorData.getCounter(n2, lEMonUsersMessage.getInputBytes()));
        this.setCellItem(n, ++n2, lEMonitorData.getCounter(n2, lEMonUsersMessage.getOutputBytes()));
        int n6 = ++n2;
        this.setCellItem(n, n6, lEMonUsersMessage.getRXRate());
        int n7 = ++n2;
        this.setCellItem(n, n7, lEMonUsersMessage.getTXRate());
        int n8 = ++n2;
        this.setCellItem(n, n8, lEMonUsersMessage.getProtocol());
        int n9 = ++n2;
        ++n2;
        this.setCellItem(n, n9, lEMonUsersMessage.getCompression());
    }

    void updateRow(int n, LEMonSessionsMessage lEMonSessionsMessage) {
        int n2 = 0;
        ++n2;
        ++n2;
        ++n2;
        ++n2;
        int n3 = ++n2;
        ++n2;
        this.setCellItem(n, n3, lEMonSessionsMessage.getStartTime());
        LEMonitorData lEMonitorData = (LEMonitorData)this.getRowObject(n);
        if (lEMonitorData != null) {
            this.setCellItem(n, n2, lEMonitorData.getCounter(n2, lEMonSessionsMessage.getInputBytes()));
        }
        ++n2;
        if (lEMonitorData != null) {
            this.setCellItem(n, n2, lEMonitorData.getCounter(n2, lEMonSessionsMessage.getOutputBytes()));
        }
        ++n2;
    }

    void updateRow(int n, LEMonModemsMessage lEMonModemsMessage) {
        int n2 = 0;
        ++n2;
        ++n2;
        ++n2;
        int n3 = ++n2;
        ++n2;
        this.setCellItem(n, n3, lEMonModemsMessage.getName());
        ++n2;
        ++n2;
        int n4 = ++n2;
        this.setCellItem(n, n4, lEMonModemsMessage.getRXRate());
        int n5 = ++n2;
        this.setCellItem(n, n5, lEMonModemsMessage.getTXRate());
        int n6 = ++n2;
        this.setCellItem(n, n6, lEMonModemsMessage.getProtocol());
        int n7 = ++n2;
        ++n2;
        this.setCellItem(n, n7, lEMonModemsMessage.getCompression());
    }

    boolean isValidBoardType(String string) {
        return string.equals("Quad T1") || string.equals("Tri E1") || string.equals("LNS");
    }

    void startMonitoringNow(LEPortMaster lEPortMaster, String string) {
        int n = this.parseBoardID(string);
        String string2 = lEPortMaster.getResourceID();
        LEStatusFactory.GetFactory().addObserver(string2, this);
        LEConnectionFacade lEConnectionFacade = lEPortMaster.getConnectionFacade();
        if (!(lEConnectionFacade instanceof LEPMConnectionFacade)) {
            return;
        }
        LEPMConnectionFacade lEPMConnectionFacade = (LEPMConnectionFacade)lEConnectionFacade;
        LEMonitorFactory.GetFactory().addObserver(string2, this);
        this.m_new = lEPMConnectionFacade.startMonitor(0x1C0000, n, LEPMConnectionFacade.NO_GROUP, 30000);
        if (!this.m_new) {
            lEPMConnectionFacade.stopMonitor(0x1C0000, n, LEPMConnectionFacade.NO_GROUP, 30000);
            lEPMConnectionFacade.startMonitor(65536, n, LEPMConnectionFacade.NO_GROUP, 30000);
            lEPMConnectionFacade.startMonitor(196608, n, LEPMConnectionFacade.NO_GROUP, 30000);
        }
    }

    void stopMonitoringNow(LEPortMaster lEPortMaster, String string) {
        int n = this.parseBoardID(string);
        String string2 = lEPortMaster.getResourceID();
        LEStatusFactory.GetFactory().deleteObserver(string2, this);
        this.remove(string2);
        LEConnectionFacade lEConnectionFacade = lEPortMaster.getConnectionFacade();
        if (!(lEConnectionFacade instanceof LEPMConnectionFacade)) {
            return;
        }
        LEPMConnectionFacade lEPMConnectionFacade = (LEPMConnectionFacade)lEConnectionFacade;
        LEMonitorFactory.GetFactory().deleteObserver(string2, this);
        if (this.m_new) {
            lEPMConnectionFacade.stopMonitor(0x1C0000, n, LEPMConnectionFacade.NO_GROUP, 30000);
            return;
        }
        lEPMConnectionFacade.stopMonitor(65536, n, LEPMConnectionFacade.NO_GROUP, 30000);
        lEPMConnectionFacade.stopMonitor(196608, n, LEPMConnectionFacade.NO_GROUP, 30000);
    }

    void removeRow(int n) {
        this.deleteRow(n);
        this.rebuildRowKeys();
    }

    String getMonitorName() {
        return "Monitor Users";
    }
}

