/*
 * Decompiled with CFR 0.152.
 */
import com.lucent.ra.nms.amf.LEAMFactory;
import com.lucent.ra.nms.amf.LEAMObserver;
import com.lucent.ra.nms.backend.LEMonitorFactory;
import com.lucent.ra.nms.backend.LEStatusFactory;
import com.lucent.ra.nms.backend.LEStatusMessage;
import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.model.LEPMConnectionFacade;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.ui.LEMLEvent;
import com.lucent.ra.nms.ui.LEMLListener;
import com.lucent.ra.nms.ui.LEMultiList;
import com.lucent.ra.nms.ui.LEScrollPanel;
import com.lucent.ra.nms.util.LEAlphaNumericCompare;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEIPCompare;
import com.lucent.ra.nms.util.LEVector;
import com.lucent.ra.nms.view.LEViewEvent;
import com.lucent.ra.nms.view.LEViewListener;
import com.lucent.ra.nms.view.LEViewSubWindow;
import java.awt.Button;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.TimeZone;

public abstract class LEMonitorPanel
extends LEMultiList
implements LEPMView,
LEMLListener,
LEAMObserver,
ActionListener,
Runnable {
    public static final Long ZERO = new Long(0L);
    static final String PORTMASTER = new String("Device");
    LEViewListener m_listener;
    LEScrollPanel m_scroll;
    Hashtable m_monitors = new Hashtable();
    Hashtable m_rowKey = new Hashtable();
    LEPortMaster[] m_pms;
    LEVector m_tasks = new LEVector();
    boolean m_running = true;
    Panel m_buttons = new Panel();
    Button m_reset;
    Button m_restore;
    Button m_tearoff;
    Label m_resetTime;
    int[] m_resetCols;

    public LEMonitorPanel() {
        this.m_buttons.setLayout(new FlowLayout(1));
        this.m_reset = new Button("Reset Counters");
        this.m_buttons.add(this.m_reset);
        this.m_reset.addActionListener(this);
        this.m_restore = new Button("Restore Counters");
        this.m_buttons.add(this.m_restore);
        this.m_resetTime = new Label("");
        this.m_buttons.add(this.m_resetTime);
        this.m_restore.addActionListener(this);
        this.m_tearoff = new Button("New Window");
        this.m_buttons.add(this.m_tearoff);
        this.m_tearoff.addActionListener(this);
        new Thread((Runnable)this, this.getMonitorName()).start();
    }

    public void initialize(int n, int n2, int n3) {
        super.initialize(n, n2, n3);
        int n4 = n2 + n3;
        int n5 = 0;
        while (n5 < n) {
            Object[] objectArray = new Object[n4];
            objectArray[0] = PORTMASTER;
            this.createColumnTitles(n5, 1, objectArray);
            this.setTitles(n5, objectArray);
            ++n5;
        }
        int n6 = 0;
        while (n6 < n4) {
            this.setSortable(n6, true);
            ++n6;
        }
        this.setSortObject(0, new LEIPCompare());
        this.setSortObject(1, new LEAlphaNumericCompare());
        super.addListener(this);
        this.m_scroll = new LEScrollPanel(this);
    }

    public synchronized void setSelection(LEPortMaster[] lEPortMasterArray) {
        int n;
        boolean bl;
        int n2;
        if (this.m_pms != null) {
            n2 = 0;
            while (n2 < this.m_pms.length) {
                bl = false;
                n = 0;
                while (!bl && n < lEPortMasterArray.length) {
                    if (this.m_pms[n2] == lEPortMasterArray[n]) {
                        bl = true;
                    }
                    ++n;
                }
                if (!bl) {
                    this.stopMonitoring(this.m_pms[n2]);
                }
                ++n2;
            }
        }
        n2 = 0;
        while (n2 < lEPortMasterArray.length) {
            bl = false;
            if (this.m_pms != null) {
                n = 0;
                while (!bl && n < this.m_pms.length) {
                    if (lEPortMasterArray[n2] == this.m_pms[n]) {
                        bl = true;
                    }
                    ++n;
                }
            }
            if (!bl) {
                this.startMonitoring(lEPortMasterArray[n2]);
            }
            ++n2;
        }
        this.m_pms = lEPortMasterArray;
    }

    public void addListener(LEViewListener lEViewListener) {
        this.m_listener = lEViewListener;
    }

    public void deleteListener(LEViewListener lEViewListener) {
        if (this.m_listener == lEViewListener) {
            this.m_listener = null;
        }
    }

    public Component getMainPanel() {
        return this.m_scroll;
    }

    public Component getBottomPanel() {
        return this.m_buttons;
    }

    public void going() {
        if (this.m_pms == null) {
            return;
        }
        int n = 0;
        while (n < this.m_pms.length) {
            this.stopMonitoring(this.m_pms[n]);
            ++n;
        }
        this.m_pms = null;
    }

    public void gone() {
        try {
            super.deleteListener(this);
            this.m_monitors = null;
            this.m_rowKey = null;
            this.cleanUp();
            LEMonitorPanel lEMonitorPanel = this;
            synchronized (lEMonitorPanel) {
                this.m_running = false;
                this.notify();
                return;
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return;
        }
    }

    public synchronized void onLEMLEvent(LEMLEvent lEMLEvent) {
        if (this.m_pms == null) {
            return;
        }
        if (lEMLEvent.getType() == 5) {
            this.rebuildRowKeys();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.m_reset) {
            if (this.m_resetCols == null) {
                return;
            }
            int n = 0;
            while (n < this.m_resetCols.length) {
                this.resetColumn(this.m_resetCols[n]);
                ++n;
            }
            Date date = new Date();
            DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 3, Locale.getDefault());
            dateFormat.setTimeZone(TimeZone.getDefault());
            this.m_resetTime.setText("Reset: " + dateFormat.format(date));
            this.m_resetTime.invalidate();
            this.m_buttons.invalidate();
            this.m_buttons.validate();
            return;
        }
        if (actionEvent.getSource() == this.m_restore) {
            if (this.m_resetCols == null) {
                return;
            }
            int n = 0;
            while (n < this.m_resetCols.length) {
                this.restoreColumn(this.m_resetCols[n]);
                ++n;
            }
            this.m_resetTime.setText("");
            this.m_resetTime.invalidate();
            this.m_buttons.invalidate();
            this.m_buttons.validate();
            return;
        }
        if (actionEvent.getSource() == this.m_tearoff) {
            this.createNewWindow();
        }
    }

    public void run() {
        while (this.m_running) {
            try {
                this.doTasks();
                LEMonitorPanel lEMonitorPanel = this;
                synchronized (lEMonitorPanel) {
                    if (this.m_running && this.m_tasks.size() == 0) {
                        this.wait();
                    }
                }
            }
            catch (Exception exception) {
                LEDebug.getLog().logln(20, exception);
            }
        }
        this.doTasks();
    }

    void doTasks() {
        while (this.m_tasks.size() > 0) {
            LEMonitorTask lEMonitorTask = (LEMonitorTask)this.m_tasks.removeElementAt(0);
            if (lEMonitorTask.getAction() == 1) {
                this.startMonitoringNow(lEMonitorTask.getPortMaster(), lEMonitorTask.getBoard());
                continue;
            }
            this.stopMonitoringNow(lEMonitorTask.getPortMaster(), lEMonitorTask.getBoard());
        }
    }

    LEPortMaster getPM(String string) {
        LEPortMaster lEPortMaster = null;
        int n = 0;
        while (n < this.m_pms.length && lEPortMaster == null) {
            if (this.m_pms[n].getResourceID().equals(string)) {
                lEPortMaster = this.m_pms[n];
            }
            ++n;
        }
        return lEPortMaster;
    }

    void rebuildRowKeys() {
        this.m_rowKey.clear();
        int n = this.getNumRows();
        int n2 = 0;
        while (n2 < n) {
            LEMonitorData lEMonitorData = (LEMonitorData)this.getRowObject(n2);
            String string = lEMonitorData.getID();
            String string2 = lEMonitorData.getEntity();
            this.saveRowKey(string, string2, n2);
            ++n2;
        }
    }

    void updateStatus(String string, LEStatusMessage lEStatusMessage) {
        switch (lEStatusMessage.getStatus()) {
            case 2: 
            case 4: {
                this.remove(string);
                return;
            }
        }
    }

    void saveRowKey(String string, String string2, int n) {
        Hashtable<String, Integer> hashtable = (Hashtable<String, Integer>)this.m_rowKey.get(string);
        if (hashtable == null) {
            hashtable = new Hashtable<String, Integer>();
            this.m_rowKey.put(string, hashtable);
        }
        hashtable.put(string2, new Integer(n));
    }

    Integer getRow(String string, String string2) {
        Hashtable hashtable;
        Integer n = null;
        if (this.m_rowKey != null && (hashtable = (Hashtable)this.m_rowKey.get(string)) != null) {
            n = (Integer)hashtable.get(string2);
        }
        return n;
    }

    void addRow(String string, String string2, Object[] objectArray) {
        if (this.m_rowKey == null) {
            return;
        }
        int n = this.getNumRows();
        int n2 = this.getNumColumns();
        this.addRow(objectArray);
        this.setRowObject(n, new LEMonitorData(string, string2, n2));
        this.saveRowKey(string, string2, n);
        this.layoutGrid();
    }

    void resetColumn(int n) {
        int n2 = this.getNumRows();
        int n3 = 0;
        while (n3 < n2) {
            Long l;
            LEMonitorData lEMonitorData = (LEMonitorData)this.getRowObject(n3);
            if (lEMonitorData != null && (l = (Long)this.getCellItem(n3, n)) != null) {
                lEMonitorData.resetColumn(n, l);
                this.setCellItem(n3, n, ZERO);
            }
            ++n3;
        }
    }

    void restoreColumn(int n) {
        int n2 = this.getNumRows();
        int n3 = 0;
        while (n3 < n2) {
            Long l;
            LEMonitorData lEMonitorData = (LEMonitorData)this.getRowObject(n3);
            if (lEMonitorData != null && (l = (Long)this.getCellItem(n3, n)) != null) {
                this.setCellItem(n3, n, new Long(l + lEMonitorData.getReset(n)));
                lEMonitorData.restoreColumn(n);
            }
            ++n3;
        }
    }

    int parseBoardID(String string) {
        int n;
        block2: {
            n = -1;
            if (string == null || string.length() <= 0) break block2;
            try {
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {
                LEDebug.getLog().logln(20, exception);
            }
        }
        return n;
    }

    void addTask(int n, LEPortMaster lEPortMaster, String string) {
        this.m_tasks.addElement(new LEMonitorTask(n, lEPortMaster, string));
        LEMonitorPanel lEMonitorPanel = this;
        synchronized (lEMonitorPanel) {
            this.notify();
            return;
        }
    }

    void startMonitoring(LEPortMaster lEPortMaster) {
        this.startMonitoring(lEPortMaster, null);
    }

    void startMonitoring(LEPortMaster lEPortMaster, String string) {
        this.addTask(1, lEPortMaster, string);
    }

    void startMonitoringNow(LEPortMaster lEPortMaster, String string) {
        int n = this.parseBoardID(string);
        String string2 = lEPortMaster.getResourceID();
        LEStatusFactory.GetFactory().addObserver(string2, this);
        LEConnectionFacade lEConnectionFacade = lEPortMaster.getConnectionFacade();
        if (!(lEConnectionFacade instanceof LEPMConnectionFacade)) {
            return;
        }
        LEPMConnectionFacade lEPMConnectionFacade = (LEPMConnectionFacade)lEConnectionFacade;
        int[] nArray = this.getMonitorEntities();
        if (nArray != null) {
            LEMonitorFactory.GetFactory().addObserver(string2, this);
            int n2 = 0;
            while (n2 < nArray.length) {
                lEPMConnectionFacade.startMonitor(nArray[n2], n, LEPMConnectionFacade.NO_GROUP, 30000);
                ++n2;
            }
        }
    }

    void stopMonitoring(LEPortMaster lEPortMaster) {
        this.stopMonitoring(lEPortMaster, null);
    }

    void stopMonitoring(LEPortMaster lEPortMaster, String string) {
        this.addTask(2, lEPortMaster, string);
    }

    void stopMonitoringNow(LEPortMaster lEPortMaster, String string) {
        int n = this.parseBoardID(string);
        String string2 = lEPortMaster.getResourceID();
        LEStatusFactory.GetFactory().deleteObserver(string2, this);
        this.remove(string2);
        LEConnectionFacade lEConnectionFacade = lEPortMaster.getConnectionFacade();
        if (!(lEConnectionFacade instanceof LEPMConnectionFacade)) {
            return;
        }
        LEPMConnectionFacade lEPMConnectionFacade = (LEPMConnectionFacade)lEConnectionFacade;
        int[] nArray = this.getMonitorEntities();
        if (nArray != null) {
            LEMonitorFactory.GetFactory().deleteObserver(string2, this);
            int n2 = 0;
            while (n2 < nArray.length) {
                lEPMConnectionFacade.stopMonitor(nArray[n2], n, LEPMConnectionFacade.NO_GROUP, 30000);
                ++n2;
            }
        }
    }

    void remove(String string) {
        if (this.m_rowKey == null) {
            return;
        }
        this.m_rowKey.remove(string);
        int n = this.getNumRows();
        int n2 = n - 1;
        while (n2 > -1) {
            LEMonitorData lEMonitorData = (LEMonitorData)this.getRowObject(n2);
            if (lEMonitorData.getID().equals(string)) {
                this.deleteRow(n2);
            }
            --n2;
        }
    }

    void createNewWindow() {
        LEViewSubWindow lEViewSubWindow = new LEViewSubWindow(this, this.getMonitorName());
        this.m_tearoff.setEnabled(false);
        if (this.m_listener != null) {
            LEViewEvent lEViewEvent = new LEViewEvent(10, lEViewSubWindow);
            this.m_listener.onLEViewEvent(lEViewEvent);
        }
    }

    int[] getMonitorEntities() {
        return null;
    }

    abstract void createColumnTitles(int var1, int var2, Object[] var3);

    abstract String getMonitorName();

    public abstract void update(LEAMFactory var1, String var2, Object var3);
}

