/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.backend;

import com.lucent.ra.nms.backend.LEDSSException;
import com.lucent.ra.nms.backend.LEDSSPortMaster_RI;
import com.lucent.ra.nms.backend.LEDebugFacility_R;
import com.lucent.ra.nms.backend.LEDebugSetting;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEVector;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Enumeration;
import java.util.Hashtable;

public class LEDebugFacility_RI
extends UnicastRemoteObject
implements LEDebugFacility_R {
    private static final String CONSOLE_ON = "set console on";
    private static final String CONSOLE_OFF = "reset console";
    LEDSSPortMaster_RI m_dss;
    Hashtable m_hexes = new Hashtable();
    Hashtable m_hexReqs = new Hashtable();
    Hashtable m_boards = new Hashtable();

    public LEDebugFacility_RI(LEDSSPortMaster_RI lEDSSPortMaster_RI) throws RemoteException {
        this.m_dss = lEDSSPortMaster_RI;
    }

    public synchronized boolean startDebug(int n, int n2, int n3) throws RemoteException {
        if (n == 393216) {
            return this.startHexDebug(n2, n3);
        }
        return this.startEntityDebug(n, n2, n3);
    }

    public synchronized void stopDebug(int n, int n2, int n3) throws RemoteException {
        if (n == 393216) {
            this.stopHexDebug(n2, n3);
            return;
        }
        this.stopEntityDebug(n, n2, n3);
    }

    synchronized void shutdown() {
        this.m_hexes.clear();
        Enumeration enumeration = this.m_hexReqs.keys();
        while (enumeration.hasMoreElements()) {
            Integer n = (Integer)enumeration.nextElement();
            Long l = (Long)this.m_hexReqs.get(n);
            try {
                if (!this.m_dss.isConnected()) continue;
                this.resetHexDebug(l, 0, -1);
            }
            catch (RemoteException remoteException) {
                LEDebug.getLog().logln(20, remoteException);
            }
        }
        this.m_hexReqs.clear();
        Enumeration enumeration2 = this.m_boards.elements();
        while (enumeration2.hasMoreElements()) {
            Hashtable hashtable = (Hashtable)enumeration2.nextElement();
            Enumeration enumeration3 = hashtable.elements();
            while (enumeration3.hasMoreElements()) {
                Hashtable hashtable2 = (Hashtable)enumeration3.nextElement();
                Enumeration enumeration4 = hashtable2.elements();
                while (enumeration4.hasMoreElements()) {
                    LEDebugSetting lEDebugSetting = (LEDebugSetting)enumeration4.nextElement();
                    try {
                        if (!this.m_dss.isConnected()) continue;
                        this.m_dss.killDebug(lEDebugSetting.getRequestID());
                    }
                    catch (LEDSSException lEDSSException) {
                    }
                    catch (Exception exception) {
                        LEDebug.getLog().logln(20, exception);
                    }
                }
                hashtable2.clear();
            }
            hashtable.clear();
        }
        this.m_boards.clear();
        try {
            if (this.m_dss.isConnected()) {
                this.m_dss.execute(CONSOLE_OFF);
                return;
            }
        }
        catch (RemoteException remoteException) {
            LEDebug.getLog().logln(20, remoteException);
        }
    }

    boolean startHexDebug(int n, int n2) {
        Integer n3 = new Integer(n2);
        LEVector lEVector = (LEVector)this.m_hexes.get(n3);
        if (lEVector == null) {
            lEVector = new LEVector();
            this.m_hexes.put(n3, lEVector);
        }
        int n4 = 0;
        int n5 = lEVector.size();
        int n6 = 0;
        while (n6 < n5) {
            n4 |= ((Integer)lEVector.elementAt(n6)).intValue();
            ++n6;
        }
        lEVector.addElement(new Integer(n));
        int n7 = n4 | n;
        if (n7 == n4) {
            return true;
        }
        long l = 0L;
        Long l2 = (Long)this.m_hexReqs.remove(n3);
        if (l2 != null) {
            l = l2;
        }
        if ((l = this.resetHexDebug(l, n7, n2)) > 0L) {
            this.m_hexReqs.put(n3, new Long(l));
            return true;
        }
        return false;
    }

    boolean startEntityDebug(int n, int n2, int n3) {
        Integer n4;
        LEDebugSetting lEDebugSetting;
        Integer n5;
        Hashtable<Integer, LEDebugSetting> hashtable;
        Integer n6 = new Integer(n3);
        Hashtable hashtable2 = (Hashtable)this.m_boards.get(n6);
        if (hashtable2 == null) {
            hashtable2 = new Hashtable();
            this.m_boards.put(n6, hashtable2);
        }
        if ((hashtable = (Hashtable<Integer, LEDebugSetting>)hashtable2.get(n5 = new Integer(n))) == null) {
            hashtable = new Hashtable<Integer, LEDebugSetting>();
            hashtable2.put(n5, hashtable);
        }
        if ((lEDebugSetting = (LEDebugSetting)hashtable.get(n4 = new Integer(n2))) == null) {
            try {
                long l = 0L;
                l = n3 == -1 ? this.m_dss.debug(n, n2) : this.m_dss.debug(n, n2, n3);
                this.m_dss.execute(CONSOLE_ON);
                lEDebugSetting = new LEDebugSetting(l);
                hashtable.put(n4, lEDebugSetting);
            }
            catch (Exception exception) {
                LEDebug.getLog().logln(20, exception);
                return false;
            }
        } else {
            lEDebugSetting.increment();
        }
        return true;
    }

    void stopHexDebug(int n, int n2) {
        Integer n3 = new Integer(n2);
        LEVector lEVector = (LEVector)this.m_hexes.get(n3);
        if (lEVector == null) {
            return;
        }
        lEVector.removeElement(new Integer(n));
        int n4 = 0;
        int n5 = lEVector.size();
        int n6 = 0;
        while (n6 < n5) {
            n4 |= ((Integer)lEVector.elementAt(n6)).intValue();
            ++n6;
        }
        int n7 = n4 | n;
        if (n7 == n4) {
            return;
        }
        long l = 0L;
        Long l2 = (Long)this.m_hexReqs.remove(n3);
        if (l2 != null) {
            l = l2;
        }
        if ((l = this.resetHexDebug(l, n4, n2)) > 0L) {
            this.m_hexReqs.put(n3, new Long(l));
        }
    }

    void stopEntityDebug(int n, int n2, int n3) {
        Integer n4 = new Integer(n3);
        Hashtable hashtable = (Hashtable)this.m_boards.get(n4);
        if (hashtable == null) {
            return;
        }
        Integer n5 = new Integer(n);
        Hashtable hashtable2 = (Hashtable)hashtable.get(n5);
        if (hashtable2 == null) {
            return;
        }
        Integer n6 = new Integer(n2);
        LEDebugSetting lEDebugSetting = (LEDebugSetting)hashtable2.get(n6);
        if (lEDebugSetting == null) {
            return;
        }
        if (lEDebugSetting.decrement() == 0) {
            hashtable2.remove(n6);
            try {
                this.m_dss.killDebug(lEDebugSetting.getRequestID());
                return;
            }
            catch (Exception exception) {
                LEDebug.getLog().logln(20, exception);
                return;
            }
        }
    }

    long resetHexDebug(long l, int n, int n2) {
        block7: {
            if (l > 0L) {
                try {
                    this.m_dss.killDebug(l);
                }
                catch (LEDSSException lEDSSException) {
                }
                catch (Exception exception) {
                    LEDebug.getLog().logln(20, exception);
                }
                l = 0L;
            }
            if (n <= 0) break block7;
            try {
                l = n2 == -1 ? this.m_dss.debug(393216, n) : this.m_dss.debug(393216, n, n2);
                this.m_dss.execute(CONSOLE_ON);
            }
            catch (LEDSSException lEDSSException) {
            }
            catch (Exception exception) {
                LEDebug.getLog().logln(20, exception);
            }
        }
        return l;
    }
}

