/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.forms;

import com.lucent.ra.nms.forms.LECustomPlanPanel;
import com.lucent.ra.nms.forms.LEFormLine;
import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LECustomPlan;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.ui.LECompMatrix;
import com.lucent.ra.nms.ui.LEErrorDialog;
import com.lucent.ra.nms.ui.LEFont;
import com.lucent.ra.nms.ui.LEUiUtils;
import com.lucent.ra.nms.util.LEAppInfo;
import com.lucent.ra.nms.util.LEVector;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class LESaveCustomPlanDialog
extends Dialog
implements ActionListener {
    public static final String SAVE = "OK";
    public static final String OLD_VALUE = "Old Value";
    public static final String NEW_VALUE = "New Value";
    public static final String VALID_VALUES = "Valid Values";
    LEVector m_keys = new LEVector();
    LEVector m_allKeys;
    LEVector m_panels;
    int m_index;
    LECustomPlanPanel m_panel;
    LECompMatrix m_matrix;
    Frame m_parent;
    Button m_ok;

    public LESaveCustomPlanDialog(Frame frame, LEVector lEVector, LEVector lEVector2) {
        super(frame, "Apply", true);
        this.m_allKeys = lEVector;
        this.m_parent = frame;
        this.m_panels = lEVector2;
        this.m_index = 0;
        this.setLayout(new BorderLayout(5, 5));
        this.saveNext();
    }

    public void saveNext() {
        if (this.m_index == this.m_panels.size()) {
            return;
        }
        this.m_panel = (LECustomPlanPanel)this.m_panels.elementAt(this.m_index++);
        this.removeAll();
        this.buildValues(this.m_allKeys, this.m_panel);
        if (this.m_matrix != null) {
            LEPortMaster lEPortMaster = this.m_panel.getPortMaster();
            Label label = new Label(lEPortMaster.getDescription(), 1);
            label.setFont(LEFont.getBoldFont());
            this.add("North", label);
            Panel panel = new Panel();
            panel.setLayout(new FlowLayout(1));
            Panel panel2 = new Panel();
            panel2.setLayout(new GridLayout(1, 2, 10, 10));
            this.m_ok = new Button(SAVE);
            panel2.add(this.m_ok);
            this.m_ok.addActionListener(this);
            Button button = new Button("Cancel");
            panel2.add(button);
            button.addActionListener(this);
            panel.add(panel2);
            this.add("South", panel);
            ((Component)this).setVisible(true);
            return;
        }
        this.saveNext();
    }

    public void addNotify() {
        super.addNotify();
        Dimension dimension = this.getPreferredSize();
        LEUiUtils.CenterDialog(this, dimension.width, dimension.height);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        ((Component)this).setVisible(false);
        this.dispose();
        if (actionEvent.getSource() == this.m_ok) {
            this.save();
        }
    }

    void save() {
        LECustomPlan lECustomPlan = (LECustomPlan)this.m_panel.getConfig();
        if (LEAppInfo.DemoMode()) {
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), "This feature is disabled in demo mode.");
            lECustomPlan.refresh();
            return;
        }
        int n = this.m_keys.size();
        int n2 = 0;
        while (n2 < n) {
            String string = (String)this.m_keys.elementAt(n2);
            Checkbox checkbox = (Checkbox)this.m_matrix.getComponent(n2, 0);
            if (checkbox.getState()) {
                Label label = (Label)this.m_matrix.getComponent(n2, 2);
                lECustomPlan.set(string, label.getText());
                lECustomPlan.setPlansChgFlag(true);
            }
            ++n2;
        }
        this.m_panel.resetFields(this.m_keys);
        this.saveNext();
    }

    void buildValues(LEVector lEVector, LECustomPlanPanel lECustomPlanPanel) {
        int n;
        LEFormLine lEFormLine;
        String string;
        this.m_matrix = null;
        this.m_keys.removeAllElements();
        LEConfig lEConfig = lECustomPlanPanel.getConfig();
        boolean bl = true;
        int n2 = lEVector.size();
        int n3 = 0;
        while (n3 < n2) {
            string = (String)lEVector.elementAt(n3);
            Component component = lECustomPlanPanel.getFormComponent(string);
            if (component instanceof LEFormLine && component.isEnabled() && !(lEFormLine = (LEFormLine)((Object)component)).equalsField(lEConfig.get(string))) {
                this.m_keys.addElement(string);
                if (!lEFormLine.isValueValid()) {
                    bl = false;
                }
            }
            ++n3;
        }
        int n4 = bl ? 3 : 4;
        String[] stringArray = new String[n4];
        stringArray[0] = SAVE;
        stringArray[1] = OLD_VALUE;
        stringArray[2] = NEW_VALUE;
        if (!bl) {
            stringArray[3] = VALID_VALUES;
        }
        if ((n = this.m_keys.size()) == 0) {
            return;
        }
        String[] stringArray2 = new String[n];
        Component[][] componentArray = new Component[n][n4];
        int n5 = 0;
        while (n5 < n) {
            string = (String)this.m_keys.elementAt(n5);
            stringArray2[n5] = String.valueOf(lEConfig.getDescriptionFor(string)) + ":";
            componentArray[n5][1] = new Label(lEConfig.get(string).toString(), 0);
            lEFormLine = (LEFormLine)((Object)lECustomPlanPanel.getFormComponent(string));
            componentArray[n5][2] = new Label(lEFormLine.getValue(), 0);
            if (!lEFormLine.isValueValid()) {
                componentArray[n5][0] = new Checkbox(null, null, false);
                componentArray[n5][0].setEnabled(false);
                componentArray[n5][2].setForeground(Color.red);
                componentArray[n5][3] = new Label(lEFormLine.getValidValues(), 0);
            } else {
                componentArray[n5][0] = new Checkbox(null, null, true);
            }
            ++n5;
        }
        this.m_matrix = new LECompMatrix(stringArray2, stringArray, componentArray, true);
        this.add("Center", this.m_matrix);
    }
}

