/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.forms;

import com.lucent.ra.nms.forms.LEAddDialog;
import com.lucent.ra.nms.forms.LECmdErrorDialog;
import com.lucent.ra.nms.forms.LEForm;
import com.lucent.ra.nms.forms.LENewEntry;
import com.lucent.ra.nms.model.LEAttributes;
import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.model.LEDataSpec;
import com.lucent.ra.nms.model.LEDataSpecFactory;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.model.LETable;
import com.lucent.ra.nms.ui.LECompGrid;
import com.lucent.ra.nms.ui.LEErrorDialog;
import com.lucent.ra.nms.ui.LEFont;
import com.lucent.ra.nms.ui.LEMultiList;
import com.lucent.ra.nms.ui.LEStatusDialog;
import com.lucent.ra.nms.ui.LEUiUtils;
import com.lucent.ra.nms.util.LEAlphaNumericCompare;
import com.lucent.ra.nms.util.LEAppInfo;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEObservable;
import com.lucent.ra.nms.util.LEObserver;
import com.lucent.ra.nms.util.LEVector;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Label;
import java.util.Hashtable;

public class LETableForm
extends LEMultiList
implements LEForm,
LEObserver {
    static final String PORTMASTER = "Device";
    static final String BLANK = "";
    LEPortMaster[] m_pms;
    LEVector m_context;
    String m_platform;
    LEVector m_tags = new LEVector();
    Hashtable m_objs = new Hashtable();
    int m_cols;
    boolean m_keyReadonly = false;
    boolean m_simpleTable = false;
    boolean m_renameEntries = false;

    public boolean isKeyReadonly() {
        return this.m_keyReadonly;
    }

    public boolean isSimpleTable() {
        return this.m_simpleTable;
    }

    public boolean canRenameEntries() {
        return this.m_renameEntries;
    }

    public void setContext(String string, LEVector lEVector) {
        LEDataSpec lEDataSpec;
        this.m_context = lEVector;
        this.m_platform = string;
        LEDataSpec lEDataSpec2 = null;
        String string2 = BLANK;
        try {
            lEDataSpec2 = LEDataSpecFactory.GetSpec(this.m_platform);
            int n = this.m_context.size();
            int n2 = 0;
            while (n2 < n) {
                lEDataSpec2 = lEDataSpec2.getSpecFor((String)this.m_context.elementAt(n2));
                ++n2;
            }
            LEDataSpec lEDataSpec3 = lEDataSpec2.getSpecFor("key");
            if (lEDataSpec3.getAttribute(LEAttributes.READONLY) != null) {
                this.m_keyReadonly = true;
            }
            string2 = lEDataSpec3.getDescription();
            LEVector lEVector2 = (lEDataSpec2 = lEDataSpec2.getSpecFor("entry")).getAllSpecs();
            if (lEVector2 == null) {
                this.m_tags.addElement("entry");
                this.m_simpleTable = true;
            } else {
                n = lEVector2.size();
                int n3 = 0;
                while (n3 < n) {
                    lEDataSpec = (LEDataSpec)lEVector2.elementAt(n3);
                    if (lEDataSpec.getAllSpecs() == null && lEDataSpec.getAttribute(LEAttributes.WRITEONLY) == null && lEDataSpec.getAttribute(LEAttributes.INVISIBLE) == null) {
                        this.m_tags.addElement(lEDataSpec.getTag());
                    }
                    ++n3;
                }
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        this.m_cols = this.m_tags.size();
        this.initialize(1, 2, this.m_cols);
        this.setSortable(0, true);
        this.setSortable(1, true);
        this.setSortObject(1, new LEAlphaNumericCompare());
        Object[] objectArray = new String[this.m_cols + 2];
        objectArray[0] = PORTMASTER;
        objectArray[1] = string2;
        int n = 0;
        while (n < this.m_cols) {
            if (this.m_simpleTable) {
                lEDataSpec = lEDataSpec2;
            } else {
                String string3 = (String)this.m_tags.elementAt(n);
                lEDataSpec = lEDataSpec2.getSpecFor(string3);
            }
            objectArray[n + 2] = lEDataSpec.getDescription();
            this.setSortable(n + 2, true);
            ++n;
        }
        this.setTitles(0, objectArray);
    }

    public void setPortMasters(LEPortMaster[] lEPortMasterArray) {
        int n;
        boolean bl;
        int n2;
        if (this.m_pms != null) {
            n2 = 0;
            while (n2 < this.m_pms.length) {
                bl = false;
                n = 0;
                while (!bl && n < lEPortMasterArray.length) {
                    if (this.m_pms[n2] == lEPortMasterArray[n]) {
                        bl = true;
                    }
                    ++n;
                }
                if (!bl) {
                    this.removePortMaster(this.m_pms[n2]);
                }
                ++n2;
            }
        }
        n2 = 0;
        while (n2 < lEPortMasterArray.length) {
            bl = false;
            if (this.m_pms != null) {
                n = 0;
                while (!bl && n < this.m_pms.length) {
                    if (lEPortMasterArray[n2] == this.m_pms[n]) {
                        bl = true;
                    }
                    ++n;
                }
            }
            if (!bl) {
                this.addPortMaster(lEPortMasterArray[n2]);
            }
            ++n2;
        }
        this.m_pms = lEPortMasterArray;
        this.repaint();
    }

    public int getNumberOfPM() {
        if (this.m_pms != null) {
            return this.m_pms.length;
        }
        return 0;
    }

    public Object getEntry(int n) {
        LETable lETable;
        Object object = null;
        LEPortMaster lEPortMaster = this.getPortMaster(n);
        if (lEPortMaster != null && (lETable = this.getTable(lEPortMaster)) != null) {
            String string = (String)this.getCellItem(n, 1);
            object = lETable.get(string);
        }
        return object;
    }

    public LETable getTable(String string) {
        LETable lETable = null;
        int n = 0;
        while (lETable == null && n < this.m_pms.length) {
            if (string.equals(this.m_pms[n].getDescription())) {
                lETable = this.getTable(this.m_pms[n]);
            }
            ++n;
        }
        return lETable;
    }

    public void refresh() {
        LEStatusDialog lEStatusDialog = new LEStatusDialog(LEUiUtils.GetBaseFrame());
        int n = 0;
        while (n < this.m_pms.length) {
            this.removePortMaster(this.m_pms[n]);
            ++n;
        }
        int n2 = 0;
        while (n2 < this.m_pms.length) {
            LETable lETable = this.getTable(this.m_pms[n2]);
            if (lETable != null) {
                lETable.refresh();
            }
            this.addPortMaster(this.m_pms[n2]);
            ++n2;
        }
        lEStatusDialog.hideStatus();
    }

    public void gone() {
        int n = 0;
        while (n < this.m_pms.length) {
            this.removePortMaster(this.m_pms[n]);
            ++n;
        }
    }

    public LEVector add() {
        LEVector lEVector = new LEVector();
        if (LEAppInfo.DemoMode()) {
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), "This feature is disabled in demo mode.");
            return lEVector;
        }
        int n = 0;
        LEDataSpec lEDataSpec = null;
        LEDataSpec lEDataSpec2 = null;
        int n2 = 0;
        while (n2 < this.m_pms.length) {
            LETable lETable = this.getTable(this.m_pms[n2]);
            if (lETable != null) {
                ++n;
                if (lEDataSpec == null) {
                    lEDataSpec = lETable.getKeySpec();
                }
                if (lEDataSpec2 == null) {
                    lEDataSpec2 = lETable.getSpecFor("entry");
                }
            }
            ++n2;
        }
        if (n == 0) {
            return lEVector;
        }
        if (!this.addNewEntry(lEDataSpec, lEDataSpec2)) {
            return lEVector;
        }
        LEVector lEVector2 = this.determinePMs("Add");
        if (lEVector2 != null) {
            LEStatusDialog lEStatusDialog = new LEStatusDialog(LEUiUtils.GetBaseFrame());
            int n3 = lEVector2.size();
            int n4 = 0;
            while (n4 < n3) {
                LENewEntry lENewEntry = this.addNewEntryTo((LEPortMaster)lEVector2.elementAt(n4));
                if (lENewEntry != null) {
                    lEVector.addElement(lENewEntry);
                }
                ++n4;
            }
            lEStatusDialog.hideStatus();
            this.layoutGrid();
        }
        return lEVector;
    }

    public void delete() {
        if (LEAppInfo.DemoMode()) {
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), "This feature is disabled in demo mode.");
            return;
        }
        LEStatusDialog lEStatusDialog = new LEStatusDialog(LEUiUtils.GetBaseFrame());
        int[] nArray = this.getSelectedRows();
        int n = nArray.length - 1;
        while (n > -1) {
            LEPortMaster lEPortMaster = this.getPortMaster(nArray[n]);
            String string = (String)this.getCellItem(nArray[n], 1);
            LETable lETable = this.getTable(lEPortMaster);
            this.delete(lEPortMaster, lETable, string);
            --n;
        }
        this.refillTable();
        lEStatusDialog.hideStatus();
    }

    public void paste(Object object) {
        if (LEAppInfo.DemoMode()) {
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), "This feature is disabled in demo mode.");
            return;
        }
        LEVector lEVector = this.determinePMs("Paste");
        if (lEVector != null) {
            LEStatusDialog lEStatusDialog = new LEStatusDialog(LEUiUtils.GetBaseFrame());
            int n = lEVector.size();
            int n2 = 0;
            while (n2 < n) {
                this.pasteTo((LEPortMaster)lEVector.elementAt(n2), object);
                ++n2;
            }
            lEStatusDialog.hideStatus();
            this.layoutGrid();
        }
    }

    public void clone(Object object) {
        if (LEAppInfo.DemoMode()) {
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), "This feature is disabled in demo mode.");
            return;
        }
        if (!(object instanceof LEConfig)) {
            return;
        }
        int[] nArray = this.getSelectedRows();
        if (nArray.length == 0) {
            return;
        }
        LEStatusDialog lEStatusDialog = new LEStatusDialog(LEUiUtils.GetBaseFrame());
        LEConfig lEConfig = (LEConfig)object;
        int n = 0;
        while (n < nArray.length) {
            LEConfig lEConfig2 = (LEConfig)this.getEntry(nArray[n]);
            if (lEConfig2 != null) {
                LEConnectionFacade lEConnectionFacade = lEConfig2.getConnectionFacade();
                lEConfig2.copy(lEConfig);
                LEVector lEVector = lEConfig2.saveChanges();
                if (lEVector != null) {
                    new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), lEConnectionFacade, lEVector);
                }
                this.updateEntry(lEConnectionFacade.getDescription(), (LETable)lEConfig2.getOwner(), (String)this.getCellItem(nArray[n], 1));
            }
            ++n;
        }
        lEStatusDialog.hideStatus();
    }

    public void rename() {
        String string;
        LETable lETable;
        if (LEAppInfo.DemoMode()) {
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), "This feature is disabled in demo mode.");
            return;
        }
        int[] nArray = this.getSelectedRows();
        if (nArray.length != 1) {
            return;
        }
        LEPortMaster lEPortMaster = this.getPortMaster(nArray[0]);
        String string2 = this.renameEntry(lEPortMaster, lETable = this.getTable(lEPortMaster), string = (String)this.getCellItem(nArray[0], 1));
        if (string2 != null) {
            LEStatusDialog lEStatusDialog = new LEStatusDialog(LEUiUtils.GetBaseFrame());
            LEConfig lEConfig = (LEConfig)lETable.get(string);
            LEConfig lEConfig2 = (LEConfig)lETable.get(string2);
            lEConfig2.copy(lEConfig);
            LEVector lEVector = lEConfig2.saveChanges();
            if (lEVector != null) {
                new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), lEPortMaster.getConnectionFacade(), lEVector);
            }
            this.delete(lEPortMaster, lETable, string);
            this.setCellItem(nArray[0], 1, string2);
            lEStatusDialog.hideStatus();
        }
    }

    public void update(LEObservable lEObservable, Object object) {
        String string = (String)this.m_objs.get(lEObservable);
        if (string == null) {
            return;
        }
        LETable lETable = (LETable)((LEConfig)lEObservable).getOwner();
        String string2 = lETable.getConnectionFacade().getDescription();
        this.updateEntry(string2, lETable, string);
    }

    LEPortMaster getPortMaster(int n) {
        LEPortMaster lEPortMaster = null;
        String string = (String)this.getCellItem(n, 0);
        int n2 = 0;
        while (lEPortMaster == null && n2 < this.m_pms.length) {
            if (string.equals(this.m_pms[n2].getDescription())) {
                lEPortMaster = this.m_pms[n2];
            }
            ++n2;
        }
        return lEPortMaster;
    }

    void addPortMaster(LEPortMaster lEPortMaster) {
        LETable lETable = this.getTable(lEPortMaster);
        if (lETable != null) {
            LEVector lEVector = lETable.getKeys();
            String string = lEPortMaster.getDescription();
            int n = lEVector.size();
            int n2 = 0;
            while (n2 < n) {
                String string2 = (String)lEVector.elementAt(n2);
                this.addEntry(string, lETable, string2);
                ++n2;
            }
        }
    }

    void addEntry(String string, LETable lETable, String string2) {
        Object object = lETable.get(string2);
        if (object == null) {
            return;
        }
        Object[] objectArray = new Object[this.m_cols + 2];
        objectArray[0] = string;
        objectArray[1] = string2;
        if (this.m_cols > 0) {
            if (object instanceof LEConfig) {
                LEConfig lEConfig = (LEConfig)object;
                lEConfig.addObserver(this);
                this.m_objs.put(lEConfig, string2);
                int n = this.m_tags.size();
                int n2 = 0;
                while (n2 < n) {
                    String string3 = (String)this.m_tags.elementAt(n2);
                    object = lEConfig.get(string3);
                    objectArray[n2 + 2] = object == null ? BLANK : object.toString();
                    ++n2;
                }
            } else {
                objectArray[2] = object.toString();
            }
        }
        this.addRow(objectArray);
    }

    void updateEntry(String string, LETable lETable, String string2) {
        Object object = lETable.get(string2);
        if (object == null || this.m_cols == 0) {
            return;
        }
        int n = this.getNumRows();
        int n2 = -1;
        int n3 = 0;
        while (n2 == -1 && n3 < n) {
            String string3 = (String)this.getCellItem(n3, 0);
            String string4 = (String)this.getCellItem(n3, 1);
            if (string3.equals(string) && string4.equals(string2)) {
                n2 = n3;
            }
            ++n3;
        }
        if (n2 > -1) {
            if (object instanceof LEConfig) {
                LEConfig lEConfig = (LEConfig)object;
                int n4 = this.m_tags.size();
                int n5 = 0;
                while (n5 < n4) {
                    String string5 = (String)this.m_tags.elementAt(n5);
                    object = lEConfig.get(string5);
                    if (object == null) {
                        this.setCellItem(n2, n5 + 2, BLANK);
                    } else {
                        this.setCellItem(n2, n5 + 2, object);
                    }
                    ++n5;
                }
                return;
            }
            this.setCellItem(n2, 2, object);
            return;
        }
        this.addEntry(string, lETable, string2);
    }

    synchronized void removePortMaster(LEPortMaster lEPortMaster) {
        LETable lETable = this.getTable(lEPortMaster);
        if (lETable == null) {
            return;
        }
        String string = lEPortMaster.getDescription();
        int n = this.getNumRows();
        int n2 = n - 1;
        while (n2 > -1) {
            String string2 = (String)this.getCellItem(n2, 0);
            if (string2.equals(string)) {
                String string3 = (String)this.getCellItem(n2, 1);
                Object object = lETable.get(string3);
                if (object instanceof LEConfig) {
                    ((LEConfig)object).deleteObserver(this);
                    this.m_objs.remove(object);
                }
                this.deleteRow(n2);
            }
            --n2;
        }
    }

    LETable getTable(LEPortMaster lEPortMaster) {
        LETable lETable = null;
        LEConfig lEConfig = lEPortMaster;
        int n = this.m_context.size();
        int n2 = 0;
        while (lEConfig != null && n2 < n) {
            Object object = ((LEConfig)lEConfig).get((String)this.m_context.elementAt(n2));
            lEConfig = object instanceof LEConfig ? (LEConfig)object : null;
            ++n2;
        }
        if (lEConfig instanceof LETable) {
            lETable = (LETable)lEConfig;
        }
        return lETable;
    }

    LEVector determinePMs(String string) {
        LEVector lEVector = new LEVector();
        String string2 = null;
        int n = 0;
        while (n < this.m_pms.length) {
            LETable lETable = this.getTable(this.m_pms[n]);
            if (lETable != null) {
                lEVector.addElement(this.m_pms[n]);
                if (string2 == null) {
                    LEDataSpec lEDataSpec = lETable.getSpecFor("entry");
                    string2 = lEDataSpec.getDescription();
                }
            }
            ++n;
        }
        int n2 = lEVector.size();
        if (n2 > 1) {
            Component[][] componentArray = new Component[n2][2];
            componentArray[0][0] = new Label(String.valueOf(string) + " " + string2 + " to:");
            componentArray[0][0].setFont(LEFont.getBoldFont());
            int n3 = 0;
            while (n3 < n2) {
                componentArray[n3][1] = new Checkbox(((LEPortMaster)lEVector.elementAt(n3)).getDescription(), true, null);
                ++n3;
            }
            LEAddDialog lEAddDialog = new LEAddDialog(LEUiUtils.GetBaseFrame(), String.valueOf(string) + " " + string2, new LECompGrid(componentArray, 2, false));
            if (lEAddDialog.okay()) {
                int n4 = n2 - 1;
                while (n4 > -1) {
                    if (!((Checkbox)componentArray[n4][1]).getState()) {
                        lEVector.removeElementAt(n4);
                    }
                    --n4;
                }
                if (lEVector.size() == 0) {
                    lEVector = null;
                }
            } else {
                lEVector = null;
            }
        } else if (n2 == 0) {
            lEVector = null;
        }
        return lEVector;
    }

    void pasteTo(LEPortMaster lEPortMaster, Object object) {
        if (object instanceof LEVector) {
            LEVector lEVector = (LEVector)object;
            int n = lEVector.size();
            int n2 = 0;
            while (n2 < n) {
                this.pasteEntryTo(lEPortMaster, lEVector.elementAt(n2));
                ++n2;
            }
            return;
        }
        this.pasteEntryTo(lEPortMaster, object);
    }

    void pasteEntryTo(LEPortMaster lEPortMaster, Object object) {
        String string = this.getPasteKey(lEPortMaster, object);
        if (string == null) {
            return;
        }
        LETable lETable = this.getTable(lEPortMaster);
        Object object2 = lETable.get(string);
        if (object2 instanceof LEConfig) {
            LEConfig lEConfig = (LEConfig)object;
            LEConfig lEConfig2 = (LEConfig)object2;
            lEConfig2.copy(lEConfig);
            lEConfig2.setConnectionFacade(lEPortMaster.getConnectionFacade());
            LEVector lEVector = lEConfig2.saveChanges();
            if (lEVector != null) {
                new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), lEPortMaster.getConnectionFacade(), lEVector);
            }
        }
        this.updateEntry(lEPortMaster.getDescription(), lETable, string);
    }

    void refillTable() {
        int n = 0;
        while (n < this.m_pms.length) {
            this.removePortMaster(this.m_pms[n]);
            ++n;
        }
        int n2 = 0;
        while (n2 < this.m_pms.length) {
            this.addPortMaster(this.m_pms[n2]);
            ++n2;
        }
    }

    String getPasteKey(LEPortMaster lEPortMaster, Object object) {
        return null;
    }

    boolean addNewEntry(LEDataSpec lEDataSpec, LEDataSpec lEDataSpec2) {
        return false;
    }

    LENewEntry addNewEntryTo(LEPortMaster lEPortMaster) {
        return null;
    }

    void delete(LEPortMaster lEPortMaster, LETable lETable, String string) {
    }

    String renameEntry(LEPortMaster lEPortMaster, LETable lETable, String string) {
        return null;
    }

    static String GetUniqueKey(LETable lETable, String string, int n) {
        boolean bl = false;
        int n2 = 1;
        String string2 = string;
        while (!bl) {
            String string3 = Integer.toString(n2);
            if (string.length() + string3.length() > n) {
                string = string.substring(0, n - string3.length());
            }
            if (lETable.get(string2 = String.valueOf(string) + string3) == null) {
                bl = true;
                continue;
            }
            ++n2;
        }
        return string2;
    }
}

