/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.lwAWT;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.ItemSelectable;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import oracle.ewt.dataSource.EmptyOneDDataSource;
import oracle.ewt.dataSource.OneDDataSource;
import oracle.ewt.dataSource.OneDDataSourceEvent;
import oracle.ewt.dataSource.OneDDataSourceListener;
import oracle.ewt.event.ListenerManager;
import oracle.ewt.graphics.GraphicUtils;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.lwAWT.LWScrollbar;

public class LWDataSourceList
extends LWComponent
implements ItemSelectable {
    private static String _sDefaultName = null;
    private static int _sInstanceCounter;
    private static final int _DEFAULT_VISIBLE_ROWS = 4;
    private static final int _HINSET = 10;
    private OneDDataSource _dataSource;
    private DSCheck _dsListener;
    private int _rows;
    private boolean _multipleMode;
    int[] _selection = new int[1];
    int _selectCount;
    private int _visibleIndex;
    int _firstVisibleIndex;
    int _focusItem;
    private ListenerManager _iListenerManager;
    private ListenerManager _aListenerManager;
    private LWScrollbar _scrollBar;
    private int _scrollBarWidth;
    private boolean _scrollBarAdded;
    private boolean _focusTraversable = true;
    private int _anchorItem;
    private int _actionItem;

    public LWDataSourceList() {
        this(null, 4, false);
    }

    public LWDataSourceList(OneDDataSource oneDDataSource) {
        this(oneDDataSource, 4, false);
    }

    public LWDataSourceList(int n) {
        this(null, n, false);
    }

    public LWDataSourceList(OneDDataSource oneDDataSource, int n, boolean bl) {
        if (oneDDataSource == null) {
            oneDDataSource = EmptyOneDDataSource.getOneDDataSource();
        }
        this._init();
        this._dataSource = oneDDataSource;
        this._rows = n != 0 ? n : 4;
        this._multipleMode = bl;
        long l = 60L;
        this.enableEvents(l);
        this.setLayout(null);
        this._dsListener = new DSCheck();
        this._dataSource.addDataSourceListener(this._dsListener);
        this.setBackground(Color.white);
    }

    public OneDDataSource getDataSource() {
        return this._dataSource;
    }

    public void setDataSource(OneDDataSource oneDDataSource) {
        OneDDataSource oneDDataSource2 = this.getDataSource();
        if (oneDDataSource == null) {
            oneDDataSource = EmptyOneDDataSource.getOneDDataSource();
        }
        if (oneDDataSource != oneDDataSource2) {
            oneDDataSource2.removeDataSourceListener(this._dsListener);
            this._dataSource = oneDDataSource;
            this._init();
            this._getScrollbar().setValue(0);
            this._dataSource.addDataSourceListener(this._dsListener);
            this.repaint();
        }
    }

    public int getItemCount() {
        return this.getDataSource().getItemCount();
    }

    public String getItem(int n) {
        if (n < 0 || n >= this.getItemCount()) {
            throw new IllegalArgumentException("index " + n + " is not valid.");
        }
        Object object = this.getDataSource().getData(n);
        if (object != null) {
            return object.toString();
        }
        return null;
    }

    public synchronized String[] getItems() {
        int n = this.getItemCount();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = this.getItem(n2);
            ++n2;
        }
        return stringArray;
    }

    public synchronized int getSelectedIndex() {
        if (this._selectCount == 0) {
            return -1;
        }
        return this._selection[this._selectCount - 1];
    }

    public synchronized int[] getSelectedIndexes() {
        int[] nArray = new int[this._selectCount];
        if (this._selectCount != 0) {
            System.arraycopy(this._selection, 0, nArray, 0, this._selectCount);
        }
        return nArray;
    }

    public synchronized String getSelectedItem() {
        int n = this.getSelectedIndex();
        if (n < 0) {
            return null;
        }
        return this.getItem(n);
    }

    public synchronized String[] getSelectedItems() {
        int[] nArray = this.getSelectedIndexes();
        String[] stringArray = new String[nArray.length];
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = this.getItem(nArray[n2]);
            ++n2;
        }
        return stringArray;
    }

    public Object[] getSelectedObjects() {
        return this.getSelectedItems();
    }

    public synchronized void select(int n) {
        if (n < 0 || n >= this.getItemCount()) {
            throw new IllegalArgumentException("index " + n + " is not valid.");
        }
        if (this.isIndexSelected(n)) {
            return;
        }
        if (!this.isMultipleMode()) {
            int n2 = -1;
            if (this._selectCount != 0) {
                n2 = this._selection[0];
            }
            this._selection[0] = n;
            this._selectCount = 1;
            if (n2 != -1) {
                this._repaintItem(n2);
            }
            this._setFocusItem(n);
        } else {
            if (this._selection.length == this._selectCount) {
                int[] nArray = new int[this._selection.length * 2];
                System.arraycopy(this._selection, 0, nArray, 0, this._selection.length);
                this._selection = nArray;
            }
            this._selection[this._selectCount] = n;
            ++this._selectCount;
        }
        if (this._focusItem == -1) {
            this._focusItem = n;
        }
        this._repaintItem(n);
        this.makeVisible(n);
    }

    public synchronized void deselect(int n) {
        if (n < 0 || n >= this.getItemCount()) {
            throw new IllegalArgumentException("index " + n + " is not valid.");
        }
        if (!this.isIndexSelected(n)) {
            return;
        }
        int n2 = 0;
        while (n2 < this._selectCount) {
            if (this._selection[n2] == n) {
                if (n2 != 0) {
                    System.arraycopy(this._selection, 0, this._selection, 0, n2);
                }
                if (n2 != this._selectCount - 1) {
                    System.arraycopy(this._selection, n2 + 1, this._selection, n2, this._selectCount - (n2 + 1));
                }
            }
            ++n2;
        }
        --this._selectCount;
        this._repaintItem(n);
    }

    public boolean isIndexSelected(int n) {
        if (this._selectCount == 0) {
            return false;
        }
        int n2 = 0;
        while (n2 < this._selectCount) {
            if (this._selection[n2] == n) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public int getRows() {
        return this._rows;
    }

    public boolean isMultipleMode() {
        return this._multipleMode;
    }

    public synchronized void setMultipleMode(boolean bl) {
        if (bl == this.isMultipleMode()) {
            return;
        }
        this._multipleMode = bl;
        if (!bl && this._selectCount > 1) {
            this._selectCount = 1;
            this._repaintList();
        }
    }

    public int getVisibleIndex() {
        return this._visibleIndex;
    }

    public synchronized void makeVisible(int n) {
        int n2 = this.getItemCount();
        if (n < 0 || n >= n2) {
            throw new IllegalArgumentException("index " + n + " is not valid.");
        }
        this._visibleIndex = n;
        int n3 = -1;
        int n4 = this._getRows();
        if (n4 == 0) {
            return;
        }
        if (n < this._firstVisibleIndex) {
            n3 = n;
        } else if (n >= this._firstVisibleIndex + n4) {
            n3 = n - n4 + 1;
        } else if (this._firstVisibleIndex + n4 > n2 && (n3 = n2 - n4) < 0) {
            n3 = 0;
        }
        if (n3 != -1) {
            this._firstVisibleIndex = n3;
            this._repaintList();
        }
        this._getScrollbar().setValue(this._firstVisibleIndex);
    }

    public Dimension getPreferredSize(int n) {
        Dimension dimension = new Dimension();
        Font font = this.getFont();
        if (font != null) {
            FontMetrics fontMetrics = this.getFontMetrics(font);
            dimension.height = this._getRowHeight() * n;
            int n2 = 0;
            int n3 = this.getItemCount();
            dimension.width = fontMetrics.stringWidth("e");
            int n4 = 0;
            while (n4 < n3) {
                n2 = fontMetrics.stringWidth(this.getItem(n4));
                if (n2 > dimension.width) {
                    dimension.width = n2;
                }
                ++n4;
            }
            dimension.width += 10;
            dimension.width += this._getScrollbar().getPreferredSize().width;
        }
        return dimension;
    }

    public Dimension getPreferredSize() {
        return this.getPreferredSize(this.getRows());
    }

    public Dimension getMinimumSize(int n) {
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        int n;
        Dimension dimension = this._getScrollbar().getMinimumSize();
        int n2 = this._getRowHeight();
        if (n2 == 0) {
            n2 = 15;
        }
        if (dimension.height < n2) {
            dimension.height = n2;
        }
        if (dimension.height > (n = this.getItemCount()) * n2) {
            dimension.height = n * n2;
        }
        dimension.width += 10;
        return dimension;
    }

    public synchronized void addItemListener(ItemListener itemListener) {
        if (this._iListenerManager == null) {
            this._iListenerManager = new ListenerManager();
        }
        this._iListenerManager.addListener(itemListener);
    }

    public synchronized void removeItemListener(ItemListener itemListener) {
        if (this._iListenerManager != null) {
            this._iListenerManager.removeListener(itemListener);
        }
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        if (this._aListenerManager == null) {
            this._aListenerManager = new ListenerManager();
        }
        this._aListenerManager.addListener(actionListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        if (this._aListenerManager != null) {
            this._aListenerManager.removeListener(actionListener);
        }
    }

    public void doLayout() {
        Dimension dimension = this.getSize();
        if (dimension.height >= this._getRowHeight() * this.getItemCount()) {
            this._scrollBarWidth = 0;
            this._getScrollbar().setVisible(false);
            return;
        }
        if (!this._scrollBarAdded) {
            this.add(this._getScrollbar());
            this._scrollBarAdded = true;
        }
        this._scrollBarWidth = this._scrollBar.getPreferredSize().width;
        this._scrollBar.setBounds(dimension.width - this._scrollBarWidth, 0, this._scrollBarWidth, dimension.height);
        this._scrollBar.setVisible(true);
        this._configureScrollbar();
    }

    public synchronized void removeAll() {
        this._init();
        this._getScrollbar().setValue(0);
        this._repaintList();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.invalidate();
        this.repaint();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this._getScrollbar().setEnabled(bl);
        this.repaint();
    }

    public boolean isFocusTraversable() {
        return this._focusTraversable;
    }

    public void paintInterior(Graphics graphics) {
        Dimension dimension = this.getSize();
        int n = dimension.width - this._scrollBarWidth;
        int n2 = this.getItemCount();
        int n3 = this._getRowHeight();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n4 = 1 + fontMetrics.getLeading() + fontMetrics.getAscent();
        int n5 = 2;
        int n6 = 0;
        Color color = this.isEnabled() ? graphics.getColor() : SystemColor.textInactiveText;
        int n7 = this._firstVisibleIndex;
        while (n7 < n2) {
            if (this.isIndexSelected(n7)) {
                graphics.setColor(SystemColor.textHighlight);
                graphics.fillRect(1, n6, n, n3);
                graphics.setColor(SystemColor.textHighlightText);
            } else {
                graphics.setColor(color);
            }
            graphics.drawString(this.getItem(n7), n5, n6 + n4);
            if ((n6 += n3) > dimension.height) break;
            ++n7;
        }
        if (this.hasFocus() && this._focusItem != -1) {
            if (this.isIndexSelected(this._focusItem)) {
                graphics.setColor(Color.yellow);
            } else {
                graphics.setColor(Color.black);
            }
            n6 = (this._focusItem - this._firstVisibleIndex) * n3;
            GraphicUtils.drawFocusRect(graphics, 1, n6, n - 2, n3 - 1);
        }
        graphics.setColor(Color.black);
        graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
    }

    protected void processEventImpl(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ItemEvent) {
            this.processItemEvent((ItemEvent)aWTEvent);
            return;
        }
        if (aWTEvent instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)aWTEvent);
            return;
        }
        super.processEventImpl(aWTEvent);
    }

    protected void processItemEvent(ItemEvent itemEvent) {
        if (this._iListenerManager == null) {
            return;
        }
        Enumeration enumeration = this._iListenerManager.getListeners();
        while (enumeration.hasMoreElements()) {
            ((ItemListener)enumeration.nextElement()).itemStateChanged(itemEvent);
        }
    }

    protected void processActionEvent(ActionEvent actionEvent) {
        if (this._aListenerManager == null) {
            return;
        }
        Enumeration enumeration = this._aListenerManager.getListeners();
        while (enumeration.hasMoreElements()) {
            ((ActionListener)enumeration.nextElement()).actionPerformed(actionEvent);
        }
    }

    protected String paramString() {
        return String.valueOf(super.paramString()) + ",selected=" + this.getSelectedItem();
    }

    protected String getDefaultName() {
        if (_sDefaultName == null) {
            _sDefaultName = this.getBaseClassName();
        }
        return String.valueOf(_sDefaultName) + _sInstanceCounter++;
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        if (mouseEvent.isConsumed() || !this.isEnabled() || this.getItemCount() == 0) {
            return;
        }
        int n = mouseEvent.getModifiers();
        if ((n & 0x10) == 0) {
            return;
        }
        int n2 = mouseEvent.getID();
        if (n2 == 501) {
            this._processMousePressed(mouseEvent);
            return;
        }
        if (n2 == 502) {
            this._processMouseReleased(mouseEvent);
        }
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        super.processMouseMotionEvent(mouseEvent);
        if (mouseEvent.isConsumed() || !this.isEnabled()) {
            return;
        }
        int n = mouseEvent.getModifiers();
        if ((n & 4) != 0) {
            return;
        }
        int n2 = mouseEvent.getID();
        if (n2 == 506) {
            this._processMouseDragged(mouseEvent);
        }
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
        if (keyEvent.isConsumed() || !this.isEnabled()) {
            return;
        }
        if (keyEvent.getID() == 401) {
            this._processKeyPressed(keyEvent);
        }
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        if (this._focusItem == -1 && this.getItemCount() != 0) {
            this._focusItem = 0;
        }
        this._repaintItem(this._focusItem);
    }

    void setFocusTraversable(boolean bl) {
        this._focusTraversable = bl;
    }

    int getItemAt(int n) {
        int n2 = this._getRowHeight();
        int n3 = this.getItemCount();
        int n4 = n + this._firstVisibleIndex * n2;
        int n5 = n4 / n2;
        if (n5 < 0) {
            n5 = -1;
        } else if (n5 >= n3) {
            n5 = n3 - 1;
        }
        return n5;
    }

    void _scrollToTop(int n) {
        this._firstVisibleIndex = n;
        this._repaintList();
    }

    void _repaintList() {
        Dimension dimension = this.getSize();
        int n = this._getScrollbar().isVisible() ? dimension.width - this._scrollBarWidth : dimension.width;
        this.paintImmediate(0, 0, n, dimension.height);
    }

    int _getRows() {
        int n = this._getRowHeight();
        if (n == 0) {
            return 0;
        }
        return this.getSize().height / n;
    }

    boolean _isIndexOnScreen(int n) {
        return n >= this._firstVisibleIndex && n <= this._firstVisibleIndex + this._getRows();
    }

    void _configureScrollbar() {
        int n = this.getItemCount();
        int n2 = this._getRowHeight() * n;
        int n3 = 0;
        if (n2 != 0) {
            boolean bl;
            Dimension dimension = this.getSize();
            n3 = n * dimension.height / n2;
            boolean bl2 = bl = n2 > dimension.height;
            if (bl && !this._scrollBarAdded) {
                this.doLayout();
                this.repaint();
                this._getScrollbar().doLayout();
                this._getScrollbar().repaint();
                return;
            }
            this._getScrollbar().setVisible(bl);
            LWScrollbar lWScrollbar = this._getScrollbar();
            lWScrollbar.setMaximum(n);
            lWScrollbar.setVisibleAmount(n3);
            int n4 = n3 > 1 ? n3 - 1 : 1;
            lWScrollbar.setBlockIncrement(n4);
        }
    }

    void _setFirstVisibleIndex(int n) {
        this._firstVisibleIndex = n;
        this._getScrollbar().setValue(this._firstVisibleIndex);
    }

    void _updateSelection() {
        int n = this._selectCount;
        int n2 = 0;
        while (n2 < this._selectCount) {
            if (this._selection[n2] == -1) {
                if (n2 != 0) {
                    System.arraycopy(this._selection, 0, this._selection, 0, n2);
                }
                if (n2 != this._selectCount - 1) {
                    System.arraycopy(this._selection, n2 + 1, this._selection, n2, this._selectCount - (n2 + 1));
                }
                --n;
            }
            ++n2;
        }
        this._selectCount = n;
    }

    private void _repaintItem(int n) {
        if (!this._isIndexOnScreen(n)) {
            return;
        }
        int n2 = this._getRowHeight();
        Dimension dimension = this.getSize();
        int n3 = this._getScrollbar().isVisible() ? dimension.width - this._scrollBarWidth : dimension.width;
        this.paintImmediate(1, n2 * (n - this._firstVisibleIndex), n3, n2);
    }

    private void _selectItem(int n) {
        int n2 = this.getSelectedIndex();
        if (n2 == n) {
            return;
        }
        if (n2 != -1) {
            this.deselect(n2);
            this._postItemEvent(this.getItem(n2), 2);
        }
        this.select(n);
        this._postItemEvent(this.getItem(n), 1);
    }

    private void _postActionEvent(String string, MouseEvent mouseEvent) {
        int n = 0;
        if (mouseEvent.isControlDown()) {
            n |= 2;
        }
        if (mouseEvent.isShiftDown()) {
            n |= 1;
        }
        if (mouseEvent.isMetaDown()) {
            n |= 4;
        }
        if (mouseEvent.isAltDown()) {
            n |= 8;
        }
        ActionEvent actionEvent = new ActionEvent(this, 1001, string, n);
        this.processEvent(actionEvent);
    }

    private void _postItemEvent(String string, int n) {
        ItemEvent itemEvent = new ItemEvent(this, 701, string, n);
        this.processEvent(itemEvent);
    }

    private int _getRowHeight() {
        Font font = this.getFont();
        int n = 0;
        if (font != null) {
            FontMetrics fontMetrics = this.getFontMetrics(font);
            n = fontMetrics.getHeight() + 2;
        }
        return n;
    }

    private void _processKeyPressed(KeyEvent keyEvent) {
        int n = this.getItemCount();
        if (n == 0) {
            return;
        }
        int n2 = this._focusItem;
        int n3 = -1;
        int n4 = this._getRows();
        int n5 = n - 1;
        switch (keyEvent.getKeyCode()) {
            case 32: {
                if (this.isMultipleMode() && this._focusItem != -1) {
                    if (!this.isIndexSelected(this._focusItem)) {
                        this.select(this._focusItem);
                        this._postItemEvent(this.getItem(this._focusItem), 1);
                        return;
                    }
                    this.deselect(this._focusItem);
                    this._postItemEvent(this.getItem(this._focusItem), 2);
                }
                return;
            }
            case 37: 
            case 38: {
                if (n2 == -1) {
                    n3 = 0;
                    break;
                }
                if (n2 == 0) break;
                n3 = n2 - 1;
                break;
            }
            case 39: 
            case 40: {
                if (n2 == -1) {
                    n3 = 0;
                    break;
                }
                if (n2 == n5) break;
                n3 = n2 + 1;
                break;
            }
            case 33: {
                if (n2 == -1) {
                    n3 = 0;
                    break;
                }
                if (n2 == 0 || (n3 = n2 - n4) >= 0) break;
                n3 = 0;
                break;
            }
            case 34: {
                if (n2 == -1) {
                    n3 = 0;
                    break;
                }
                if (n2 == n5 || (n3 = n2 + n4) <= n5) break;
                n3 = n5;
                break;
            }
            case 36: {
                if (n2 == 0) break;
                n3 = 0;
                break;
            }
            case 35: {
                if (n2 == n5) break;
                n3 = n5;
                break;
            }
            default: {
                return;
            }
        }
        if (n3 != -1) {
            this.freezeRepaints();
            this.makeVisible(n3);
            this._setFocusItem(n3);
            if (!this.isMultipleMode()) {
                this._selectItem(n3);
            }
            this.unfreezeRepaints();
        }
        keyEvent.consume();
    }

    private void _processMousePressed(MouseEvent mouseEvent) {
        int n;
        if (this.isFocusTraversable()) {
            this.requestFocus();
        }
        if ((n = this.getItemAt(mouseEvent.getY())) == -1) {
            return;
        }
        mouseEvent.consume();
        int n2 = mouseEvent.getClickCount();
        if (n2 == 1) {
            this._actionItem = n;
        } else {
            n = this._actionItem;
        }
        String string = this.getItem(n);
        this.freezeRepaints();
        if (!this.isMultipleMode()) {
            this._anchorItem = this.getSelectedIndex();
            if (this._anchorItem == -1) {
                this._anchorItem = n;
            }
            this.select(n);
        } else if (this.isIndexSelected(n)) {
            if (n2 == 1) {
                this.deselect(n);
                this._postItemEvent(string, 2);
            }
        } else {
            this.select(n);
            this._postItemEvent(string, 1);
        }
        this.makeVisible(n);
        this._setFocusItem(n);
        if (n2 > 1) {
            this._postActionEvent(string, mouseEvent);
        }
        this.unfreezeRepaints();
    }

    private void _processMouseDragged(MouseEvent mouseEvent) {
        int n = this.getItemAt(mouseEvent.getY());
        if (n == -1) {
            return;
        }
        this.freezeRepaints();
        this.makeVisible(n);
        this._setFocusItem(n);
        if (!this.isMultipleMode()) {
            this.select(n);
        }
        this.unfreezeRepaints();
        mouseEvent.consume();
    }

    private void _processMouseReleased(MouseEvent mouseEvent) {
        int n = this.getSelectedIndex();
        if (this._anchorItem == -1 || n == -1) {
            return;
        }
        if (n != this._anchorItem) {
            this._postItemEvent(this.getItem(this._anchorItem), 2);
        }
        if (mouseEvent.getClickCount() == 1) {
            this._postItemEvent(this.getItem(n), 1);
        }
        this._anchorItem = -1;
        mouseEvent.consume();
    }

    private void _setFocusItem(int n) {
        if (this._focusItem == n) {
            return;
        }
        int n2 = this._focusItem;
        this._focusItem = n;
        if (n2 != -1) {
            this._repaintItem(n2);
        }
        this._repaintItem(this._focusItem);
    }

    private LWScrollbar _getScrollbar() {
        if (this._scrollBar == null) {
            this._scrollBar = new LWScrollbar(1);
            this._scrollBar.setUnitIncrement(1);
            this._scrollBar.setMinimum(0);
            this._scrollBar.addAdjustmentListener(new Adjust());
        }
        return this._scrollBar;
    }

    private void _init() {
        this._anchorItem = -1;
        this._actionItem = -1;
        this._focusItem = -1;
        this._firstVisibleIndex = 0;
        this._visibleIndex = -1;
        this._selectCount = 0;
    }

    private class Adjust
    implements AdjustmentListener {
        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            if (LWDataSourceList.this.hasFocus() && LWDataSourceList.this.isFocusTraversable()) {
                LWDataSourceList.this.requestFocus();
            }
            LWDataSourceList.this._scrollToTop(adjustmentEvent.getValue());
        }

        Adjust() {
            LWDataSourceList.this = LWDataSourceList.this;
        }
    }

    private class DSCheck
    implements OneDDataSourceListener {
        public void itemsAdded(OneDDataSourceEvent oneDDataSourceEvent) {
            int n = oneDDataSourceEvent.getStartIndex();
            int n2 = oneDDataSourceEvent.getItemCount();
            int n3 = 0;
            while (n3 < LWDataSourceList.this._selectCount) {
                int n4 = LWDataSourceList.this._selection[n3];
                if (n4 >= n) {
                    LWDataSourceList.this._selection[n3] = n4 + n2;
                }
                ++n3;
            }
            if (LWDataSourceList.this._focusItem >= n) {
                LWDataSourceList.this._focusItem += n2;
            }
            LWDataSourceList.this._repaintList();
            LWDataSourceList.this._configureScrollbar();
        }

        public void itemsRemoved(OneDDataSourceEvent oneDDataSourceEvent) {
            int n = oneDDataSourceEvent.getStartIndex();
            int n2 = oneDDataSourceEvent.getItemCount();
            int n3 = n + n2 - 1;
            int n4 = 0;
            while (n4 < LWDataSourceList.this._selectCount) {
                int n5 = LWDataSourceList.this._selection[n4];
                if (n5 > n3) {
                    LWDataSourceList.this._selection[n4] = n5 - n2;
                } else if (n5 >= n && n5 <= n3) {
                    LWDataSourceList.this._selection[n4] = -1;
                }
                ++n4;
            }
            LWDataSourceList.this._updateSelection();
            if (LWDataSourceList.this._focusItem > n3) {
                LWDataSourceList.this._focusItem -= n2;
            } else if (LWDataSourceList.this._focusItem >= n && LWDataSourceList.this._focusItem <= n3) {
                LWDataSourceList.this._focusItem = -1;
            }
            if (LWDataSourceList.this._firstVisibleIndex > n3) {
                LWDataSourceList.this._setFirstVisibleIndex(Math.min(0, LWDataSourceList.this._firstVisibleIndex - n2));
            } else if (LWDataSourceList.this._firstVisibleIndex >= n && LWDataSourceList.this._firstVisibleIndex <= n3) {
                LWDataSourceList.this._setFirstVisibleIndex(0);
            }
            LWDataSourceList.this._repaintList();
            LWDataSourceList.this._configureScrollbar();
        }

        public void invalidateItems(OneDDataSourceEvent oneDDataSourceEvent) {
            int n = oneDDataSourceEvent.getStartIndex();
            int n2 = n + oneDDataSourceEvent.getItemCount();
            int n3 = LWDataSourceList.this._getRows();
            int n4 = LWDataSourceList.this._firstVisibleIndex + n3;
            if (n >= LWDataSourceList.this._firstVisibleIndex && n <= n4 || n2 >= LWDataSourceList.this._firstVisibleIndex && n2 <= n4 || n <= LWDataSourceList.this._firstVisibleIndex && n2 >= n4) {
                LWDataSourceList.this.repaint();
            }
        }

        DSCheck() {
            LWDataSourceList.this = LWDataSourceList.this;
        }
    }
}

