/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.backend;

import com.lucent.ra.nms.backend.LEDSSFlatFile_R;
import com.lucent.ra.nms.util.LEAppInfo;
import com.lucent.ra.nms.util.LECipher;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEResourceID;
import com.lucent.ra.nms.util.LEVector;
import com.oroinc.text.regex.MatchResult;
import com.oroinc.text.regex.Pattern;
import com.oroinc.text.regex.Perl5Compiler;
import com.oroinc.text.regex.Perl5Matcher;
import com.oroinc.text.regex.Perl5Pattern;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.text.DateFormat;
import java.util.Date;

public class LEDSSFlatFile_RI
extends UnicastRemoteObject
implements LEDSSFlatFile_R {
    protected static final String PASSWORD_KEY = "## PASS_ENC ";
    private static final String PASSWORD = "password";
    private static final String USER_PASSWORD = "set\\s+user\\s+\\w*\\s+password\\s+(\\S+)";
    private static final String LOC_PASSWORD = "set\\s+location\\s+\\w*\\s+password\\s+(\\S+)";
    private static final String RADIUS_SECRET = "set\\s+secret\\s+(\\S+)";
    private static final String CHOICENET_SECRET = "set\\s+choicenet-secret\\s+(\\S+)";
    private static final String RIP_PASSWORD = "set\\s+rip-password\\s+\\\"([a-zA-Z _0-9]*)\\\"";
    private static final String REV_RIP_PASSWORD = "set\\s+rip-password\\s+\\\"(\\S*)\\\"";
    private static final String OSPF_MD5SECRET = "set\\s+ospf area\\s+\\d{1,3}.\\d{1,3}.\\d{1,3}.\\d{1,3}\\s+md5\\s+\\w*\\s+(\\S+)";
    private static final String OSPF_PASSWORD = "set\\s+ospf area\\s+\\d{1,3}.\\d{1,3}.\\d{1,3}.\\d{1,3}\\s+password\\s+(\\S+)";
    String m_fullpath;
    String m_id;
    BufferedReader m_reader;
    BufferedWriter m_writer;
    int m_mode;
    Perl5Matcher m_matcher;
    Perl5Pattern m_locpasswordPattern;
    Perl5Pattern m_userpasswordPattern;
    Perl5Pattern m_radiussecretPattern;
    Perl5Pattern m_choicesecretPattern;
    Perl5Pattern m_rippasswordPattern;
    Perl5Pattern m_revrippasswordPattern;
    Perl5Pattern m_ospfmd5secretPattern;
    Perl5Pattern m_ospfpasswordPattern;

    public LEDSSFlatFile_RI(String string, int n) throws RemoteException {
        this.m_fullpath = string;
        this.m_id = LEResourceID.CreateFile_ID(string);
        this.m_mode = n;
        this.m_matcher = new Perl5Matcher();
        Perl5Compiler perl5Compiler = new Perl5Compiler();
        try {
            this.m_locpasswordPattern = (Perl5Pattern)perl5Compiler.compile(LOC_PASSWORD, 1);
            this.m_userpasswordPattern = (Perl5Pattern)perl5Compiler.compile(USER_PASSWORD, 1);
            this.m_radiussecretPattern = (Perl5Pattern)perl5Compiler.compile(RADIUS_SECRET, 1);
            this.m_choicesecretPattern = (Perl5Pattern)perl5Compiler.compile(CHOICENET_SECRET, 1);
            this.m_rippasswordPattern = (Perl5Pattern)perl5Compiler.compile(RIP_PASSWORD, 1);
            this.m_revrippasswordPattern = (Perl5Pattern)perl5Compiler.compile(REV_RIP_PASSWORD, 1);
            this.m_ospfmd5secretPattern = (Perl5Pattern)perl5Compiler.compile(OSPF_MD5SECRET, 1);
            this.m_ospfpasswordPattern = (Perl5Pattern)perl5Compiler.compile(OSPF_PASSWORD, 1);
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return;
        }
    }

    public String getResourceID() throws RemoteException {
        return this.m_id;
    }

    public void writeHeader() throws RemoteException {
        if (this.m_writer == null) {
            return;
        }
        PrintWriter printWriter = new PrintWriter(this.m_writer);
        printWriter.println('#');
        printWriter.println("# PortMaster Configuration File");
        printWriter.println('#');
        printWriter.print("# This file was generated by: ");
        printWriter.print(LEAppInfo.getAppName());
        printWriter.print(" v");
        printWriter.println(LEAppInfo.getAppVersion());
        printWriter.print("# ");
        Date date = new Date();
        DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 1);
        printWriter.println(dateFormat.format(date));
        printWriter.println('#');
        printWriter.println("# NOTE: User passwords, RADIUS and ChoiceNet secrets");
        printWriter.println("#       are encrypted and saved if allowed by user.");
        printWriter.println("#       Location passwords, RIP passwords and OSPF ");
        printWriter.println("#       area passwords and secrets are encrypted.");
        printWriter.println('#');
        printWriter.println("# DO NOT EDIT");
        printWriter.println('#');
    }

    /*
     * Unable to fully structure code
     */
    public void writeComments(String var1_1) throws RemoteException {
        if (this.m_writer == null || var1_1 == null) {
            return;
        }
        var2_2 = new PrintWriter(this.m_writer);
        var3_3 = var1_1.length();
        var4_4 = 0;
        var5_5 = 0;
        ** GOTO lbl14
        {
            ++var4_4;
            do {
                if (var4_4 < var3_3 && var1_1.charAt(var4_4) != '\n') continue block0;
                var2_2.print("# ");
                var2_2.println(var1_1.substring(var5_5, var4_4++));
                var5_5 = var4_4;
lbl14:
                // 2 sources

            } while (var4_4 < var3_3);
        }
        var2_2.println('#');
        var2_2.flush();
    }

    public synchronized void writeSection(String string, LEVector lEVector) throws RemoteException {
        if (this.m_writer == null) {
            return;
        }
        PrintWriter printWriter = new PrintWriter(this.m_writer);
        printWriter.println('#');
        printWriter.print("# ");
        printWriter.println(string);
        printWriter.println('#');
        int n = 0;
        if (lEVector != null) {
            n = lEVector.size();
        }
        int n2 = 0;
        while (n2 < n) {
            this.writeCommand(printWriter, (String)lEVector.elementAt(n2));
            ++n2;
        }
        printWriter.flush();
        printWriter = null;
    }

    public synchronized void writeConfig(LEVector lEVector) throws RemoteException {
        if (this.m_writer == null || lEVector == null) {
            return;
        }
        PrintWriter printWriter = new PrintWriter(this.m_writer);
        int n = lEVector.size();
        int n2 = 0;
        while (n2 < n) {
            String string = (String)lEVector.elementAt(n2);
            this.writeCommand(printWriter, string);
            ++n2;
        }
        printWriter.flush();
        printWriter = null;
    }

    public synchronized LEVector getCommands() throws RemoteException {
        return this.loadCommands();
    }

    public boolean isConnected() throws RemoteException {
        return this.m_reader != null || this.m_writer != null;
    }

    public void disconnect() throws RemoteException {
        try {
            if (this.m_reader != null) {
                this.m_reader.close();
                this.m_reader = null;
                return;
            }
            if (this.m_writer != null) {
                this.m_writer.close();
                this.m_writer = null;
                return;
            }
        }
        catch (IOException iOException) {
            LEDebug.getLog().logln(20, iOException);
        }
    }

    public void connect() throws IOException, RemoteException {
        if (this.m_mode == 0 && this.m_reader == null) {
            if (this.m_fullpath == null) {
                throw new IOException("Null path");
            }
            File file = new File(this.m_fullpath);
            try {
                FileReader fileReader = new FileReader(file);
                this.m_reader = new BufferedReader(fileReader);
                return;
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.m_reader = null;
                String string = String.valueOf(this.m_fullpath) + " not found";
                throw new IOException(string);
            }
            catch (SecurityException securityException) {
                this.m_reader = null;
                String string = "No permission to read " + this.m_fullpath;
                throw new IOException(string);
            }
        }
        if (this.m_mode == 1 && this.m_writer == null) {
            if (this.m_fullpath == null) {
                PrintWriter printWriter = new PrintWriter(System.out, true);
                try {
                    this.m_writer = new BufferedWriter(printWriter);
                    this.writeHeader();
                    return;
                }
                catch (SecurityException securityException) {
                    this.m_writer = null;
                    String string = "No permission to write to stdout";
                    throw new IOException(string);
                }
            }
            File file = new File(this.m_fullpath);
            try {
                FileWriter fileWriter = new FileWriter(file);
                this.m_writer = new BufferedWriter(fileWriter);
                this.writeHeader();
                return;
            }
            catch (IOException iOException) {
                this.m_writer = null;
                throw iOException;
            }
            catch (SecurityException securityException) {
                this.m_writer = null;
                String string = "No permission to write to " + this.m_fullpath;
                throw new IOException(string);
            }
        }
        LEDebug.getLog().log(30, "Connect called when already connected to: ");
        LEDebug.getLog().log(30, this.m_fullpath);
    }

    protected LEVector loadCommands() {
        LEVector lEVector = new LEVector();
        try {
            String string = this.m_reader.readLine();
            while (string != null) {
                if (string.length() > 3) {
                    if (string.startsWith(PASSWORD_KEY)) {
                        string = this.convertPasswordLine(string);
                    }
                    lEVector.addElement(string);
                }
                string = this.m_reader.readLine();
            }
        }
        catch (IOException iOException) {
            LEDebug.getLog().logln(20, iOException);
        }
        return lEVector;
    }

    protected String convertPasswordLine(String string) {
        try {
            if (this.m_matcher.contains(string, (Pattern)this.m_userpasswordPattern) || this.m_matcher.contains(string, (Pattern)this.m_locpasswordPattern) || this.m_matcher.contains(string, (Pattern)this.m_radiussecretPattern) || this.m_matcher.contains(string, (Pattern)this.m_choicesecretPattern) || this.m_matcher.contains(string, (Pattern)this.m_revrippasswordPattern) || this.m_matcher.contains(string, (Pattern)this.m_ospfmd5secretPattern) || this.m_matcher.contains(string, (Pattern)this.m_ospfpasswordPattern)) {
                MatchResult matchResult = this.m_matcher.getMatch();
                int n = string.lastIndexOf(matchResult.group(1));
                String string2 = string.substring(PASSWORD_KEY.length(), n);
                String string3 = matchResult.group(1);
                if (string3.length() > 0) {
                    string2 = String.valueOf(string2) + LECipher.Decrypt(string3);
                    if (string.indexOf("rip") > 0) {
                        string2 = String.valueOf(string2) + "\"";
                    }
                    string = string2;
                }
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        return string;
    }

    protected void writeCommand(PrintWriter printWriter, String string) {
        try {
            if (this.m_matcher.contains(string, (Pattern)this.m_userpasswordPattern) || this.m_matcher.contains(string, (Pattern)this.m_locpasswordPattern) || this.m_matcher.contains(string, (Pattern)this.m_radiussecretPattern) || this.m_matcher.contains(string, (Pattern)this.m_choicesecretPattern) || this.m_matcher.contains(string, (Pattern)this.m_rippasswordPattern) || this.m_matcher.contains(string, (Pattern)this.m_ospfmd5secretPattern) || this.m_matcher.contains(string, (Pattern)this.m_ospfpasswordPattern)) {
                MatchResult matchResult = this.m_matcher.getMatch();
                String string2 = matchResult.group(1);
                if (string2.length() > 16) {
                    string = "## ERROR - Password is longer than allowed length of 16 characters and has not been saved.";
                } else {
                    int n = string.lastIndexOf(matchResult.group(1));
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(PASSWORD_KEY);
                    stringBuffer.append(string.substring(0, n));
                    stringBuffer.append(LECipher.Encrypt(string2));
                    if (string.indexOf("rip") > 0) {
                        stringBuffer.append("\"");
                    }
                    string = stringBuffer.toString();
                }
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        printWriter.println(string);
    }
}

