/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.forms;

import com.lucent.ra.nms.forms.LEFormLine;
import com.lucent.ra.nms.forms.LEFormLineEvent;
import com.lucent.ra.nms.forms.LEFormLineListener;
import com.lucent.ra.nms.model.LEDataSpec;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.ui.LETextField;
import com.lucent.ra.nms.util.LEHelpManager;
import java.awt.Dimension;
import java.awt.TextComponent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.StringTokenizer;

public class LEChannelsFormLine
extends LETextField
implements LEFormLine,
ActionListener,
MouseListener {
    public static final String DELIM = new String(" -");
    public static final char DASH = '-';
    public static final char SPACE = ' ';
    public static final int PREFERRED_SIZE = 40;
    public static final int CHANNEL_SIZE = 100;
    LEFormLineListener m_listener;
    String m_valid;
    int m_maxLen;
    int m_cols = -1;

    public LEChannelsFormLine() {
        super(100);
        this.addActionListener(this);
        this.addMouseListener(this);
    }

    public void initFormLine(LEPortMaster pm, LEDataSpec spec) {
        this.setColumns(40);
    }

    public void setValue(Object field) {
        ((TextComponent)this).setText(field.toString());
    }

    public void setListener(LEFormLineListener listener) {
        this.m_listener = listener;
    }

    public String getValue() {
        boolean rangeData = false;
        boolean prevSpace = false;
        int num = 0;
        int start = -1;
        StringTokenizer st = new StringTokenizer(this.getText(), DELIM, true);
        StringBuffer sb = new StringBuffer(100);
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            if (tok.charAt(0) == '-') {
                rangeData = true;
                continue;
            }
            if (tok.charAt(0) == ' ') {
                if (!prevSpace) {
                    sb.append(tok);
                }
                prevSpace = true;
                continue;
            }
            try {
                num = Integer.parseInt(tok);
            }
            catch (NumberFormatException numberFormatException) {
                continue;
            }
            prevSpace = false;
            if (!rangeData) {
                start = num;
                sb.append(start);
            }
            if (!rangeData) continue;
            int ix = start + 1;
            while (ix <= num) {
                sb.append(' ');
                sb.append(ix);
                ++ix;
            }
            rangeData = false;
        }
        return sb.toString();
    }

    public String getValidValues() {
        if (this.m_valid == null) {
            StringBuffer buf = new StringBuffer("Integers 1-23 for T1 or 1-32 for E1, ex 1 2 3 9 10 11 or 1-3 9-11");
            this.m_valid = buf.toString();
        }
        return this.m_valid;
    }

    public boolean equalsField(Object field) {
        if (field != null) {
            String oldVal = field.toString();
            String val = this.getValue();
            return val.equals(oldVal);
        }
        return false;
    }

    public boolean isValueValid() {
        return true;
    }

    public void actionPerformed(ActionEvent event) {
        if (this.m_listener != null) {
            LEFormLineEvent formEvent = new LEFormLineEvent(this, this.getValue());
            this.m_listener.formLineValueChanged(formEvent);
        }
    }

    public void setColumns(int cols) {
        this.m_cols = cols;
    }

    public synchronized Dimension getPreferredSize() {
        if (this.m_cols != -1) {
            return this.getPreferredSize(this.m_cols);
        }
        return super.getPreferredSize();
    }

    public void mouseClicked(MouseEvent event) {
    }

    public void mouseEntered(MouseEvent event) {
        LEHelpManager.SetHelp(this.getValidValues());
    }

    public void mouseExited(MouseEvent event) {
        LEHelpManager.SetHelp("");
    }

    public void mousePressed(MouseEvent event) {
    }

    public void mouseReleased(MouseEvent event) {
    }
}

