/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.forms;

import com.lucent.ra.nms.forms.LEConfigPanel;
import com.lucent.ra.nms.forms.LEForm;
import com.lucent.ra.nms.forms.LESaveConfigDialog;
import com.lucent.ra.nms.model.LEAttributes;
import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LEDataSpec;
import com.lucent.ra.nms.model.LEDataSpecFactory;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.ui.LECompMatrix;
import com.lucent.ra.nms.ui.LEScrollPanel;
import com.lucent.ra.nms.ui.LEStatusDialog;
import com.lucent.ra.nms.ui.LEUiUtils;
import com.lucent.ra.nms.util.LEVector;
import java.awt.Button;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Hashtable;

public class LEConfigForm
extends LEScrollPanel
implements LEForm {
    LEVector m_context;
    String m_platform;
    LEPortMaster[] m_pms;
    Hashtable m_panels = new Hashtable();
    LECompMatrix m_comps;
    ActionListener m_listener;
    LEVector m_keys = new LEVector();
    Hashtable m_tags = new Hashtable();

    public void setContext(String platform, LEVector context) {
        this.m_platform = platform;
        this.m_context = context;
    }

    public void setActionListener(ActionListener listener) {
        this.m_listener = listener;
    }

    public void setPortMasters(LEPortMaster[] pms) {
        LEConfigPanel panel;
        int i;
        boolean changed = false;
        if (this.m_pms != null) {
            i = 0;
            while (i < this.m_pms.length) {
                boolean found = false;
                int j = 0;
                while (!found && j < pms.length) {
                    if (this.m_pms[i] == pms[j] && this.getConfigFor(this.m_pms[i]) != null) {
                        found = true;
                    }
                    ++j;
                }
                if (!found && (panel = (LEConfigPanel)this.m_panels.remove(this.m_pms[i].getDescription())) != null) {
                    panel.gone();
                    changed = true;
                }
                ++i;
            }
        }
        i = 0;
        while (i < pms.length) {
            String host = pms[i].getDescription();
            LEConfig config = this.getConfigFor(pms[i]);
            panel = (LEConfigPanel)this.m_panels.get(host);
            if (config != null && panel == null) {
                this.m_panels.put(host, this.getConfigPanel(pms[i]));
                changed = true;
            } else if (config == null && panel != null) {
                this.m_panels.remove(this.m_pms[i].getDescription());
                panel.gone();
                changed = true;
            }
            ++i;
        }
        this.m_pms = pms;
        if (changed) {
            String[] rowTitles = this.getRowTitles();
            String[] colTitles = this.getColumnTitles();
            Component[][] comps = this.getFormComponents();
            this.m_comps = new LECompMatrix(rowTitles, colTitles, comps, true);
            this.setScrollable(this.m_comps);
            this.checkDependencies();
        }
    }

    public LEConfig getConfigFor(LEPortMaster pm) {
        LEConfig config = pm;
        int len = this.m_context.size();
        int i = 0;
        while (config != null && i < len) {
            Object obj = ((LEConfig)config).get((String)this.m_context.elementAt(i));
            config = obj instanceof LEConfig ? (LEConfig)obj : null;
            ++i;
        }
        return config;
    }

    public String getTagFor(Object obj) {
        return (String)this.m_tags.get(obj);
    }

    public void checkDependencies() {
        int i = 0;
        while (i < this.m_pms.length) {
            String host = this.m_pms[i].getDescription();
            LEConfigPanel panel = (LEConfigPanel)this.m_panels.get(host);
            if (panel != null) {
                panel.checkDependencies(this.m_keys);
            }
            ++i;
        }
    }

    public void save(Frame parent) {
        LEVector panels = new LEVector();
        int i = 0;
        while (i < this.m_pms.length) {
            LEConfigPanel panel = (LEConfigPanel)this.m_panels.get(this.m_pms[i].getDescription());
            if (panel != null) {
                panels.addElement(panel);
            }
            ++i;
        }
        if (panels.size() > 0) {
            new LESaveConfigDialog(parent, this.m_keys, panels);
        }
    }

    public void refresh() {
        LEStatusDialog dlg = new LEStatusDialog(LEUiUtils.GetBaseFrame());
        int i = 0;
        while (i < this.m_pms.length) {
            LEConfigPanel panel = (LEConfigPanel)this.m_panels.get(this.m_pms[i].getDescription());
            if (panel != null) {
                panel.refresh();
            }
            ++i;
        }
        dlg.hideStatus();
    }

    public void gone() {
        int i = 0;
        while (i < this.m_pms.length) {
            LEConfigPanel panel = (LEConfigPanel)this.m_panels.remove(this.m_pms[i].getDescription());
            if (panel != null) {
                panel.gone();
            }
            ++i;
        }
    }

    String[] getRowTitles() {
        int len;
        LEDataSpec spec = null;
        try {
            spec = LEDataSpecFactory.GetSpec(this.m_platform);
            len = this.m_context.size();
            int i = 0;
            while (spec != null && i < len) {
                String tag = (String)this.m_context.elementAt(i);
                spec = spec.getSpecFor(tag);
                ++i;
            }
        }
        catch (IOException iOException) {
            spec = null;
        }
        if (spec == null) {
            return new String[0];
        }
        this.m_keys.removeAllElements();
        LEVector specs = spec.getAllSpecs();
        len = specs.size();
        boolean found = false;
        LEVector des = new LEVector();
        int i = 0;
        while (i < len) {
            spec = (LEDataSpec)specs.elementAt(i);
            if (spec.getAttribute(LEAttributes.INVISIBLE) == null) {
                String tag = spec.getTag();
                found = false;
                int j = 0;
                while (!found && j < this.m_pms.length) {
                    LEConfigPanel panel = (LEConfigPanel)this.m_panels.get(this.m_pms[j].getDescription());
                    if (panel != null && panel.containsKey(tag)) {
                        this.m_keys.addElement(tag);
                        des.addElement(spec.getDescription());
                        found = true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        String[] titles = new String[des.size()];
        int i2 = 0;
        while (i2 < titles.length) {
            titles[i2] = (String)des.elementAt(i2);
            ++i2;
        }
        return titles;
    }

    String[] getColumnTitles() {
        String[] titles = new String[this.m_pms.length];
        int i = 0;
        while (i < this.m_pms.length) {
            titles[i] = this.m_pms[i].getDescription();
            ++i;
        }
        return titles;
    }

    Component[][] getFormComponents() {
        this.m_tags.clear();
        int rows = this.m_keys.size();
        Component[][] comps = new Component[rows][this.m_pms.length];
        int i = 0;
        while (i < rows) {
            String key = (String)this.m_keys.elementAt(i);
            int j = 0;
            while (j < this.m_pms.length) {
                String host = this.m_pms[j].getDescription();
                LEConfigPanel panel = (LEConfigPanel)this.m_panels.get(host);
                if (panel != null) {
                    comps[i][j] = panel.getFormComponent(key);
                    if (this.m_listener != null && comps[i][j] instanceof Button) {
                        ((Button)comps[i][j]).addActionListener(this.m_listener);
                        this.m_tags.put(comps[i][j], key);
                    }
                }
                ++j;
            }
            ++i;
        }
        return comps;
    }

    LEConfigPanel getConfigPanel(LEPortMaster pm) {
        return new LEConfigPanel(pm, this.m_context);
    }
}

