/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.forms;

import com.lucent.ra.nms.forms.LEFormLine;
import com.lucent.ra.nms.forms.LEFormLineEvent;
import com.lucent.ra.nms.forms.LEFormLineFactory;
import com.lucent.ra.nms.forms.LEFormLineListener;
import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LEDataSpec;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.util.LEObservable;
import com.lucent.ra.nms.util.LEObserver;
import com.lucent.ra.nms.util.LEVector;
import java.awt.Component;
import java.awt.Label;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class LEConfigPanel
implements LEObserver,
LEFormLineListener {
    LEPortMaster m_pm;
    LEConfig m_config;
    Hashtable m_comps = new Hashtable();

    public LEConfigPanel(LEPortMaster pm, LEVector context) {
        this.m_pm = pm;
        this.m_config = pm;
        int len = context.size();
        int i = 0;
        while (this.m_config != null && i < len) {
            Object obj = this.m_config.get((String)context.elementAt(i));
            this.m_config = obj instanceof LEConfig ? (LEConfig)obj : null;
            ++i;
        }
        if (this.m_config != null) {
            this.m_config.addObserver(this);
        }
    }

    public boolean containsKey(String key) {
        return this.m_config != null && this.m_config.get(key) != null;
    }

    public Component getFormComponent(String key) {
        Object obj;
        Component comp = null;
        if (this.m_config != null && (comp = (Component)this.m_comps.get(key)) == null && (obj = this.m_config.get(key)) != null) {
            LEDataSpec spec = this.m_config.getSpecFor(key);
            comp = LEFormLineFactory.BuildFormLine(this.m_pm, key, obj, spec);
            if (comp instanceof LEFormLine) {
                ((LEFormLine)((Object)comp)).setListener(this);
            }
            if (comp != null) {
                this.m_comps.put(key, comp);
            }
        }
        return comp;
    }

    public LEConfig getConfig() {
        return this.m_config;
    }

    public LEPortMaster getPortMaster() {
        return this.m_pm;
    }

    public void update(LEObservable obs, Object arg) {
        String key;
        Object obj;
        if (this.m_config == null) {
            return;
        }
        if (arg instanceof String && (obj = this.m_config.get(key = (String)arg)) instanceof String) {
            Component comp = (Component)this.m_comps.get(key);
            if (comp instanceof LEFormLine) {
                ((LEFormLine)((Object)comp)).setValue(obj);
            } else if (comp instanceof Label) {
                ((Label)comp).setText((String)obj);
            }
        }
    }

    public void gone() {
        if (this.m_config != null) {
            this.m_config.deleteObserver(this);
        }
    }

    public void formLineValueChanged(LEFormLineEvent event) {
        if (this.m_config == null) {
            return;
        }
        Enumeration keys = this.m_comps.keys();
        while (keys.hasMoreElements()) {
            this.checkDependencies((String)keys.nextElement());
        }
    }

    public void checkDependencies(LEVector keys) {
        if (this.m_config == null) {
            return;
        }
        int len = keys.size();
        int i = 0;
        while (i < len) {
            this.checkDependencies((String)keys.elementAt(i));
            ++i;
        }
    }

    public void refresh() {
        if (this.m_config != null) {
            this.m_config.refresh();
        }
    }

    void checkDependencies(String key) {
        Component comp = (Component)this.m_comps.get(key);
        if (!(comp instanceof LEFormLine)) {
            return;
        }
        LEDataSpec spec = this.m_config.getSpecFor(key);
        if (spec != null && spec.hasDependencies()) {
            this.checkDependencies(comp, spec);
        }
    }

    void checkDependencies(Component comp, LEDataSpec spec) {
        Hashtable attrs = spec.getAttributes();
        Enumeration keys = attrs.keys();
        boolean enable = true;
        while (enable && keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (key.length() <= 1 || key.charAt(0) != '#') continue;
            Object values = spec.getAttribute(key);
            Component indep = (Component)this.m_comps.get(key = key.substring(1));
            if (indep != null && this.checkValues(indep, values)) continue;
            enable = false;
        }
        comp.setEnabled(enable);
    }

    boolean checkValues(Component comp, Object values) {
        boolean valid = true;
        String curr = null;
        if (comp instanceof Label) {
            curr = ((Label)comp).getText();
        } else if (comp instanceof LEFormLine) {
            curr = ((LEFormLine)((Object)comp)).getValue();
        }
        if (curr != null) {
            if (values instanceof Vector) {
                Vector vals = (Vector)values;
                valid = false;
                int len = vals.size();
                int i = 0;
                while (!valid && i < len) {
                    String value = (String)vals.elementAt(i);
                    valid = curr.equals(value);
                    ++i;
                }
            } else if (values instanceof String) {
                valid = curr.equals((String)values);
            }
        }
        return valid;
    }
}

