/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.forms;

import com.lucent.ra.nms.forms.LEAddDialog;
import com.lucent.ra.nms.forms.LECmdErrorDialog;
import com.lucent.ra.nms.forms.LEFormLine;
import com.lucent.ra.nms.forms.LEFormLineFactory;
import com.lucent.ra.nms.forms.LENewEntry;
import com.lucent.ra.nms.forms.LETableForm;
import com.lucent.ra.nms.model.LEDLCI;
import com.lucent.ra.nms.model.LEDLCITable;
import com.lucent.ra.nms.model.LEDataSpec;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.model.LETable;
import com.lucent.ra.nms.ui.LECompGrid;
import com.lucent.ra.nms.ui.LEErrorDialog;
import com.lucent.ra.nms.ui.LEFont;
import com.lucent.ra.nms.ui.LEUiUtils;
import com.lucent.ra.nms.util.LEVector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Label;
import java.awt.Panel;

public class LEDLCITableForm
extends LETableForm {
    String m_number;
    String m_address;

    boolean addNewEntry(LEDataSpec keySpec, LEDataSpec entrySpec) {
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        Component[][] comps = new Component[2][2];
        comps[0][0] = new Label("DLCI Number:");
        comps[0][0].setFont(LEFont.getBoldFont());
        comps[0][1] = LEFormLineFactory.BuildFormLine(null, null, null, keySpec);
        LEDataSpec spec = entrySpec.getSpecFor("address");
        comps[1][0] = new Label(String.valueOf(spec.getDescription()) + ":");
        comps[1][0].setFont(LEFont.getBoldFont());
        comps[1][1] = LEFormLineFactory.BuildFormLine(null, null, null, spec);
        panel.add("Center", new LECompGrid(comps, 2, false));
        LEAddDialog dlg = new LEAddDialog(LEUiUtils.GetBaseFrame(), "Add DLCI", panel);
        if (dlg.okay()) {
            this.m_number = ((LEFormLine)((Object)comps[0][1])).getValue();
            this.m_address = ((LEFormLine)((Object)comps[1][1])).getValue();
            if (this.m_number.length() > 0) {
                return true;
            }
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), "A DLCI number must be specified");
        }
        return false;
    }

    LENewEntry addNewEntryTo(LEPortMaster pm) {
        LENewEntry entry = null;
        LEDLCITable table = (LEDLCITable)this.getTable(pm);
        if (table.get(this.m_number) == null) {
            LEVector errors = table.add(this.m_number, this.m_address);
            if (errors != null) {
                new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), pm.getConnectionFacade(), errors);
            }
            this.addEntry(pm.getDescription(), table, this.m_number);
            entry = new LENewEntry(pm, table, this.m_number);
        } else {
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), String.valueOf(pm.getDescription()) + " already contains a DLCI numbered " + this.m_number);
        }
        return entry;
    }

    void delete(LEPortMaster pm, LETable table, String key) {
        if (!(table instanceof LEDLCITable)) {
            return;
        }
        LEDLCITable dlci_table = (LEDLCITable)table;
        LEVector errors = dlci_table.delete(key);
        if (errors != null) {
            new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), pm.getConnectionFacade(), errors);
        }
    }

    String getPasteKey(LEPortMaster pm, Object obj) {
        String address;
        LEVector errors;
        String number;
        if (!(obj instanceof LEDLCI)) {
            return null;
        }
        LEDLCI dlci = (LEDLCI)obj;
        LEDLCITable dlci_table = (LEDLCITable)this.getTable(pm);
        if (dlci_table.get(number = dlci.getNumber()) != null) {
            number = LETableForm.GetUniqueKey(dlci_table, number, 12);
        }
        if ((errors = dlci_table.add(number, address = (String)dlci.get("address"))) != null) {
            new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), pm.getConnectionFacade(), errors);
            number = null;
        }
        return number;
    }
}

