/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.forms;

import com.lucent.ra.nms.forms.LEAddDialog;
import com.lucent.ra.nms.forms.LECmdErrorDialog;
import com.lucent.ra.nms.forms.LEForm;
import com.lucent.ra.nms.forms.LEFormLine;
import com.lucent.ra.nms.forms.LEFormLineFactory;
import com.lucent.ra.nms.forms.LENewEntry;
import com.lucent.ra.nms.model.LEDataSpec;
import com.lucent.ra.nms.model.LEHost;
import com.lucent.ra.nms.model.LEHosts;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.ui.LECompGrid;
import com.lucent.ra.nms.ui.LEErrorDialog;
import com.lucent.ra.nms.ui.LEFont;
import com.lucent.ra.nms.ui.LEOptMultiList;
import com.lucent.ra.nms.ui.LEUiUtils;
import com.lucent.ra.nms.util.LEVector;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Label;
import java.awt.Panel;

public class LEHostsForm
extends LEOptMultiList
implements LEForm {
    static final String PORTMASTER = "Device";
    static final String ADDRESS = "Address";
    static final String HOSTNAME = "Hostname";
    static final String BLANK = "";
    LEPortMaster[] m_pms;
    LEVector m_context;
    String m_platform;
    String m_addAddress;
    String m_addHostname;

    public void setContext(String platform, LEVector context) {
        this.m_platform = platform;
        this.initialize(1, 2, 1);
        String[] titles = new String[]{PORTMASTER, ADDRESS, HOSTNAME};
        this.setTitles(0, titles);
    }

    public void setPortMasters(LEPortMaster[] pms) {
        int j;
        boolean found;
        int i;
        if (this.m_pms != null) {
            i = 0;
            while (i < this.m_pms.length) {
                found = false;
                j = 0;
                while (!found && j < pms.length) {
                    if (this.m_pms[i] == pms[j]) {
                        found = true;
                    }
                    ++j;
                }
                if (!found) {
                    this.removePortMaster(this.m_pms[i]);
                }
                ++i;
            }
        }
        i = 0;
        while (i < pms.length) {
            found = false;
            if (this.m_pms != null) {
                j = 0;
                while (!found && j < this.m_pms.length) {
                    if (pms[i] == this.m_pms[j]) {
                        found = true;
                    }
                    ++j;
                }
            }
            if (!found) {
                this.addPortMaster(pms[i]);
            }
            ++i;
        }
        this.m_pms = pms;
        this.repaint();
    }

    public void refresh() {
        this.deleteAllRows();
        int i = 0;
        while (i < this.m_pms.length) {
            LEHosts hosts = (LEHosts)this.m_pms[i].get("1245184");
            if (hosts != null) {
                hosts.refresh();
                this.addPortMaster(this.m_pms[i]);
            }
            ++i;
        }
        this.repaint();
    }

    public void gone() {
    }

    public void add() {
        int count = 0;
        LEDataSpec entrySpec = null;
        int i = 0;
        while (i < this.m_pms.length) {
            LEHosts hosts = (LEHosts)this.m_pms[i].get("1245184");
            if (hosts != null) {
                ++count;
                if (entrySpec == null) {
                    entrySpec = hosts.getSpecFor("entry");
                }
            }
            ++i;
        }
        if (count == 0) {
            return;
        }
        if (!this.addNewEntry(entrySpec)) {
            return;
        }
        LEVector pms = this.determinePMs("Add");
        if (pms != null) {
            int len = pms.size();
            int i2 = 0;
            while (i2 < len) {
                this.addNewEntryTo((LEPortMaster)pms.elementAt(i2));
                ++i2;
            }
            this.repaint();
        }
    }

    public void delete() {
        int[] rows = this.getSelectedRows();
        int i = rows.length - 1;
        while (i > -1) {
            LEPortMaster pm = this.getPortMaster(rows[i]);
            String key = this.getCellString(rows[i], 1);
            this.delete(pm, key);
            --i;
        }
        this.deleteAllRows();
        int i2 = 0;
        while (i2 < this.m_pms.length) {
            this.addPortMaster(this.m_pms[i2]);
            ++i2;
        }
        this.repaint();
    }

    public void paste(Object obj) {
        LEVector pms = this.determinePMs("Paste");
        if (pms != null) {
            int len = pms.size();
            int i = 0;
            while (i < len) {
                this.pasteTo((LEPortMaster)pms.elementAt(i), obj);
                ++i;
            }
            this.repaint();
        }
    }

    public Object getEntry(int row) {
        LEHost entry = null;
        LEPortMaster pm = this.getPortMaster(row);
        if (pm != null) {
            LEHosts hosts = (LEHosts)pm.get("1245184");
            String ip = this.getCellString(row, 1);
            String name = this.getCellString(row, 2);
            if (hosts != null && ip != null && name != null) {
                entry = this.findHost(hosts, ip, name);
            }
        }
        return entry;
    }

    LEPortMaster getPortMaster(int row) {
        LEPortMaster pm = null;
        String host = this.getCellString(row, 0);
        int i = 0;
        while (pm == null && i < this.m_pms.length) {
            if (host.equals(this.m_pms[i].getDescription())) {
                pm = this.m_pms[i];
            }
            ++i;
        }
        return pm;
    }

    void addPortMaster(LEPortMaster pm) {
        LEHosts hosts = (LEHosts)pm.get("1245184");
        if (hosts != null) {
            String hostname = pm.getDescription();
            int len = hosts.length();
            int i = 0;
            while (i < len) {
                LEHost host = (LEHost)hosts.get(i);
                if (host != null) {
                    this.addEntry(hostname, host);
                }
                ++i;
            }
        }
    }

    void addEntry(String hostname, LEHost host) {
        String[] data = new String[]{hostname, (String)host.get("address"), (String)host.get("hostname")};
        this.addRow(data);
    }

    synchronized void removePortMaster(LEPortMaster pm) {
        LEHosts hosts = (LEHosts)pm.get("1245184");
        if (hosts == null) {
            return;
        }
        String host = pm.getDescription();
        int rows = this.getNumRows();
        int row = rows - 1;
        while (row > -1) {
            String data = this.getCellString(row, 0);
            if (data.equals(host)) {
                this.deleteRow(row);
            }
            --row;
        }
    }

    void delete(LEPortMaster pm, String key) {
        LEHosts hosts = (LEHosts)pm.get("1245184");
        if (hosts == null) {
            return;
        }
        LEVector errors = hosts.delete(key);
        if (errors != null) {
            new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), pm.getConnectionFacade(), errors);
        }
    }

    boolean addNewEntry(LEDataSpec entrySpec) {
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        LEDataSpec spec = entrySpec.getSpecFor("address");
        Component[][] comps = new Component[2][2];
        comps[0][0] = new Label(String.valueOf(spec.getDescription()) + ":");
        comps[0][0].setFont(LEFont.getBoldFont());
        comps[0][1] = LEFormLineFactory.BuildFormLine(null, null, null, spec);
        spec = entrySpec.getSpecFor("hostname");
        comps[1][0] = new Label(String.valueOf(spec.getDescription()) + ":");
        comps[1][0].setFont(LEFont.getBoldFont());
        comps[1][1] = LEFormLineFactory.BuildFormLine(null, null, null, spec);
        panel.add("Center", new LECompGrid(comps, 2, false));
        LEAddDialog dlg = new LEAddDialog(LEUiUtils.GetBaseFrame(), "Add Host", panel);
        if (dlg.okay()) {
            this.m_addAddress = ((LEFormLine)((Object)comps[0][1])).getValue();
            this.m_addHostname = ((LEFormLine)((Object)comps[1][1])).getValue();
            if (this.m_addHostname.length() > 0) {
                return true;
            }
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), "A hostname must be specified");
        }
        return false;
    }

    LENewEntry addNewEntryTo(LEPortMaster pm) {
        LEHosts hosts = (LEHosts)pm.get("1245184");
        LEVector errors = hosts.add(this.m_addAddress, this.m_addHostname);
        if (errors != null) {
            new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), pm.getConnectionFacade(), errors);
            this.refresh();
        } else {
            LEHost host = (LEHost)hosts.get(hosts.length() - 1);
            if (host != null) {
                this.addEntry(pm.getDescription(), host);
            }
        }
        return null;
    }

    LEVector determinePMs(String action) {
        LEVector pms = new LEVector();
        String des = null;
        int i = 0;
        while (i < this.m_pms.length) {
            LEHosts hosts = (LEHosts)this.m_pms[i].get("1245184");
            if (hosts != null) {
                pms.addElement(this.m_pms[i]);
                if (des == null) {
                    LEDataSpec spec = hosts.getSpecFor("entry");
                    des = spec.getDescription();
                }
            }
            ++i;
        }
        int count = pms.size();
        if (count > 1) {
            Component[][] comps = new Component[count][2];
            comps[0][0] = new Label(String.valueOf(action) + " " + des + " to:");
            comps[0][0].setFont(LEFont.getBoldFont());
            int i2 = 0;
            while (i2 < count) {
                comps[i2][1] = new Checkbox(((LEPortMaster)pms.elementAt(i2)).getDescription(), true, null);
                ++i2;
            }
            LEAddDialog dlg = new LEAddDialog(LEUiUtils.GetBaseFrame(), String.valueOf(action) + " " + des, new LECompGrid(comps, 2, false));
            if (dlg.okay()) {
                int i3 = count - 1;
                while (i3 > -1) {
                    if (!((Checkbox)comps[i3][1]).getState()) {
                        pms.removeElementAt(i3);
                    }
                    --i3;
                }
                if (pms.size() == 0) {
                    pms = null;
                }
            } else {
                pms = null;
            }
        } else if (count == 0) {
            pms = null;
        }
        return pms;
    }

    void pasteTo(LEPortMaster pm, Object obj) {
        if (obj instanceof LEVector) {
            LEVector vec = (LEVector)obj;
            int len = vec.size();
            int i = 0;
            while (i < len) {
                this.pasteEntryTo(pm, vec.elementAt(i));
                ++i;
            }
        } else {
            this.pasteEntryTo(pm, obj);
        }
    }

    void pasteEntryTo(LEPortMaster pm, Object obj) {
        LEHosts hosts = (LEHosts)pm.get("1245184");
        if (hosts == null) {
            return;
        }
        if (!(obj instanceof LEHost)) {
            return;
        }
        LEHost host = (LEHost)obj;
        String ip = (String)host.get("address");
        String name = (String)host.get("hostname");
        if (ip == null || name == null) {
            return;
        }
        LEHost tmpHost = this.findHost(hosts, ip, name);
        if (tmpHost != null) {
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), String.valueOf(pm.getDescription()) + " already contains an entry that matches " + ip + ", " + name);
            return;
        }
        LEVector errors = hosts.add(ip, name);
        if (errors != null) {
            new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), pm.getConnectionFacade(), errors);
            return;
        }
        host = (LEHost)hosts.get(hosts.length() - 1);
        if (host != null) {
            this.addEntry(pm.getDescription(), host);
        }
    }

    LEHost findHost(LEHosts hosts, String ip, String name) {
        LEHost host = null;
        int len = hosts.length();
        int i = 0;
        while (host == null && i < len) {
            LEHost tmpHost = (LEHost)hosts.get(i);
            String tmpIP = (String)tmpHost.get("address");
            String tmpName = (String)tmpHost.get("hostname");
            if (ip.equals(tmpIP) && name.equals(tmpName)) {
                host = tmpHost;
            }
            ++i;
        }
        return host;
    }
}

