/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.forms;

import com.lucent.ra.nms.forms.LEAddDialog;
import com.lucent.ra.nms.forms.LECmdErrorDialog;
import com.lucent.ra.nms.forms.LEFormLine;
import com.lucent.ra.nms.forms.LEFormLineFactory;
import com.lucent.ra.nms.forms.LENewEntry;
import com.lucent.ra.nms.forms.LETableForm;
import com.lucent.ra.nms.model.LEDataSpec;
import com.lucent.ra.nms.model.LEIPPool;
import com.lucent.ra.nms.model.LEIPPools;
import com.lucent.ra.nms.model.LEIPRanges;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.model.LETable;
import com.lucent.ra.nms.ui.LEErrorDialog;
import com.lucent.ra.nms.ui.LEFont;
import com.lucent.ra.nms.ui.LEUiUtils;
import com.lucent.ra.nms.util.LEVector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Label;
import java.awt.Panel;

public class LEIPPoolsForm
extends LETableForm {
    static final String PORTMASTER = "Device";
    static final String BLANK = "";
    String m_addName;

    public LEIPPoolsForm() {
        this.m_keyReadonly = false;
    }

    public void setContext(String platform, LEVector context) {
        this.m_platform = platform;
        this.m_context = context;
        this.m_cols = 2;
        this.initialize(1, 2, this.m_cols);
        String[] titles = new String[this.m_cols + 2];
        titles[0] = PORTMASTER;
        titles[1] = "IP Pool";
        titles[2] = "Range Count";
        titles[3] = "Default Gateway";
        this.setTitles(0, titles);
    }

    void addEntry(String host, LETable table, String key) {
        String[] data = new String[this.m_cols + 2];
        data[0] = host;
        data[1] = key;
        Object obj = table.get(key);
        if (obj instanceof LEIPPool) {
            LEIPPool pool = (LEIPPool)obj;
            LEIPRanges ranges = (LEIPRanges)pool.get("ranges");
            data[2] = ranges != null ? Integer.toString(ranges.size()) : BLANK;
            data[3] = (String)pool.get("75");
        }
        this.addRow(data);
    }

    boolean addNewEntry(LEDataSpec keySpec, LEDataSpec entrySpec) {
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        Label lbl = new Label("IP Pool Name:");
        lbl.setFont(LEFont.getBoldFont());
        panel.add("West", lbl);
        Component comp = LEFormLineFactory.BuildFormLine(null, null, null, keySpec);
        panel.add("Center", comp);
        LEAddDialog dlg = new LEAddDialog(LEUiUtils.GetBaseFrame(), "Add IP pool", panel);
        if (dlg.okay()) {
            this.m_addName = ((LEFormLine)((Object)comp)).getValue();
            if (this.m_addName.length() > 0) {
                return true;
            }
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), "An IP pool name must be entered");
        }
        return false;
    }

    LENewEntry addNewEntryTo(LEPortMaster pm) {
        LENewEntry entry = null;
        LETable table = this.getTable(pm);
        if (table.get(this.m_addName) == null) {
            LEVector errors = ((LEIPPools)table).add(this.m_addName);
            if (errors != null) {
                new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), pm.getConnectionFacade(), errors);
            } else {
                this.addEntry(pm.getDescription(), table, this.m_addName);
                entry = new LENewEntry(pm, table, this.m_addName);
            }
        } else {
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), String.valueOf(pm.getDescription()) + " already contains a IP pool named " + this.m_addName);
        }
        return entry;
    }

    void delete(LEPortMaster pm, LETable table, String key) {
        if (!(table instanceof LEIPPools)) {
            return;
        }
        LEIPPools pools = (LEIPPools)table;
        LEVector errors = pools.delete(key);
        if (errors != null) {
            new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), pm.getConnectionFacade(), errors);
        }
    }

    String getPasteKey(LEPortMaster pm, Object obj) {
        LEVector errors;
        String name;
        if (!(obj instanceof LEIPPool)) {
            return null;
        }
        LEIPPool pool = (LEIPPool)obj;
        LEIPPools pools = (LEIPPools)this.getTable(pm);
        if (pools.get(name = pool.getName()) != null) {
            name = LETableForm.GetUniqueKey(pools, name, 16);
        }
        if ((errors = pools.add(name)) != null) {
            new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), pm.getConnectionFacade(), errors);
            name = null;
        }
        return name;
    }
}

