/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.forms;

import com.lucent.ra.nms.forms.LEAddDialog;
import com.lucent.ra.nms.forms.LECmdErrorDialog;
import com.lucent.ra.nms.forms.LEFormLine;
import com.lucent.ra.nms.forms.LEFormLineFactory;
import com.lucent.ra.nms.forms.LENewEntry;
import com.lucent.ra.nms.forms.LETableForm;
import com.lucent.ra.nms.model.LEDataSpec;
import com.lucent.ra.nms.model.LEIPSecProfile;
import com.lucent.ra.nms.model.LEIPSecProfiles;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.model.LETable;
import com.lucent.ra.nms.ui.LEErrorDialog;
import com.lucent.ra.nms.ui.LEFont;
import com.lucent.ra.nms.ui.LEUiUtils;
import com.lucent.ra.nms.util.LEVector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Label;
import java.awt.Panel;

public class LEIPSecProfilesForm
extends LETableForm {
    static final String PORTMASTER = "Device";
    String m_addName;

    public LEIPSecProfilesForm() {
        this.m_keyReadonly = false;
    }

    public void setContext(String platform, LEVector context) {
        this.m_platform = platform;
        this.m_context = context;
        this.m_cols = 1;
        this.initialize(1, 2, this.m_cols);
        String[] titles = new String[this.m_cols + 2];
        titles[0] = PORTMASTER;
        titles[1] = "IPSec Profile";
        titles[2] = "Rule Count";
        this.setTitles(0, titles);
    }

    void addEntry(String host, LETable table, String key) {
        String[] data = new String[this.m_cols + 2];
        data[0] = host;
        data[1] = key;
        Object obj = table.get(key);
        if (obj instanceof LEIPSecProfile) {
            LEIPSecProfile prof = (LEIPSecProfile)obj;
            data[2] = Integer.toString(prof.size());
        }
        this.addRow(data);
    }

    boolean addNewEntry(LEDataSpec keySpec, LEDataSpec entrySpec) {
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        Label lbl = new Label("IPSec Profile Name:");
        lbl.setFont(LEFont.getBoldFont());
        panel.add("West", lbl);
        Component comp = LEFormLineFactory.BuildFormLine(null, null, null, keySpec);
        panel.add("Center", comp);
        LEAddDialog dlg = new LEAddDialog(LEUiUtils.GetBaseFrame(), "Add IPSec Profile", panel);
        if (dlg.okay()) {
            this.m_addName = ((LEFormLine)((Object)comp)).getValue();
            if (this.m_addName.length() > 0) {
                return true;
            }
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), "An IPSec Profile name must be entered");
        }
        return false;
    }

    LENewEntry addNewEntryTo(LEPortMaster pm) {
        LENewEntry entry = null;
        LETable table = this.getTable(pm);
        if (table.get(this.m_addName) == null) {
            LEVector errors = ((LEIPSecProfiles)table).add(this.m_addName);
            if (errors != null) {
                new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), pm.getConnectionFacade(), errors);
            } else {
                this.addEntry(pm.getDescription(), table, this.m_addName);
                entry = new LENewEntry(pm, table, this.m_addName);
            }
        } else {
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), String.valueOf(pm.getDescription()) + " already contains a IPSec Profile named " + this.m_addName);
        }
        return entry;
    }

    void delete(LEPortMaster pm, LETable table, String key) {
        if (!(table instanceof LEIPSecProfiles)) {
            return;
        }
        LEIPSecProfiles profs = (LEIPSecProfiles)table;
        LEVector errors = profs.delete(key);
        if (errors != null) {
            new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), pm.getConnectionFacade(), errors);
        }
    }

    String getPasteKey(LEPortMaster pm, Object obj) {
        LEVector errors;
        String name;
        if (!(obj instanceof LEIPSecProfile)) {
            return null;
        }
        LEIPSecProfile prof = (LEIPSecProfile)obj;
        LEIPSecProfiles profs = (LEIPSecProfiles)this.getTable(pm);
        if (profs.get(name = prof.getName()) != null) {
            name = LETableForm.GetUniqueKey(profs, name, 15);
        }
        if ((errors = profs.add(name)) != null) {
            new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), pm.getConnectionFacade(), errors);
            name = null;
        }
        return name;
    }
}

