/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.forms;

import com.lucent.ra.nms.forms.LEAddDialog;
import com.lucent.ra.nms.forms.LECmdErrorDialog;
import com.lucent.ra.nms.forms.LEFormLine;
import com.lucent.ra.nms.forms.LEFormLineFactory;
import com.lucent.ra.nms.forms.LENewEntry;
import com.lucent.ra.nms.forms.LETableForm;
import com.lucent.ra.nms.model.LEDataSpec;
import com.lucent.ra.nms.model.LELocalIPAddress;
import com.lucent.ra.nms.model.LELocalIPAddresses;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.model.LETable;
import com.lucent.ra.nms.ui.LECompGrid;
import com.lucent.ra.nms.ui.LEErrorDialog;
import com.lucent.ra.nms.ui.LEFont;
import com.lucent.ra.nms.ui.LEUiUtils;
import com.lucent.ra.nms.util.LEVector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Label;
import java.awt.Panel;

public class LELocalIPAddressesForm
extends LETableForm {
    static final String PORTMASTER = "Device";
    static final String BLANK = "";
    String m_num;
    String m_address;

    public LELocalIPAddressesForm() {
        this.m_keyReadonly = false;
    }

    boolean addNewEntry(LEDataSpec keySpec, LEDataSpec entrySpec) {
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        Component[][] comps = new Component[2][2];
        comps[0][0] = new Label(String.valueOf(keySpec.getDescription()) + ":");
        comps[0][0].setFont(LEFont.getBoldFont());
        comps[0][1] = LEFormLineFactory.BuildFormLine(null, null, null, keySpec);
        LEDataSpec spec = entrySpec.getSpecFor("9");
        comps[1][0] = new Label(String.valueOf(spec.getDescription()) + ":");
        comps[1][0].setFont(LEFont.getBoldFont());
        comps[1][1] = LEFormLineFactory.BuildFormLine(null, null, null, spec);
        panel.add("Center", new LECompGrid(comps, 2, false));
        LEAddDialog dlg = new LEAddDialog(LEUiUtils.GetBaseFrame(), "Add Local IP address", panel);
        if (dlg.okay()) {
            this.m_num = ((LEFormLine)((Object)comps[0][1])).getValue();
            this.m_address = ((LEFormLine)((Object)comps[1][1])).getValue();
            if (this.m_address.length() > 0) {
                return true;
            }
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), "An IP address must be entered");
        }
        return false;
    }

    LENewEntry addNewEntryTo(LEPortMaster pm) {
        LENewEntry entry = null;
        LETable table = this.getTable(pm);
        if (table.get(this.m_num) == null) {
            LEVector errors = ((LELocalIPAddresses)table).add(this.m_num, this.m_address);
            if (errors != null) {
                new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), pm.getConnectionFacade(), errors);
            } else {
                this.addEntry(pm.getDescription(), table, this.m_num);
                entry = new LENewEntry(pm, table, this.m_num);
            }
        } else {
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), String.valueOf(pm.getDescription()) + " already contains a local IP address numbered " + this.m_num);
        }
        return entry;
    }

    void delete(LEPortMaster pm, LETable table, String key) {
        if (!(table instanceof LELocalIPAddresses)) {
            return;
        }
        LELocalIPAddresses local_ips = (LELocalIPAddresses)table;
        LEVector errors = local_ips.delete(key);
        if (errors != null) {
            new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), pm.getConnectionFacade(), errors);
        }
    }

    String getPasteKey(LEPortMaster pm, Object obj) {
        LEVector errors;
        if (!(obj instanceof LELocalIPAddress)) {
            return null;
        }
        LELocalIPAddress local_ip = (LELocalIPAddress)obj;
        LELocalIPAddresses local_ips = (LELocalIPAddresses)this.getTable(pm);
        String number = local_ip.getNumber();
        String address = (String)local_ip.get("9");
        if (local_ips.get(number) != null) {
            number = LETableForm.GetUniqueKey(local_ips, number, 16);
        }
        if ((errors = local_ips.add(number, address)) != null) {
            new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), pm.getConnectionFacade(), errors);
            number = null;
        }
        return number;
    }
}

