/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.forms;

import com.lucent.ra.nms.forms.LEFormLine;
import com.lucent.ra.nms.forms.LEFormLineListener;
import com.lucent.ra.nms.model.LEAttributes;
import com.lucent.ra.nms.model.LEDataSpec;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.ui.LENetmaskPanel;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEHelpManager;
import com.lucent.ra.nms.util.LENetmask;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class LENetmaskFormLine
extends LENetmaskPanel
implements LEFormLine,
MouseListener {
    LEFormLineListener m_listener;
    String m_valid;

    public LENetmaskFormLine() {
        this.addMouseListener(this);
    }

    public void initFormLine(LEPortMaster pm, LEDataSpec spec) {
        int max = 32;
        int min = 24;
        if (spec != null) {
            String attr = (String)spec.getAttribute(LEAttributes.MAXIMUM);
            if (attr != null) {
                try {
                    max = Integer.parseInt(attr);
                }
                catch (NumberFormatException e) {
                    LEDebug.getLog().logln(20, e);
                }
            }
            if ((attr = (String)spec.getAttribute(LEAttributes.MINIMUM)) != null) {
                try {
                    min = Integer.parseInt(attr);
                }
                catch (NumberFormatException e) {
                    LEDebug.getLog().logln(20, e);
                }
            }
            this.setCIDRRange(min, max);
        }
    }

    public void setListener(LEFormLineListener listener) {
        this.m_listener = listener;
    }

    public void setValue(Object field) {
        String val = field.toString();
        if (val.length() > 0) {
            this.setNetmask(val);
        }
    }

    public String getValue() {
        return this.getCIDR();
    }

    public String getValidValues() {
        if (this.m_valid == null) {
            StringBuffer buf = new StringBuffer();
            int min_cidr = this.getMinCIDR();
            int max_cidr = this.getMaxCIDR();
            buf.append(LENetmask.GetQuadFromCIDR(min_cidr));
            buf.append(" - ");
            buf.append(LENetmask.GetQuadFromCIDR(max_cidr));
            buf.append(" or /");
            buf.append(min_cidr);
            buf.append("- /");
            buf.append(max_cidr);
            this.m_valid = buf.toString();
        }
        return this.m_valid;
    }

    public boolean equalsField(Object field) {
        if (field instanceof String) {
            String val = this.getValue();
            return val.equals((String)field);
        }
        return false;
    }

    public void keyReleased(KeyEvent event) {
    }

    public void keyTyped(KeyEvent event) {
    }

    public boolean isValueValid() {
        return true;
    }

    public void mouseClicked(MouseEvent event) {
    }

    public void mouseEntered(MouseEvent event) {
        LEHelpManager.SetHelp(this.getValidValues());
    }

    public void mouseExited(MouseEvent event) {
    }

    public void mousePressed(MouseEvent event) {
    }

    public void mouseReleased(MouseEvent event) {
    }
}

