/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.forms;

import com.lucent.ra.nms.forms.LEAddDialog;
import com.lucent.ra.nms.forms.LECmdErrorDialog;
import com.lucent.ra.nms.forms.LEFormLine;
import com.lucent.ra.nms.forms.LEFormLineFactory;
import com.lucent.ra.nms.forms.LENewEntry;
import com.lucent.ra.nms.forms.LETableForm;
import com.lucent.ra.nms.model.LEDataSpec;
import com.lucent.ra.nms.model.LENetworkRanges;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.model.LETable;
import com.lucent.ra.nms.ui.LECompGrid;
import com.lucent.ra.nms.ui.LEErrorDialog;
import com.lucent.ra.nms.ui.LEFont;
import com.lucent.ra.nms.ui.LEUiUtils;
import com.lucent.ra.nms.util.LEVector;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Label;
import java.awt.Panel;

public class LENetworkRangesForm
extends LETableForm {
    public LEVector add() {
        LEVector entries = new LEVector();
        LEVector pms = new LEVector();
        if (this.m_pms.length > 1) {
            this.determinePMs(pms);
        } else {
            pms.addElement(this.m_pms[0]);
        }
        int len = pms.size();
        int i = 0;
        while (i < len) {
            LENewEntry entry;
            LEPortMaster pm = (LEPortMaster)pms.elementAt(i);
            LETable table = this.getTable(pm);
            if (table instanceof LENetworkRanges && (entry = this.add(pm, (LENetworkRanges)table)) != null) {
                entries.addElement(entry);
            }
            ++i;
        }
        this.repaint();
        return entries;
    }

    void determinePMs(LEVector pms) {
        Component[][] comps = new Component[this.m_pms.length][2];
        comps[0][0] = new Label("Add Network Range to:", 0);
        comps[0][0].setFont(LEFont.getBoldFont());
        int i = 0;
        while (i < this.m_pms.length) {
            comps[i][1] = new Checkbox(this.m_pms[i].getDescription(), true, null);
            ++i;
        }
        LEAddDialog dlg = new LEAddDialog(LEUiUtils.GetBaseFrame(), "Add Network Range", new LECompGrid(comps, 2, false));
        if (dlg.okay()) {
            int i2 = 0;
            while (i2 < this.m_pms.length) {
                if (((Checkbox)comps[i2][1]).getState()) {
                    pms.addElement(this.m_pms[i2]);
                }
                ++i2;
            }
        }
    }

    LENewEntry add(LEPortMaster pm, LENetworkRanges table) {
        if (table.size() == 8) {
            new LEErrorDialog(LEUiUtils.getFrame(this), String.valueOf(pm.getDescription()) + " already has 8 network ranges for this area");
            return null;
        }
        LENewEntry entry = null;
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        Label lbl = new Label("Add Network Range to " + pm.getDescription(), 1);
        lbl.setFont(LEFont.getBoldFont());
        panel.add("North", lbl);
        LEDataSpec keySpec = table.getKeySpec();
        LEDataSpec entrySpec = table.getSpecFor("entry");
        Component[][] comps = new Component[2][2];
        comps[0][0] = new Label(String.valueOf(keySpec.getDescription()) + ":");
        comps[0][0].setFont(LEFont.getBoldFont());
        comps[0][1] = LEFormLineFactory.BuildFormLine(pm, null, null, keySpec);
        comps[1][0] = new Label(String.valueOf(entrySpec.getDescription()) + ":");
        comps[1][0].setFont(LEFont.getBoldFont());
        comps[1][1] = LEFormLineFactory.BuildFormLine(pm, null, null, entrySpec);
        panel.add("Center", new LECompGrid(comps, 2, false));
        LEAddDialog dlg = new LEAddDialog(LEUiUtils.getFrame(this), "Add Network Range", panel);
        if (dlg.okay()) {
            String network = ((LEFormLine)((Object)comps[0][1])).getValue();
            if (!((LEFormLine)((Object)comps[0][1])).isValueValid()) {
                new LEErrorDialog(LEUiUtils.getFrame(this), "Invalid network address");
                return entry;
            }
            String advertise = ((LEFormLine)((Object)comps[1][1])).getValue();
            if (table.get(network) == null) {
                LEVector errors = table.add(network, advertise);
                if (errors != null) {
                    new LECmdErrorDialog(LEUiUtils.getFrame(this), pm.getConnectionFacade(), errors);
                }
                this.addEntry(pm.getDescription(), table, network);
                entry = new LENewEntry(pm, table, network);
            } else {
                new LEErrorDialog(LEUiUtils.getFrame(this), String.valueOf(pm.getDescription()) + " already contains the network " + network);
            }
        }
        return entry;
    }

    void delete(LEPortMaster pm, LETable table, String key) {
        if (!(table instanceof LENetworkRanges)) {
            return;
        }
        LENetworkRanges ranges = (LENetworkRanges)table;
        LEVector errors = ranges.delete(key);
        if (errors != null) {
            new LECmdErrorDialog(LEUiUtils.getFrame(this), pm.getConnectionFacade(), errors);
        }
    }
}

