/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.forms;

import com.lucent.ra.nms.forms.LEFormLine;
import com.lucent.ra.nms.forms.LEFormLineListener;
import com.lucent.ra.nms.model.LEDataSpec;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.ui.LETextField;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;

public class LEPVCFormLine
extends Panel
implements LEFormLine {
    static final int MAX_VPI = 255;
    static final int MAX_VCI = 65535;
    LEPortMaster m_pm;
    LETextField m_vpi;
    LETextField m_vci;
    String m_valid;
    LEFormLineListener m_listener;

    public LEPVCFormLine() {
        this.setLayout(new FlowLayout(0, 5, 0));
        this.add(new Label("VPI:", 0));
        this.m_vpi = new LETextField(3);
        this.m_vpi.setNumeric(true);
        this.add(this.m_vpi);
        this.m_vci = new LETextField(5);
        this.m_vci.setNumeric(true);
        this.add(new Label("VCI:", 0));
        this.add(this.m_vci);
    }

    public void initFormLine(LEPortMaster pm, LEDataSpec spec) {
    }

    public void setListener(LEFormLineListener listener) {
        this.m_listener = listener;
    }

    public void setValue(Object field) {
        if (field instanceof String) {
            String value = (String)field;
            int pos = value.indexOf(".");
            if (pos > -1) {
                ((TextComponent)this.m_vpi).setText(value.substring(0, pos));
                ((TextComponent)this.m_vci).setText(value.substring(pos + 1));
            } else {
                ((TextComponent)this.m_vpi).setText("");
                ((TextComponent)this.m_vci).setText("");
            }
        }
    }

    public String getValue() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.m_vpi.getText());
        buf.append(".");
        buf.append(this.m_vci.getText());
        return new String(buf);
    }

    public String getValidValues() {
        if (this.m_valid == null) {
            StringBuffer buf = new StringBuffer();
            buf.append("VPI is between 0 and ");
            buf.append(255);
            buf.append(". VCI is between 0 and ");
            buf.append(65535);
            buf.append(".");
            this.m_valid = buf.toString();
        }
        return this.m_valid;
    }

    public boolean equalsField(Object field) {
        return this.getValue().equals(field);
    }

    public boolean isValueValid() {
        String vpi = this.m_vpi.getText();
        String vci = this.m_vci.getText();
        try {
            int vpinum = Integer.parseInt(vpi);
            int vcinum = Integer.parseInt(vci);
            if (vpinum < 0 && vpinum > 255) {
                return false;
            }
            if (vcinum < 0 && vcinum > 65535) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }
}

