/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.forms;

import com.lucent.ra.nms.forms.LECmdErrorDialog;
import com.lucent.ra.nms.model.LECustomPlans;
import com.lucent.ra.nms.ui.LEStatusDialog;
import com.lucent.ra.nms.ui.LEUiUtils;
import com.lucent.ra.nms.util.LEVector;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class LESaveCustomPlansDialog
extends Dialog
implements ActionListener {
    public static final String OK = "Yes";
    public static final String CANCEL = "No";
    Button m_ok;
    Button m_cancel;
    LEVector m_plans;
    Frame m_parent;
    static String[] s_msgs = new String[]{"Custom plan data has been changed.", "Do you want to save the changes?"};

    public LESaveCustomPlansDialog(Frame parent, LEVector plans, String[] msgs) {
        super(parent, "Save", true);
        this.m_plans = plans;
        this.m_parent = parent;
        this.setLayout(new BorderLayout(5, 5));
        Panel sub = new Panel();
        sub.setLayout(new GridLayout(msgs.length, 1));
        int i = 0;
        while (i < msgs.length) {
            sub.add(new Label(msgs[i], 1));
            ++i;
        }
        this.add("Center", sub);
        sub = new Panel();
        sub.setLayout(new FlowLayout(1));
        Panel btns = new Panel();
        btns.setLayout(new GridLayout(1, 2));
        this.m_ok = new Button(OK);
        btns.add(this.m_ok);
        this.m_ok.addActionListener(this);
        this.m_cancel = new Button(CANCEL);
        btns.add(this.m_cancel);
        this.m_cancel.addActionListener(this);
        sub.add(btns);
        this.add("South", sub);
        ((Component)this).setVisible(true);
    }

    public LESaveCustomPlansDialog(Frame parent, LEVector plans) {
        this(parent, plans, s_msgs);
    }

    public void addNotify() {
        super.addNotify();
        Dimension dim = this.getPreferredSize();
        LEUiUtils.CenterDialog(this, dim.width + 10, dim.height);
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.m_ok) {
            this.ok();
        } else if (event.getSource() == this.m_cancel) {
            this.cancel();
        }
        ((Component)this).setVisible(false);
        this.dispose();
    }

    void ok() {
        boolean reboot = false;
        LEVector cmds = new LEVector();
        int len = this.m_plans.size();
        int i = 0;
        while (i < len) {
            LECustomPlans plan = (LECustomPlans)this.m_plans.elementAt(i);
            plan.getCommands(cmds);
            LEVector errors = null;
            LEStatusDialog dlg1 = new LEStatusDialog(this.m_parent);
            errors = plan.saveChanges(cmds, reboot);
            dlg1.hideStatus();
            if (errors != null) {
                new LECmdErrorDialog(this.m_parent, plan.getConnectionFacade(), errors);
                LEStatusDialog dlg2 = new LEStatusDialog(this.m_parent);
                plan.refresh();
                dlg2.hideStatus();
            }
            ++i;
        }
    }

    void cancel() {
    }
}

